/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiWeekDay;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiConfiguration
implements UiObject {
    protected String isoLanguage = "en";
    protected String timeZoneId = "Europe/Berlin";
    protected String dateFormat = "yyyy-MM-dd";
    protected String timeFormat = "HH:mm";
    protected UiWeekDay firstDayOfWeek = UiWeekDay.MONDAY;
    protected String decimalSeparator = ".";
    protected String thousandsSeparator = "";
    protected String themeClassName = null;
    protected boolean optimizedForTouch = false;
    protected String iconPath = "icons";

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_CONFIGURATION;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("timeZoneId=" + this.timeZoneId) + ", " + ("themeClassName=" + this.themeClassName) + ", " + ("isoLanguage=" + this.isoLanguage) + ", " + ("dateFormat=" + this.dateFormat) + ", " + ("timeFormat=" + this.timeFormat) + ", " + ("firstDayOfWeek=" + this.firstDayOfWeek) + ", " + ("decimalSeparator=" + this.decimalSeparator) + ", " + ("thousandsSeparator=" + this.thousandsSeparator) + ", " + ("optimizedForTouch=" + this.optimizedForTouch) + ", " + ("iconPath=" + this.iconPath);
    }

    @JsonGetter(value="isoLanguage")
    public String getIsoLanguage() {
        return this.isoLanguage;
    }

    @JsonGetter(value="timeZoneId")
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @JsonGetter(value="dateFormat")
    public String getDateFormat() {
        return this.dateFormat;
    }

    @JsonGetter(value="timeFormat")
    public String getTimeFormat() {
        return this.timeFormat;
    }

    @JsonGetter(value="firstDayOfWeek")
    public UiWeekDay getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    @JsonGetter(value="decimalSeparator")
    public String getDecimalSeparator() {
        return this.decimalSeparator;
    }

    @JsonGetter(value="thousandsSeparator")
    public String getThousandsSeparator() {
        return this.thousandsSeparator;
    }

    @JsonGetter(value="themeClassName")
    public String getThemeClassName() {
        return this.themeClassName;
    }

    @JsonGetter(value="optimizedForTouch")
    public boolean getOptimizedForTouch() {
        return this.optimizedForTouch;
    }

    @JsonGetter(value="iconPath")
    public String getIconPath() {
        return this.iconPath;
    }

    @JsonSetter(value="isoLanguage")
    public UiConfiguration setIsoLanguage(String isoLanguage) {
        this.isoLanguage = isoLanguage;
        return this;
    }

    @JsonSetter(value="timeZoneId")
    public UiConfiguration setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
        return this;
    }

    @JsonSetter(value="dateFormat")
    public UiConfiguration setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    @JsonSetter(value="timeFormat")
    public UiConfiguration setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
        return this;
    }

    @JsonSetter(value="firstDayOfWeek")
    public UiConfiguration setFirstDayOfWeek(UiWeekDay firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        return this;
    }

    @JsonSetter(value="decimalSeparator")
    public UiConfiguration setDecimalSeparator(String decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
        return this;
    }

    @JsonSetter(value="thousandsSeparator")
    public UiConfiguration setThousandsSeparator(String thousandsSeparator) {
        this.thousandsSeparator = thousandsSeparator;
        return this;
    }

    @JsonSetter(value="themeClassName")
    public UiConfiguration setThemeClassName(String themeClassName) {
        this.themeClassName = themeClassName;
        return this;
    }

    @JsonSetter(value="optimizedForTouch")
    public UiConfiguration setOptimizedForTouch(boolean optimizedForTouch) {
        this.optimizedForTouch = optimizedForTouch;
        return this;
    }

    @JsonSetter(value="iconPath")
    public UiConfiguration setIconPath(String iconPath) {
        this.iconPath = iconPath;
        return this;
    }
}

