/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiHorizontalElementAlignment;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.dto.UiItemJustification;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;
import org.teamapps.dto.UiVerticalElementAlignment;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiInfiniteItemView2.class)
public class UiInfiniteItemView2
extends UiComponent
implements UiObject {
    protected UiTemplate itemTemplate;
    protected float itemWidth = 0.0f;
    protected float itemHeight = 100.0f;
    protected float horizontalSpacing;
    protected float verticalSpacing;
    protected float itemPositionAnimationTime;
    protected UiHorizontalElementAlignment itemContentHorizontalAlignment = UiHorizontalElementAlignment.CENTER;
    protected UiVerticalElementAlignment itemContentVerticalAlignment = UiVerticalElementAlignment.STRETCH;
    protected UiItemJustification rowHorizontalAlignment = UiItemJustification.SPACE_AROUND;
    protected boolean contextMenuEnabled = false;

    @Deprecated
    public UiInfiniteItemView2() {
    }

    public UiInfiniteItemView2(UiTemplate itemTemplate) {
        this.itemTemplate = itemTemplate;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_INFINITE_ITEM_VIEW2;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + (String)(this.itemTemplate != null ? "itemTemplate={" + this.itemTemplate.toString() + "}" : "") + ", " + ("itemWidth=" + this.itemWidth) + ", " + ("itemHeight=" + this.itemHeight) + ", " + ("horizontalSpacing=" + this.horizontalSpacing) + ", " + ("verticalSpacing=" + this.verticalSpacing) + ", " + ("itemPositionAnimationTime=" + this.itemPositionAnimationTime) + ", " + ("itemContentHorizontalAlignment=" + this.itemContentHorizontalAlignment) + ", " + ("itemContentVerticalAlignment=" + this.itemContentVerticalAlignment) + ", " + ("rowHorizontalAlignment=" + this.rowHorizontalAlignment) + ", " + ("contextMenuEnabled=" + this.contextMenuEnabled);
    }

    @JsonGetter(value="itemTemplate")
    public UiTemplate getItemTemplate() {
        return this.itemTemplate;
    }

    @JsonGetter(value="itemWidth")
    public float getItemWidth() {
        return this.itemWidth;
    }

    @JsonGetter(value="itemHeight")
    public float getItemHeight() {
        return this.itemHeight;
    }

    @JsonGetter(value="horizontalSpacing")
    public float getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    @JsonGetter(value="verticalSpacing")
    public float getVerticalSpacing() {
        return this.verticalSpacing;
    }

    @JsonGetter(value="itemPositionAnimationTime")
    public float getItemPositionAnimationTime() {
        return this.itemPositionAnimationTime;
    }

    @JsonGetter(value="itemContentHorizontalAlignment")
    public UiHorizontalElementAlignment getItemContentHorizontalAlignment() {
        return this.itemContentHorizontalAlignment;
    }

    @JsonGetter(value="itemContentVerticalAlignment")
    public UiVerticalElementAlignment getItemContentVerticalAlignment() {
        return this.itemContentVerticalAlignment;
    }

    @JsonGetter(value="rowHorizontalAlignment")
    public UiItemJustification getRowHorizontalAlignment() {
        return this.rowHorizontalAlignment;
    }

    @JsonGetter(value="contextMenuEnabled")
    public boolean getContextMenuEnabled() {
        return this.contextMenuEnabled;
    }

    @Override
    @JsonSetter(value="id")
    public UiInfiniteItemView2 setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiInfiniteItemView2 setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiInfiniteItemView2 setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiInfiniteItemView2 setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiInfiniteItemView2 setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiInfiniteItemView2 setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="itemWidth")
    public UiInfiniteItemView2 setItemWidth(float itemWidth) {
        this.itemWidth = itemWidth;
        return this;
    }

    @JsonSetter(value="itemHeight")
    public UiInfiniteItemView2 setItemHeight(float itemHeight) {
        this.itemHeight = itemHeight;
        return this;
    }

    @JsonSetter(value="horizontalSpacing")
    public UiInfiniteItemView2 setHorizontalSpacing(float horizontalSpacing) {
        this.horizontalSpacing = horizontalSpacing;
        return this;
    }

    @JsonSetter(value="verticalSpacing")
    public UiInfiniteItemView2 setVerticalSpacing(float verticalSpacing) {
        this.verticalSpacing = verticalSpacing;
        return this;
    }

    @JsonSetter(value="itemPositionAnimationTime")
    public UiInfiniteItemView2 setItemPositionAnimationTime(float itemPositionAnimationTime) {
        this.itemPositionAnimationTime = itemPositionAnimationTime;
        return this;
    }

    @JsonSetter(value="itemContentHorizontalAlignment")
    public UiInfiniteItemView2 setItemContentHorizontalAlignment(UiHorizontalElementAlignment itemContentHorizontalAlignment) {
        this.itemContentHorizontalAlignment = itemContentHorizontalAlignment;
        return this;
    }

    @JsonSetter(value="itemContentVerticalAlignment")
    public UiInfiniteItemView2 setItemContentVerticalAlignment(UiVerticalElementAlignment itemContentVerticalAlignment) {
        this.itemContentVerticalAlignment = itemContentVerticalAlignment;
        return this;
    }

    @JsonSetter(value="rowHorizontalAlignment")
    public UiInfiniteItemView2 setRowHorizontalAlignment(UiItemJustification rowHorizontalAlignment) {
        this.rowHorizontalAlignment = rowHorizontalAlignment;
        return this;
    }

    @JsonSetter(value="contextMenuEnabled")
    public UiInfiniteItemView2 setContextMenuEnabled(boolean contextMenuEnabled) {
        this.contextMenuEnabled = contextMenuEnabled;
        return this;
    }

    public static class CloseContextMenuCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int requestId;

        @Deprecated
        public CloseContextMenuCommand() {
        }

        public CloseContextMenuCommand(String componentId, int requestId) {
            this.componentId = componentId;
            this.requestId = requestId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestId=" + this.requestId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestId")
        public int getRequestId() {
            return this.requestId;
        }
    }

    public static class SetContextMenuContentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int requestId;
        protected UiClientObjectReference component;

        @Deprecated
        public SetContextMenuContentCommand() {
        }

        public SetContextMenuContentCommand(String componentId, int requestId, UiClientObjectReference component) {
            this.componentId = componentId;
            this.requestId = requestId;
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestId=" + this.requestId) + ", " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestId")
        public int getRequestId() {
            return this.requestId;
        }

        @JsonGetter(value="component")
        public UiClientObjectReference getComponent() {
            return this.component;
        }
    }

    public static class SetItemPositionAnimationTimeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int animationMillis;

        @Deprecated
        public SetItemPositionAnimationTimeCommand() {
        }

        public SetItemPositionAnimationTimeCommand(String componentId, int animationMillis) {
            this.componentId = componentId;
            this.animationMillis = animationMillis;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("animationMillis=" + this.animationMillis);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="animationMillis")
        public int getAnimationMillis() {
            return this.animationMillis;
        }
    }

    public static class SetRowHorizontalAlignmentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiItemJustification rowHorizontalAlignment;

        @Deprecated
        public SetRowHorizontalAlignmentCommand() {
        }

        public SetRowHorizontalAlignmentCommand(String componentId, UiItemJustification rowHorizontalAlignment) {
            this.componentId = componentId;
            this.rowHorizontalAlignment = rowHorizontalAlignment;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("rowHorizontalAlignment=" + this.rowHorizontalAlignment);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="rowHorizontalAlignment")
        public UiItemJustification getRowHorizontalAlignment() {
            return this.rowHorizontalAlignment;
        }
    }

    public static class SetItemContentVerticalAlignmentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiVerticalElementAlignment itemContentVerticalAlignment;

        @Deprecated
        public SetItemContentVerticalAlignmentCommand() {
        }

        public SetItemContentVerticalAlignmentCommand(String componentId, UiVerticalElementAlignment itemContentVerticalAlignment) {
            this.componentId = componentId;
            this.itemContentVerticalAlignment = itemContentVerticalAlignment;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("itemContentVerticalAlignment=" + this.itemContentVerticalAlignment);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="itemContentVerticalAlignment")
        public UiVerticalElementAlignment getItemContentVerticalAlignment() {
            return this.itemContentVerticalAlignment;
        }
    }

    public static class SetItemContentHorizontalAlignmentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiHorizontalElementAlignment itemContentHorizontalAlignment;

        @Deprecated
        public SetItemContentHorizontalAlignmentCommand() {
        }

        public SetItemContentHorizontalAlignmentCommand(String componentId, UiHorizontalElementAlignment itemContentHorizontalAlignment) {
            this.componentId = componentId;
            this.itemContentHorizontalAlignment = itemContentHorizontalAlignment;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("itemContentHorizontalAlignment=" + this.itemContentHorizontalAlignment);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="itemContentHorizontalAlignment")
        public UiHorizontalElementAlignment getItemContentHorizontalAlignment() {
            return this.itemContentHorizontalAlignment;
        }
    }

    public static class SetVerticalSpacingCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected float verticalSpacing;

        @Deprecated
        public SetVerticalSpacingCommand() {
        }

        public SetVerticalSpacingCommand(String componentId, float verticalSpacing) {
            this.componentId = componentId;
            this.verticalSpacing = verticalSpacing;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("verticalSpacing=" + this.verticalSpacing);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="verticalSpacing")
        public float getVerticalSpacing() {
            return this.verticalSpacing;
        }
    }

    public static class SetHorizontalSpacingCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected float horizontalSpacing;

        @Deprecated
        public SetHorizontalSpacingCommand() {
        }

        public SetHorizontalSpacingCommand(String componentId, float horizontalSpacing) {
            this.componentId = componentId;
            this.horizontalSpacing = horizontalSpacing;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("horizontalSpacing=" + this.horizontalSpacing);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="horizontalSpacing")
        public float getHorizontalSpacing() {
            return this.horizontalSpacing;
        }
    }

    public static class SetItemHeightCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected float itemHeight;

        @Deprecated
        public SetItemHeightCommand() {
        }

        public SetItemHeightCommand(String componentId, float itemHeight) {
            this.componentId = componentId;
            this.itemHeight = itemHeight;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("itemHeight=" + this.itemHeight);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="itemHeight")
        public float getItemHeight() {
            return this.itemHeight;
        }
    }

    public static class SetItemWidthCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected float itemWidth;

        @Deprecated
        public SetItemWidthCommand() {
        }

        public SetItemWidthCommand(String componentId, float itemWidth) {
            this.componentId = componentId;
            this.itemWidth = itemWidth;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("itemWidth=" + this.itemWidth);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="itemWidth")
        public float getItemWidth() {
            return this.itemWidth;
        }
    }

    public static class SetItemTemplateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiTemplate itemTemplate;

        @Deprecated
        public SetItemTemplateCommand() {
        }

        public SetItemTemplateCommand(String componentId, UiTemplate itemTemplate) {
            this.componentId = componentId;
            this.itemTemplate = itemTemplate;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.itemTemplate != null ? "itemTemplate={" + this.itemTemplate.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="itemTemplate")
        public UiTemplate getItemTemplate() {
            return this.itemTemplate;
        }
    }

    public static class SetDataCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int startIndex;
        protected List<Integer> recordIds;
        protected List<UiIdentifiableClientRecord> newRecords;
        protected int totalNumberOfRecords;

        @Deprecated
        public SetDataCommand() {
        }

        public SetDataCommand(String componentId, int startIndex, List<Integer> recordIds, List<UiIdentifiableClientRecord> newRecords, int totalNumberOfRecords) {
            this.componentId = componentId;
            this.startIndex = startIndex;
            this.recordIds = recordIds;
            this.newRecords = newRecords;
            this.totalNumberOfRecords = totalNumberOfRecords;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordIds=" + this.recordIds) + ", " + ("startIndex=" + this.startIndex) + ", " + ("totalNumberOfRecords=" + this.totalNumberOfRecords) + ", " + (String)(this.newRecords != null ? "newRecords={" + this.newRecords.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="startIndex")
        public int getStartIndex() {
            return this.startIndex;
        }

        @JsonGetter(value="recordIds")
        public List<Integer> getRecordIds() {
            return this.recordIds;
        }

        @JsonGetter(value="newRecords")
        public List<UiIdentifiableClientRecord> getNewRecords() {
            return this.newRecords;
        }

        @JsonGetter(value="totalNumberOfRecords")
        public int getTotalNumberOfRecords() {
            return this.totalNumberOfRecords;
        }
    }

    public static class ContextMenuRequestedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int requestId;
        protected int recordId;

        @Deprecated
        public ContextMenuRequestedEvent() {
        }

        public ContextMenuRequestedEvent(String componentId, int requestId, int recordId) {
            this.componentId = componentId;
            this.requestId = requestId;
            this.recordId = recordId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_INFINITE_ITEM_VIEW2_CONTEXT_MENU_REQUESTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestId=" + this.requestId) + ", " + ("recordId=" + this.recordId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestId")
        public int getRequestId() {
            return this.requestId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }
    }

    public static class ItemClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int recordId;
        protected boolean isRightMouseButton;
        protected boolean isDoubleClick;

        @Deprecated
        public ItemClickedEvent() {
        }

        public ItemClickedEvent(String componentId, int recordId, boolean isRightMouseButton, boolean isDoubleClick) {
            this.componentId = componentId;
            this.recordId = recordId;
            this.isRightMouseButton = isRightMouseButton;
            this.isDoubleClick = isDoubleClick;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_INFINITE_ITEM_VIEW2_ITEM_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId) + ", " + ("isRightMouseButton=" + this.isRightMouseButton) + ", " + ("isDoubleClick=" + this.isDoubleClick);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }

        @JsonGetter(value="isRightMouseButton")
        public boolean getIsRightMouseButton() {
            return this.isRightMouseButton;
        }

        @JsonGetter(value="isDoubleClick")
        public boolean getIsDoubleClick() {
            return this.isDoubleClick;
        }
    }

    public static class RenderedItemRangeChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int startIndex;
        protected int endIndex;

        @Deprecated
        public RenderedItemRangeChangedEvent() {
        }

        public RenderedItemRangeChangedEvent(String componentId, int startIndex, int endIndex) {
            this.componentId = componentId;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_INFINITE_ITEM_VIEW2_RENDERED_ITEM_RANGE_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("startIndex=" + this.startIndex) + ", " + ("endIndex=" + this.endIndex);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="startIndex")
        public int getStartIndex() {
            return this.startIndex;
        }

        @JsonGetter(value="endIndex")
        public int getEndIndex() {
            return this.endIndex;
        }
    }
}

