package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiMobileLayout extends UiComponent implements UiObject {


	protected UiComponentReference toolbar;
	protected List<UiComponentReference> views;
	protected String initialViewId;
	protected UiComponentReference navigationBar;

	public UiMobileLayout() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_MOBILE_LAYOUT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("initialViewId=" + initialViewId).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append(toolbar != null ? "toolbar={" + toolbar.toString() + "}" : "").append(", ")
				.append(views != null ? "views={" + views.toString() + "}" : "").append(", ")
				.append(navigationBar != null ? "navigationBar={" + navigationBar.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("toolbar")
	public UiComponentReference getToolbar() {
		return toolbar;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("views")
	public List<UiComponentReference> getViews() {
		return views;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("initialViewId")
	public String getInitialViewId() {
		return initialViewId;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("navigationBar")
	public UiComponentReference getNavigationBar() {
		return navigationBar;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiMobileLayout setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiMobileLayout setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiMobileLayout setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("toolbar")
	public UiMobileLayout setToolbar(UiComponentReference toolbar) {
		this.toolbar = toolbar;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("views")
	public UiMobileLayout setViews(List<UiComponentReference> views) {
		this.views = views;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("initialViewId")
	public UiMobileLayout setInitialViewId(String initialViewId) {
		this.initialViewId = initialViewId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("navigationBar")
	public UiMobileLayout setNavigationBar(UiComponentReference navigationBar) {
		this.navigationBar = navigationBar;
		return this;
	}


	public static class SetToolbarCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference toolbar;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetToolbarCommand() {
			// default constructor for Jackson
		}

		public SetToolbarCommand(String componentId, UiComponentReference toolbar) {
			this.componentId = componentId;
			this.toolbar = toolbar;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(toolbar != null ? "toolbar={" + toolbar.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("toolbar")
		public UiComponentReference getToolbar() {
			return toolbar;
		}

	}

	public static class SetNavigationBarCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference navBar;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetNavigationBarCommand() {
			// default constructor for Jackson
		}

		public SetNavigationBarCommand(String componentId, UiComponentReference navBar) {
			this.componentId = componentId;
			this.navBar = navBar;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(navBar != null ? "navBar={" + navBar.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("navBar")
		public UiComponentReference getNavBar() {
			return navBar;
		}

	}

	public static class AddViewCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference view;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddViewCommand() {
			// default constructor for Jackson
		}

		public AddViewCommand(String componentId, UiComponentReference view) {
			this.componentId = componentId;
			this.view = view;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(view != null ? "view={" + view.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("view")
		public UiComponentReference getView() {
			return view;
		}

	}

	public static class ShowViewCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String viewId;
		protected UiMobileLayoutAnimation animation;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ShowViewCommand() {
			// default constructor for Jackson
		}

		public ShowViewCommand(String componentId, String viewId, UiMobileLayoutAnimation animation) {
			this.componentId = componentId;
			this.viewId = viewId;
			this.animation = animation;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewId=" + viewId).append(", ")
					.append("animation=" + animation)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewId")
		public String getViewId() {
			return viewId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("animation")
		public UiMobileLayoutAnimation getAnimation() {
			return animation;
		}

	}

	public static class RemoveViewCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String viewId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveViewCommand() {
			// default constructor for Jackson
		}

		public RemoveViewCommand(String componentId, String viewId) {
			this.componentId = componentId;
			this.viewId = viewId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewId=" + viewId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewId")
		public String getViewId() {
			return viewId;
		}

	}




}