/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiComponentReference;
import org.teamapps.dto.UiMobileLayoutAnimation;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiMobileLayout
extends UiComponent
implements UiObject {
    protected UiComponentReference toolbar;
    protected List<UiComponentReference> views;
    protected String initialViewId;
    protected UiComponentReference navigationBar;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_MOBILE_LAYOUT;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("initialViewId=" + this.initialViewId) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + (String)(this.toolbar != null ? "toolbar={" + this.toolbar.toString() + "}" : "") + ", " + (String)(this.views != null ? "views={" + this.views.toString() + "}" : "") + ", " + (String)(this.navigationBar != null ? "navigationBar={" + this.navigationBar.toString() + "}" : "");
    }

    @JsonGetter(value="toolbar")
    public UiComponentReference getToolbar() {
        return this.toolbar;
    }

    @JsonGetter(value="views")
    public List<UiComponentReference> getViews() {
        return this.views;
    }

    @JsonGetter(value="initialViewId")
    public String getInitialViewId() {
        return this.initialViewId;
    }

    @JsonGetter(value="navigationBar")
    public UiComponentReference getNavigationBar() {
        return this.navigationBar;
    }

    @Override
    @JsonSetter(value="id")
    public UiMobileLayout setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiMobileLayout setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiMobileLayout setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="toolbar")
    public UiMobileLayout setToolbar(UiComponentReference toolbar) {
        this.toolbar = toolbar;
        return this;
    }

    @JsonSetter(value="views")
    public UiMobileLayout setViews(List<UiComponentReference> views) {
        this.views = views;
        return this;
    }

    @JsonSetter(value="initialViewId")
    public UiMobileLayout setInitialViewId(String initialViewId) {
        this.initialViewId = initialViewId;
        return this;
    }

    @JsonSetter(value="navigationBar")
    public UiMobileLayout setNavigationBar(UiComponentReference navigationBar) {
        this.navigationBar = navigationBar;
        return this;
    }

    public static class RemoveViewCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String viewId;

        @Deprecated
        public RemoveViewCommand() {
        }

        public RemoveViewCommand(String componentId, String viewId) {
            this.componentId = componentId;
            this.viewId = viewId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewId=" + this.viewId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewId")
        public String getViewId() {
            return this.viewId;
        }
    }

    public static class ShowViewCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String viewId;
        protected UiMobileLayoutAnimation animation;

        @Deprecated
        public ShowViewCommand() {
        }

        public ShowViewCommand(String componentId, String viewId, UiMobileLayoutAnimation animation) {
            this.componentId = componentId;
            this.viewId = viewId;
            this.animation = animation;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewId=" + this.viewId) + ", " + ("animation=" + this.animation);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewId")
        public String getViewId() {
            return this.viewId;
        }

        @JsonGetter(value="animation")
        public UiMobileLayoutAnimation getAnimation() {
            return this.animation;
        }
    }

    public static class AddViewCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiComponentReference view;

        @Deprecated
        public AddViewCommand() {
        }

        public AddViewCommand(String componentId, UiComponentReference view) {
            this.componentId = componentId;
            this.view = view;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.view != null ? "view={" + this.view.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="view")
        public UiComponentReference getView() {
            return this.view;
        }
    }

    public static class SetNavigationBarCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiComponentReference navBar;

        @Deprecated
        public SetNavigationBarCommand() {
        }

        public SetNavigationBarCommand(String componentId, UiComponentReference navBar) {
            this.componentId = componentId;
            this.navBar = navBar;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.navBar != null ? "navBar={" + this.navBar.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="navBar")
        public UiComponentReference getNavBar() {
            return this.navBar;
        }
    }

    public static class SetToolbarCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiComponentReference toolbar;

        @Deprecated
        public SetToolbarCommand() {
        }

        public SetToolbarCommand(String componentId, UiComponentReference toolbar) {
            this.componentId = componentId;
            this.toolbar = toolbar;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.toolbar != null ? "toolbar={" + this.toolbar.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="toolbar")
        public UiComponentReference getToolbar() {
            return this.toolbar;
        }
    }
}

