/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiCssAlignItems;
import org.teamapps.dto.UiCssFlexDirection;
import org.teamapps.dto.UiCssJustifyContent;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiFlexContainer.class)
public class UiFlexContainer
extends UiComponent
implements UiObject {
    protected List<UiClientObjectReference> components;
    protected UiCssFlexDirection flexDirection = UiCssFlexDirection.ROW;
    protected UiCssAlignItems alignItems = UiCssAlignItems.STRETCH;
    protected UiCssJustifyContent justifyContent = UiCssJustifyContent.FLEX_START;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_FLEX_CONTAINER;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + ("flexDirection=" + this.flexDirection) + ", " + ("alignItems=" + this.alignItems) + ", " + ("justifyContent=" + this.justifyContent) + ", " + (String)(this.components != null ? "components={" + this.components.toString() + "}" : "");
    }

    @JsonGetter(value="components")
    public List<UiClientObjectReference> getComponents() {
        return this.components;
    }

    @JsonGetter(value="flexDirection")
    public UiCssFlexDirection getFlexDirection() {
        return this.flexDirection;
    }

    @JsonGetter(value="alignItems")
    public UiCssAlignItems getAlignItems() {
        return this.alignItems;
    }

    @JsonGetter(value="justifyContent")
    public UiCssJustifyContent getJustifyContent() {
        return this.justifyContent;
    }

    @Override
    @JsonSetter(value="id")
    public UiFlexContainer setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiFlexContainer setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiFlexContainer setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiFlexContainer setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiFlexContainer setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiFlexContainer setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="components")
    public UiFlexContainer setComponents(List<UiClientObjectReference> components) {
        this.components = components;
        return this;
    }

    @JsonSetter(value="flexDirection")
    public UiFlexContainer setFlexDirection(UiCssFlexDirection flexDirection) {
        this.flexDirection = flexDirection;
        return this;
    }

    @JsonSetter(value="alignItems")
    public UiFlexContainer setAlignItems(UiCssAlignItems alignItems) {
        this.alignItems = alignItems;
        return this;
    }

    @JsonSetter(value="justifyContent")
    public UiFlexContainer setJustifyContent(UiCssJustifyContent justifyContent) {
        this.justifyContent = justifyContent;
        return this;
    }

    public static class RemoveComponentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiClientObjectReference component;

        @Deprecated
        public RemoveComponentCommand() {
        }

        public RemoveComponentCommand(String componentId, UiClientObjectReference component) {
            this.componentId = componentId;
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="component")
        public UiClientObjectReference getComponent() {
            return this.component;
        }
    }

    public static class AddComponentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiClientObjectReference component;

        @Deprecated
        public AddComponentCommand() {
        }

        public AddComponentCommand(String componentId, UiClientObjectReference component) {
            this.componentId = componentId;
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="component")
        public UiClientObjectReference getComponent() {
            return this.component;
        }
    }
}

