/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.UiCachedImage;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiPageDisplayMode;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiImageDisplay.class)
public class UiImageDisplay
extends UiComponent
implements UiObject {
    protected int totalNumberOfRecords;
    protected List<UiCachedImage> cachedImages;
    protected UiPageDisplayMode displayMode = UiPageDisplayMode.FIT_WIDTH;
    protected float zoomFactor = 1.0f;
    protected String backgroundColor = "#444";
    protected int padding = 0;
    protected boolean loop = false;
    protected int cacheSize = 2;

    @Deprecated
    public UiImageDisplay() {
    }

    public UiImageDisplay(int totalNumberOfRecords) {
        this.totalNumberOfRecords = totalNumberOfRecords;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_IMAGE_DISPLAY;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + ("totalNumberOfRecords=" + this.totalNumberOfRecords) + ", " + ("displayMode=" + this.displayMode) + ", " + ("zoomFactor=" + this.zoomFactor) + ", " + ("backgroundColor=" + this.backgroundColor) + ", " + ("padding=" + this.padding) + ", " + ("loop=" + this.loop) + ", " + ("cacheSize=" + this.cacheSize) + ", " + (String)(this.cachedImages != null ? "cachedImages={" + this.cachedImages.toString() + "}" : "");
    }

    @JsonGetter(value="totalNumberOfRecords")
    public int getTotalNumberOfRecords() {
        return this.totalNumberOfRecords;
    }

    @JsonGetter(value="cachedImages")
    public List<UiCachedImage> getCachedImages() {
        return this.cachedImages;
    }

    @JsonGetter(value="displayMode")
    public UiPageDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @JsonGetter(value="zoomFactor")
    public float getZoomFactor() {
        return this.zoomFactor;
    }

    @JsonGetter(value="backgroundColor")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonGetter(value="padding")
    public int getPadding() {
        return this.padding;
    }

    @JsonGetter(value="loop")
    public boolean getLoop() {
        return this.loop;
    }

    @JsonGetter(value="cacheSize")
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    @JsonSetter(value="id")
    public UiImageDisplay setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiImageDisplay setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiImageDisplay setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiImageDisplay setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiImageDisplay setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiImageDisplay setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="cachedImages")
    public UiImageDisplay setCachedImages(List<UiCachedImage> cachedImages) {
        this.cachedImages = cachedImages;
        return this;
    }

    @JsonSetter(value="displayMode")
    public UiImageDisplay setDisplayMode(UiPageDisplayMode displayMode) {
        this.displayMode = displayMode;
        return this;
    }

    @JsonSetter(value="zoomFactor")
    public UiImageDisplay setZoomFactor(float zoomFactor) {
        this.zoomFactor = zoomFactor;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public UiImageDisplay setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="padding")
    public UiImageDisplay setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    @JsonSetter(value="loop")
    public UiImageDisplay setLoop(boolean loop) {
        this.loop = loop;
        return this;
    }

    @JsonSetter(value="cacheSize")
    public UiImageDisplay setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public static class ShowImageCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String id;

        @Deprecated
        public ShowImageCommand() {
        }

        public ShowImageCommand(String componentId, String id) {
            this.componentId = componentId;
            this.id = id;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }
    }

    public static class SetZoomFactorCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected float zoomFactor;

        @Deprecated
        public SetZoomFactorCommand() {
        }

        public SetZoomFactorCommand(String componentId, float zoomFactor) {
            this.componentId = componentId;
            this.zoomFactor = zoomFactor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("zoomFactor=" + this.zoomFactor);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="zoomFactor")
        public float getZoomFactor() {
            return this.zoomFactor;
        }
    }

    public static class SetDisplayModeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiPageDisplayMode displayMode;
        protected float zoomFactor;

        @Deprecated
        public SetDisplayModeCommand() {
        }

        public SetDisplayModeCommand(String componentId, UiPageDisplayMode displayMode, float zoomFactor) {
            this.componentId = componentId;
            this.displayMode = displayMode;
            this.zoomFactor = zoomFactor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("displayMode=" + this.displayMode) + ", " + ("zoomFactor=" + this.zoomFactor);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="displayMode")
        public UiPageDisplayMode getDisplayMode() {
            return this.displayMode;
        }

        @JsonGetter(value="zoomFactor")
        public float getZoomFactor() {
            return this.zoomFactor;
        }
    }

    public static class SetCachedImagesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int startIndex;
        protected List<UiCachedImage> cachedImages;
        protected int totalNumberOfRecords;

        @Deprecated
        public SetCachedImagesCommand() {
        }

        public SetCachedImagesCommand(String componentId, int startIndex, List<UiCachedImage> cachedImages, int totalNumberOfRecords) {
            this.componentId = componentId;
            this.startIndex = startIndex;
            this.cachedImages = cachedImages;
            this.totalNumberOfRecords = totalNumberOfRecords;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("startIndex=" + this.startIndex) + ", " + ("totalNumberOfRecords=" + this.totalNumberOfRecords) + ", " + (String)(this.cachedImages != null ? "cachedImages={" + this.cachedImages.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="startIndex")
        public int getStartIndex() {
            return this.startIndex;
        }

        @JsonGetter(value="cachedImages")
        public List<UiCachedImage> getCachedImages() {
            return this.cachedImages;
        }

        @JsonGetter(value="totalNumberOfRecords")
        public int getTotalNumberOfRecords() {
            return this.totalNumberOfRecords;
        }
    }

    public static class ImageDisplayedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String imageId;

        @Deprecated
        public ImageDisplayedEvent() {
        }

        public ImageDisplayedEvent(String componentId, String imageId) {
            this.componentId = componentId;
            this.imageId = imageId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_IMAGE_DISPLAY_IMAGE_DISPLAYED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("imageId=" + this.imageId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="imageId")
        public String getImageId() {
            return this.imageId;
        }
    }

    public static class ImagesRequestEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int startIndex;
        protected int length;

        @Deprecated
        public ImagesRequestEvent() {
        }

        public ImagesRequestEvent(String componentId, int startIndex, int length) {
            this.componentId = componentId;
            this.startIndex = startIndex;
            this.length = length;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_IMAGE_DISPLAY_IMAGES_REQUEST;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("startIndex=" + this.startIndex) + ", " + ("length=" + this.length);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="startIndex")
        public int getStartIndex() {
            return this.startIndex;
        }

        @JsonGetter(value="length")
        public int getLength() {
            return this.length;
        }
    }
}

