/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTreeGraphNode;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiTreeGraph.class)
public class UiTreeGraph
extends UiComponent
implements UiObject {
    protected List<UiTreeGraphNode> nodes;
    protected String backgroundColor = "rgba(0, 0, 0, 0)";
    protected float zoomFactor = 1.0f;
    protected boolean compact;
    protected int verticalLayerGap;
    protected int sideListIndent;
    protected int sideListVerticalGap;
    protected int horizontalSiblingGap;
    protected int horizontalNonSignlingGap;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_TREE_GRAPH;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + ("backgroundColor=" + this.backgroundColor) + ", " + ("zoomFactor=" + this.zoomFactor) + ", " + ("compact=" + this.compact) + ", " + ("verticalLayerGap=" + this.verticalLayerGap) + ", " + ("sideListIndent=" + this.sideListIndent) + ", " + ("sideListVerticalGap=" + this.sideListVerticalGap) + ", " + ("horizontalSiblingGap=" + this.horizontalSiblingGap) + ", " + ("horizontalNonSignlingGap=" + this.horizontalNonSignlingGap) + ", " + (String)(this.nodes != null ? "nodes={" + this.nodes.toString() + "}" : "");
    }

    @JsonGetter(value="nodes")
    public List<UiTreeGraphNode> getNodes() {
        return this.nodes;
    }

    @JsonGetter(value="backgroundColor")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonGetter(value="zoomFactor")
    public float getZoomFactor() {
        return this.zoomFactor;
    }

    @JsonGetter(value="compact")
    public boolean getCompact() {
        return this.compact;
    }

    @JsonGetter(value="verticalLayerGap")
    public int getVerticalLayerGap() {
        return this.verticalLayerGap;
    }

    @JsonGetter(value="sideListIndent")
    public int getSideListIndent() {
        return this.sideListIndent;
    }

    @JsonGetter(value="sideListVerticalGap")
    public int getSideListVerticalGap() {
        return this.sideListVerticalGap;
    }

    @JsonGetter(value="horizontalSiblingGap")
    public int getHorizontalSiblingGap() {
        return this.horizontalSiblingGap;
    }

    @JsonGetter(value="horizontalNonSignlingGap")
    public int getHorizontalNonSignlingGap() {
        return this.horizontalNonSignlingGap;
    }

    @Override
    @JsonSetter(value="id")
    public UiTreeGraph setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiTreeGraph setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiTreeGraph setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiTreeGraph setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiTreeGraph setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiTreeGraph setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="nodes")
    public UiTreeGraph setNodes(List<UiTreeGraphNode> nodes) {
        this.nodes = nodes;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public UiTreeGraph setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="zoomFactor")
    public UiTreeGraph setZoomFactor(float zoomFactor) {
        this.zoomFactor = zoomFactor;
        return this;
    }

    @JsonSetter(value="compact")
    public UiTreeGraph setCompact(boolean compact) {
        this.compact = compact;
        return this;
    }

    @JsonSetter(value="verticalLayerGap")
    public UiTreeGraph setVerticalLayerGap(int verticalLayerGap) {
        this.verticalLayerGap = verticalLayerGap;
        return this;
    }

    @JsonSetter(value="sideListIndent")
    public UiTreeGraph setSideListIndent(int sideListIndent) {
        this.sideListIndent = sideListIndent;
        return this;
    }

    @JsonSetter(value="sideListVerticalGap")
    public UiTreeGraph setSideListVerticalGap(int sideListVerticalGap) {
        this.sideListVerticalGap = sideListVerticalGap;
        return this;
    }

    @JsonSetter(value="horizontalSiblingGap")
    public UiTreeGraph setHorizontalSiblingGap(int horizontalSiblingGap) {
        this.horizontalSiblingGap = horizontalSiblingGap;
        return this;
    }

    @JsonSetter(value="horizontalNonSignlingGap")
    public UiTreeGraph setHorizontalNonSignlingGap(int horizontalNonSignlingGap) {
        this.horizontalNonSignlingGap = horizontalNonSignlingGap;
        return this;
    }

    public static class MoveToNodeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String nodeId;

        @Deprecated
        public MoveToNodeCommand() {
        }

        public MoveToNodeCommand(String componentId, String nodeId) {
            this.componentId = componentId;
            this.nodeId = nodeId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("nodeId=" + this.nodeId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodeId")
        public String getNodeId() {
            return this.nodeId;
        }
    }

    public static class MoveToRootNodeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public MoveToRootNodeCommand() {
        }

        public MoveToRootNodeCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class UpdateNodeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiTreeGraphNode node;

        @Deprecated
        public UpdateNodeCommand() {
        }

        public UpdateNodeCommand(String componentId, UiTreeGraphNode node) {
            this.componentId = componentId;
            this.node = node;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.node != null ? "node={" + this.node.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="node")
        public UiTreeGraphNode getNode() {
            return this.node;
        }
    }

    public static class SetNodeExpandedCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String nodeId;
        protected boolean expanded;

        @Deprecated
        public SetNodeExpandedCommand() {
        }

        public SetNodeExpandedCommand(String componentId, String nodeId, boolean expanded) {
            this.componentId = componentId;
            this.nodeId = nodeId;
            this.expanded = expanded;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("nodeId=" + this.nodeId) + ", " + ("expanded=" + this.expanded);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodeId")
        public String getNodeId() {
            return this.nodeId;
        }

        @JsonGetter(value="expanded")
        public boolean getExpanded() {
            return this.expanded;
        }
    }

    public static class RemoveNodeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String nodeId;

        @Deprecated
        public RemoveNodeCommand() {
        }

        public RemoveNodeCommand(String componentId, String nodeId) {
            this.componentId = componentId;
            this.nodeId = nodeId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("nodeId=" + this.nodeId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodeId")
        public String getNodeId() {
            return this.nodeId;
        }
    }

    public static class AddNodeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiTreeGraphNode node;

        @Deprecated
        public AddNodeCommand() {
        }

        public AddNodeCommand(String componentId, UiTreeGraphNode node) {
            this.componentId = componentId;
            this.node = node;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.node != null ? "node={" + this.node.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="node")
        public UiTreeGraphNode getNode() {
            return this.node;
        }
    }

    public static class SetNodesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<UiTreeGraphNode> nodes;

        @Deprecated
        public SetNodesCommand() {
        }

        public SetNodesCommand(String componentId, List<UiTreeGraphNode> nodes) {
            this.componentId = componentId;
            this.nodes = nodes;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.nodes != null ? "nodes={" + this.nodes.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodes")
        public List<UiTreeGraphNode> getNodes() {
            return this.nodes;
        }
    }

    public static class SetZoomFactorCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected float zoomFactor;

        @Deprecated
        public SetZoomFactorCommand() {
        }

        public SetZoomFactorCommand(String componentId, float zoomFactor) {
            this.componentId = componentId;
            this.zoomFactor = zoomFactor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("zoomFactor=" + this.zoomFactor);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="zoomFactor")
        public float getZoomFactor() {
            return this.zoomFactor;
        }
    }

    public static class UpdateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiTreeGraph config;

        @Deprecated
        public UpdateCommand() {
        }

        public UpdateCommand(String componentId, UiTreeGraph config) {
            this.componentId = componentId;
            this.config = config;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.config != null ? "config={" + this.config.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="config")
        public UiTreeGraph getConfig() {
            return this.config;
        }
    }

    public static class SideListExpandedOrCollapsedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String nodeId;
        protected boolean expanded;

        @Deprecated
        public SideListExpandedOrCollapsedEvent() {
        }

        public SideListExpandedOrCollapsedEvent(String componentId, String nodeId, boolean expanded) {
            this.componentId = componentId;
            this.nodeId = nodeId;
            this.expanded = expanded;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TREE_GRAPH_SIDE_LIST_EXPANDED_OR_COLLAPSED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("nodeId=" + this.nodeId) + ", " + ("expanded=" + this.expanded);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodeId")
        public String getNodeId() {
            return this.nodeId;
        }

        @JsonGetter(value="expanded")
        public boolean getExpanded() {
            return this.expanded;
        }
    }

    public static class ParentExpandedOrCollapsedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String nodeId;
        protected boolean expanded;
        protected boolean lazyLoad;

        @Deprecated
        public ParentExpandedOrCollapsedEvent() {
        }

        public ParentExpandedOrCollapsedEvent(String componentId, String nodeId, boolean expanded, boolean lazyLoad) {
            this.componentId = componentId;
            this.nodeId = nodeId;
            this.expanded = expanded;
            this.lazyLoad = lazyLoad;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TREE_GRAPH_PARENT_EXPANDED_OR_COLLAPSED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("nodeId=" + this.nodeId) + ", " + ("expanded=" + this.expanded) + ", " + ("lazyLoad=" + this.lazyLoad);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodeId")
        public String getNodeId() {
            return this.nodeId;
        }

        @JsonGetter(value="expanded")
        public boolean getExpanded() {
            return this.expanded;
        }

        @JsonGetter(value="lazyLoad")
        public boolean getLazyLoad() {
            return this.lazyLoad;
        }
    }

    public static class NodeExpandedOrCollapsedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String nodeId;
        protected boolean expanded;
        protected boolean lazyLoad;

        @Deprecated
        public NodeExpandedOrCollapsedEvent() {
        }

        public NodeExpandedOrCollapsedEvent(String componentId, String nodeId, boolean expanded, boolean lazyLoad) {
            this.componentId = componentId;
            this.nodeId = nodeId;
            this.expanded = expanded;
            this.lazyLoad = lazyLoad;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TREE_GRAPH_NODE_EXPANDED_OR_COLLAPSED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("nodeId=" + this.nodeId) + ", " + ("expanded=" + this.expanded) + ", " + ("lazyLoad=" + this.lazyLoad);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodeId")
        public String getNodeId() {
            return this.nodeId;
        }

        @JsonGetter(value="expanded")
        public boolean getExpanded() {
            return this.expanded;
        }

        @JsonGetter(value="lazyLoad")
        public boolean getLazyLoad() {
            return this.lazyLoad;
        }
    }

    public static class NodeClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String nodeId;

        @Deprecated
        public NodeClickedEvent() {
        }

        public NodeClickedEvent(String componentId, String nodeId) {
            this.componentId = componentId;
            this.nodeId = nodeId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TREE_GRAPH_NODE_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("nodeId=" + this.nodeId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodeId")
        public String getNodeId() {
            return this.nodeId;
        }
    }
}

