package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type", defaultImpl = UiRichTextEditor.class)
public class UiRichTextEditor extends UiField implements UiTextInputHandlingField, UiObject {


	protected String locale;
	protected boolean imageUploadEnabled;
	protected String uploadUrl = "/upload";
	protected long maxImageFileSizeInBytes = 5000000;
	protected UiToolbarVisibilityMode toolbarVisibilityMode = UiToolbarVisibilityMode.VISIBLE_IF_FOCUSED;
	protected int minHeight = 150;
	protected int maxHeight = 150;

	public UiRichTextEditor() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_RICH_TEXT_EDITOR;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("editingMode=" + editingMode).append(", ")
				.append("value=" + value).append(", ")
				.append("locale=" + locale).append(", ")
				.append("imageUploadEnabled=" + imageUploadEnabled).append(", ")
				.append("uploadUrl=" + uploadUrl).append(", ")
				.append("maxImageFileSizeInBytes=" + maxImageFileSizeInBytes).append(", ")
				.append("toolbarVisibilityMode=" + toolbarVisibilityMode).append(", ")
				.append("minHeight=" + minHeight).append(", ")
				.append("maxHeight=" + maxHeight).append(", ")
				.append(fieldMessages != null ? "fieldMessages={" + fieldMessages.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("locale")
	public String getLocale() {
		return locale;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("imageUploadEnabled")
	public boolean getImageUploadEnabled() {
		return imageUploadEnabled;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("uploadUrl")
	public String getUploadUrl() {
		return uploadUrl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxImageFileSizeInBytes")
	public long getMaxImageFileSizeInBytes() {
		return maxImageFileSizeInBytes;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("toolbarVisibilityMode")
	public UiToolbarVisibilityMode getToolbarVisibilityMode() {
		return toolbarVisibilityMode;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("minHeight")
	public int getMinHeight() {
		return minHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxHeight")
	public int getMaxHeight() {
		return maxHeight;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiRichTextEditor setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiRichTextEditor setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiRichTextEditor setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiRichTextEditor setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiRichTextEditor setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiRichTextEditor setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("editingMode")
	public UiRichTextEditor setEditingMode(UiFieldEditingMode editingMode) {
		this.editingMode = editingMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("value")
	public UiRichTextEditor setValue(Object value) {
		this.value = value;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fieldMessages")
	public UiRichTextEditor setFieldMessages(List<UiFieldMessage> fieldMessages) {
		this.fieldMessages = fieldMessages;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("locale")
	public UiRichTextEditor setLocale(String locale) {
		this.locale = locale;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("imageUploadEnabled")
	public UiRichTextEditor setImageUploadEnabled(boolean imageUploadEnabled) {
		this.imageUploadEnabled = imageUploadEnabled;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("uploadUrl")
	public UiRichTextEditor setUploadUrl(String uploadUrl) {
		this.uploadUrl = uploadUrl;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxImageFileSizeInBytes")
	public UiRichTextEditor setMaxImageFileSizeInBytes(long maxImageFileSizeInBytes) {
		this.maxImageFileSizeInBytes = maxImageFileSizeInBytes;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("toolbarVisibilityMode")
	public UiRichTextEditor setToolbarVisibilityMode(UiToolbarVisibilityMode toolbarVisibilityMode) {
		this.toolbarVisibilityMode = toolbarVisibilityMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("minHeight")
	public UiRichTextEditor setMinHeight(int minHeight) {
		this.minHeight = minHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxHeight")
	public UiRichTextEditor setMaxHeight(int maxHeight) {
		this.maxHeight = maxHeight;
		return this;
	}

	public static class ImageUploadTooLargeEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ImageUploadTooLargeEvent() {
			// default constructor for Jackson
		}

		public ImageUploadTooLargeEvent(String componentId, String fileName, String mimeType, long sizeInBytes) {
			this.componentId = componentId;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_RICH_TEXT_EDITOR_IMAGE_UPLOAD_TOO_LARGE;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

	}

	public static class ImageUploadStartedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;
		protected int incompleteUploadsCount;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ImageUploadStartedEvent() {
			// default constructor for Jackson
		}

		public ImageUploadStartedEvent(String componentId, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
			this.componentId = componentId;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
			this.incompleteUploadsCount = incompleteUploadsCount;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_RICH_TEXT_EDITOR_IMAGE_UPLOAD_STARTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes).append(", ")
					.append("incompleteUploadsCount=" + incompleteUploadsCount)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("incompleteUploadsCount")
		public int getIncompleteUploadsCount() {
			return incompleteUploadsCount;
		}

	}

	public static class ImageUploadSuccessfulEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileUuid;
		protected String name;
		protected String mimeType;
		protected long sizeInBytes;
		protected int incompleteUploadsCount;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ImageUploadSuccessfulEvent() {
			// default constructor for Jackson
		}

		public ImageUploadSuccessfulEvent(String componentId, String fileUuid, String name, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
			this.componentId = componentId;
			this.fileUuid = fileUuid;
			this.name = name;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
			this.incompleteUploadsCount = incompleteUploadsCount;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_RICH_TEXT_EDITOR_IMAGE_UPLOAD_SUCCESSFUL;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("name=" + name).append(", ")
					.append("componentId=" + componentId).append(", ")
					.append("fileUuid=" + fileUuid).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes).append(", ")
					.append("incompleteUploadsCount=" + incompleteUploadsCount)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileUuid")
		public String getFileUuid() {
			return fileUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("name")
		public String getName() {
			return name;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("incompleteUploadsCount")
		public int getIncompleteUploadsCount() {
			return incompleteUploadsCount;
		}

	}

	public static class ImageUploadFailedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String name;
		protected String mimeType;
		protected long sizeInBytes;
		protected int incompleteUploadsCount;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ImageUploadFailedEvent() {
			// default constructor for Jackson
		}

		public ImageUploadFailedEvent(String componentId, String name, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
			this.componentId = componentId;
			this.name = name;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
			this.incompleteUploadsCount = incompleteUploadsCount;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_RICH_TEXT_EDITOR_IMAGE_UPLOAD_FAILED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("name=" + name).append(", ")
					.append("componentId=" + componentId).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes).append(", ")
					.append("incompleteUploadsCount=" + incompleteUploadsCount)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("name")
		public String getName() {
			return name;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("incompleteUploadsCount")
		public int getIncompleteUploadsCount() {
			return incompleteUploadsCount;
		}

	}


	public static class SetMinHeightCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int minHeight;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMinHeightCommand() {
			// default constructor for Jackson
		}

		public SetMinHeightCommand(String componentId, int minHeight) {
			this.componentId = componentId;
			this.minHeight = minHeight;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("minHeight=" + minHeight)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("minHeight")
		public int getMinHeight() {
			return minHeight;
		}

	}

	public static class SetMaxHeightCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int maxHeight;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMaxHeightCommand() {
			// default constructor for Jackson
		}

		public SetMaxHeightCommand(String componentId, int maxHeight) {
			this.componentId = componentId;
			this.maxHeight = maxHeight;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("maxHeight=" + maxHeight)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("maxHeight")
		public int getMaxHeight() {
			return maxHeight;
		}

	}

	public static class SetUploadUrlCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String uploadUrl;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetUploadUrlCommand() {
			// default constructor for Jackson
		}

		public SetUploadUrlCommand(String componentId, String uploadUrl) {
			this.componentId = componentId;
			this.uploadUrl = uploadUrl;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("uploadUrl=" + uploadUrl)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uploadUrl")
		public String getUploadUrl() {
			return uploadUrl;
		}

	}

	public static class SetMaxImageFileSizeInBytesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected long maxImageFileSizeInBytes;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMaxImageFileSizeInBytesCommand() {
			// default constructor for Jackson
		}

		public SetMaxImageFileSizeInBytesCommand(String componentId, long maxImageFileSizeInBytes) {
			this.componentId = componentId;
			this.maxImageFileSizeInBytes = maxImageFileSizeInBytes;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("maxImageFileSizeInBytes=" + maxImageFileSizeInBytes)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("maxImageFileSizeInBytes")
		public long getMaxImageFileSizeInBytes() {
			return maxImageFileSizeInBytes;
		}

	}

	public static class SetUploadedImageUrlCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String fileUuid;
		protected String url;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetUploadedImageUrlCommand() {
			// default constructor for Jackson
		}

		public SetUploadedImageUrlCommand(String componentId, String fileUuid, String url) {
			this.componentId = componentId;
			this.fileUuid = fileUuid;
			this.url = url;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileUuid=" + fileUuid).append(", ")
					.append("url=" + url)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileUuid")
		public String getFileUuid() {
			return fileUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("url")
		public String getUrl() {
			return url;
		}

	}

	public static class SetToolbarVisibilityModeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiToolbarVisibilityMode toolbarVisibilityMode;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetToolbarVisibilityModeCommand() {
			// default constructor for Jackson
		}

		public SetToolbarVisibilityModeCommand(String componentId, UiToolbarVisibilityMode toolbarVisibilityMode) {
			this.componentId = componentId;
			this.toolbarVisibilityMode = toolbarVisibilityMode;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("toolbarVisibilityMode=" + toolbarVisibilityMode)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("toolbarVisibilityMode")
		public UiToolbarVisibilityMode getToolbarVisibilityMode() {
			return toolbarVisibilityMode;
		}

	}

}