/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiExitAnimation;
import org.teamapps.dto.UiNotificationBarItem;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiNotificationBar.class)
public class UiNotificationBar
extends UiComponent
implements UiObject {
    protected List<UiNotificationBarItem> initialItems;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_NOTIFICATION_BAR;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + (String)(this.initialItems != null ? "initialItems={" + this.initialItems.toString() + "}" : "");
    }

    @JsonGetter(value="initialItems")
    public List<UiNotificationBarItem> getInitialItems() {
        return this.initialItems;
    }

    @Override
    @JsonSetter(value="id")
    public UiNotificationBar setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiNotificationBar setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiNotificationBar setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiNotificationBar setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiNotificationBar setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiNotificationBar setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="initialItems")
    public UiNotificationBar setInitialItems(List<UiNotificationBarItem> initialItems) {
        this.initialItems = initialItems;
        return this;
    }

    public static class RemoveItemCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String id;
        protected UiExitAnimation exitAnimation;

        @Deprecated
        public RemoveItemCommand() {
        }

        public RemoveItemCommand(String componentId, String id, UiExitAnimation exitAnimation) {
            this.componentId = componentId;
            this.id = id;
            this.exitAnimation = exitAnimation;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("componentId=" + this.componentId) + ", " + ("exitAnimation=" + this.exitAnimation);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JsonGetter(value="exitAnimation")
        public UiExitAnimation getExitAnimation() {
            return this.exitAnimation;
        }
    }

    public static class UpdateItemCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiNotificationBarItem item;

        @Deprecated
        public UpdateItemCommand() {
        }

        public UpdateItemCommand(String componentId, UiNotificationBarItem item) {
            this.componentId = componentId;
            this.item = item;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.item != null ? "item={" + this.item.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="item")
        public UiNotificationBarItem getItem() {
            return this.item;
        }
    }

    public static class AddItemCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiNotificationBarItem item;

        @Deprecated
        public AddItemCommand() {
        }

        public AddItemCommand(String componentId, UiNotificationBarItem item) {
            this.componentId = componentId;
            this.item = item;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.item != null ? "item={" + this.item.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="item")
        public UiNotificationBarItem getItem() {
            return this.item;
        }
    }

    public static class ItemClosedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String id;
        protected boolean wasTimeout;

        @Deprecated
        public ItemClosedEvent() {
        }

        public ItemClosedEvent(String componentId, String id, boolean wasTimeout) {
            this.componentId = componentId;
            this.id = id;
            this.wasTimeout = wasTimeout;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_NOTIFICATION_BAR_ITEM_CLOSED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("componentId=" + this.componentId) + ", " + ("wasTimeout=" + this.wasTimeout);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JsonGetter(value="wasTimeout")
        public boolean getWasTimeout() {
            return this.wasTimeout;
        }
    }

    public static class ItemActionLinkClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String id;

        @Deprecated
        public ItemActionLinkClickedEvent() {
        }

        public ItemActionLinkClickedEvent(String componentId, String id) {
            this.componentId = componentId;
            this.id = id;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_NOTIFICATION_BAR_ITEM_ACTION_LINK_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }
    }

    public static class ItemClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String id;

        @Deprecated
        public ItemClickedEvent() {
        }

        public ItemClickedEvent(String componentId, String id) {
            this.componentId = componentId;
            this.id = id;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_NOTIFICATION_BAR_ITEM_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }
    }
}

