/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;
import org.teamapps.dto.UiTreeRecord;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiTree.class)
public class UiTree
extends UiComponent
implements UiObject {
    protected Map<String, UiTemplate> templates;
    protected String defaultTemplateId = null;
    protected List<UiTreeRecord> initialData;
    protected Integer selectedNodeId;
    protected boolean animate;
    protected boolean showExpanders = true;
    protected boolean openOnSelection = false;
    protected boolean enforceSingleExpandedPath = false;
    protected int indentation = 15;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_TREE;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("defaultTemplateId=" + this.defaultTemplateId) + ", " + ("selectedNodeId=" + this.selectedNodeId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + (String)(this.templates != null ? "templates={" + this.templates.toString() + "}" : "") + ", " + ("animate=" + this.animate) + ", " + ("showExpanders=" + this.showExpanders) + ", " + ("openOnSelection=" + this.openOnSelection) + ", " + ("enforceSingleExpandedPath=" + this.enforceSingleExpandedPath) + ", " + ("indentation=" + this.indentation) + ", " + (String)(this.initialData != null ? "initialData={" + this.initialData.toString() + "}" : "");
    }

    @JsonGetter(value="templates")
    public Map<String, UiTemplate> getTemplates() {
        return this.templates;
    }

    @JsonGetter(value="defaultTemplateId")
    public String getDefaultTemplateId() {
        return this.defaultTemplateId;
    }

    @JsonGetter(value="initialData")
    public List<UiTreeRecord> getInitialData() {
        return this.initialData;
    }

    @JsonGetter(value="selectedNodeId")
    public Integer getSelectedNodeId() {
        return this.selectedNodeId;
    }

    @JsonGetter(value="animate")
    public boolean getAnimate() {
        return this.animate;
    }

    @JsonGetter(value="showExpanders")
    public boolean getShowExpanders() {
        return this.showExpanders;
    }

    @JsonGetter(value="openOnSelection")
    public boolean getOpenOnSelection() {
        return this.openOnSelection;
    }

    @JsonGetter(value="enforceSingleExpandedPath")
    public boolean getEnforceSingleExpandedPath() {
        return this.enforceSingleExpandedPath;
    }

    @JsonGetter(value="indentation")
    public int getIndentation() {
        return this.indentation;
    }

    @Override
    @JsonSetter(value="id")
    public UiTree setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiTree setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiTree setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiTree setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiTree setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiTree setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="templates")
    public UiTree setTemplates(Map<String, UiTemplate> templates) {
        this.templates = templates;
        return this;
    }

    @JsonSetter(value="defaultTemplateId")
    public UiTree setDefaultTemplateId(String defaultTemplateId) {
        this.defaultTemplateId = defaultTemplateId;
        return this;
    }

    @JsonSetter(value="initialData")
    public UiTree setInitialData(List<UiTreeRecord> initialData) {
        this.initialData = initialData;
        return this;
    }

    @JsonSetter(value="selectedNodeId")
    public UiTree setSelectedNodeId(Integer selectedNodeId) {
        this.selectedNodeId = selectedNodeId;
        return this;
    }

    @JsonSetter(value="animate")
    public UiTree setAnimate(boolean animate) {
        this.animate = animate;
        return this;
    }

    @JsonSetter(value="showExpanders")
    public UiTree setShowExpanders(boolean showExpanders) {
        this.showExpanders = showExpanders;
        return this;
    }

    @JsonSetter(value="openOnSelection")
    public UiTree setOpenOnSelection(boolean openOnSelection) {
        this.openOnSelection = openOnSelection;
        return this;
    }

    @JsonSetter(value="enforceSingleExpandedPath")
    public UiTree setEnforceSingleExpandedPath(boolean enforceSingleExpandedPath) {
        this.enforceSingleExpandedPath = enforceSingleExpandedPath;
        return this;
    }

    @JsonSetter(value="indentation")
    public UiTree setIndentation(int indentation) {
        this.indentation = indentation;
        return this;
    }

    public static class RegisterTemplateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String id;
        protected UiTemplate template;

        @Deprecated
        public RegisterTemplateCommand() {
        }

        public RegisterTemplateCommand(String componentId, String id, UiTemplate template) {
            this.componentId = componentId;
            this.id = id;
            this.template = template;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("componentId=" + this.componentId) + ", " + (String)(this.template != null ? "template={" + this.template.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JsonGetter(value="template")
        public UiTemplate getTemplate() {
            return this.template;
        }
    }

    public static class SetSelectedNodeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected Integer recordId;

        @Deprecated
        public SetSelectedNodeCommand() {
        }

        public SetSelectedNodeCommand(String componentId, Integer recordId) {
            this.componentId = componentId;
            this.recordId = recordId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public Integer getRecordId() {
            return this.recordId;
        }
    }

    public static class BulkUpdateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<Integer> nodesToBeRemoved;
        protected List<UiTreeRecord> nodesToBeAdded;

        @Deprecated
        public BulkUpdateCommand() {
        }

        public BulkUpdateCommand(String componentId, List<Integer> nodesToBeRemoved, List<UiTreeRecord> nodesToBeAdded) {
            this.componentId = componentId;
            this.nodesToBeRemoved = nodesToBeRemoved;
            this.nodesToBeAdded = nodesToBeAdded;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("nodesToBeRemoved=" + this.nodesToBeRemoved) + ", " + (String)(this.nodesToBeAdded != null ? "nodesToBeAdded={" + this.nodesToBeAdded.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodesToBeRemoved")
        public List<Integer> getNodesToBeRemoved() {
            return this.nodesToBeRemoved;
        }

        @JsonGetter(value="nodesToBeAdded")
        public List<UiTreeRecord> getNodesToBeAdded() {
            return this.nodesToBeAdded;
        }
    }

    public static class ReplaceDataCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<UiTreeRecord> nodes;

        @Deprecated
        public ReplaceDataCommand() {
        }

        public ReplaceDataCommand(String componentId, List<UiTreeRecord> nodes) {
            this.componentId = componentId;
            this.nodes = nodes;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.nodes != null ? "nodes={" + this.nodes.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodes")
        public List<UiTreeRecord> getNodes() {
            return this.nodes;
        }
    }

    public static class RequestTreeDataEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int parentNodeId;

        @Deprecated
        public RequestTreeDataEvent() {
        }

        public RequestTreeDataEvent(String componentId, int parentNodeId) {
            this.componentId = componentId;
            this.parentNodeId = parentNodeId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TREE_REQUEST_TREE_DATA;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("parentNodeId=" + this.parentNodeId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="parentNodeId")
        public int getParentNodeId() {
            return this.parentNodeId;
        }
    }

    public static class NodeSelectedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int nodeId;

        @Deprecated
        public NodeSelectedEvent() {
        }

        public NodeSelectedEvent(String componentId, int nodeId) {
            this.componentId = componentId;
            this.nodeId = nodeId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TREE_NODE_SELECTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("nodeId=" + this.nodeId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodeId")
        public int getNodeId() {
            return this.nodeId;
        }
    }

    public static class TextInputEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String text;

        @Deprecated
        public TextInputEvent() {
        }

        public TextInputEvent(String componentId, String text) {
            this.componentId = componentId;
            this.text = text;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TREE_TEXT_INPUT;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("text=" + this.text);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="text")
        public String getText() {
            return this.text;
        }
    }
}

