/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;
import org.teamapps.dto.UiChatMessage;
import org.teamapps.dto.UiChatMessageBatch;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiQuery;
import org.teamapps.dto.UiQueryType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiChatDisplay.class)
public class UiChatDisplay
extends UiComponent
implements UiObject {
    protected UiChatMessageBatch initialMessages;
    protected boolean contextMenuEnabled = false;
    protected String deletedMessageIcon;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_CHAT_DISPLAY;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + ("contextMenuEnabled=" + this.contextMenuEnabled) + ", " + ("deletedMessageIcon=" + this.deletedMessageIcon) + ", " + (String)(this.initialMessages != null ? "initialMessages={" + this.initialMessages.toString() + "}" : "");
    }

    @JsonGetter(value="initialMessages")
    public UiChatMessageBatch getInitialMessages() {
        return this.initialMessages;
    }

    @JsonGetter(value="contextMenuEnabled")
    public boolean getContextMenuEnabled() {
        return this.contextMenuEnabled;
    }

    @JsonGetter(value="deletedMessageIcon")
    public String getDeletedMessageIcon() {
        return this.deletedMessageIcon;
    }

    @Override
    @JsonSetter(value="id")
    public UiChatDisplay setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiChatDisplay setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiChatDisplay setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiChatDisplay setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiChatDisplay setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiChatDisplay setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="initialMessages")
    public UiChatDisplay setInitialMessages(UiChatMessageBatch initialMessages) {
        this.initialMessages = initialMessages;
        return this;
    }

    @JsonSetter(value="contextMenuEnabled")
    public UiChatDisplay setContextMenuEnabled(boolean contextMenuEnabled) {
        this.contextMenuEnabled = contextMenuEnabled;
        return this;
    }

    @JsonSetter(value="deletedMessageIcon")
    public UiChatDisplay setDeletedMessageIcon(String deletedMessageIcon) {
        this.deletedMessageIcon = deletedMessageIcon;
        return this;
    }

    public static class CloseContextMenuCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public CloseContextMenuCommand() {
        }

        public CloseContextMenuCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class ClearMessagesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiChatMessageBatch messages;

        @Deprecated
        public ClearMessagesCommand() {
        }

        public ClearMessagesCommand(String componentId, UiChatMessageBatch messages) {
            this.componentId = componentId;
            this.messages = messages;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.messages != null ? "messages={" + this.messages.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="messages")
        public UiChatMessageBatch getMessages() {
            return this.messages;
        }
    }

    public static class DeleteMessageCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int messageId;

        @Deprecated
        public DeleteMessageCommand() {
        }

        public DeleteMessageCommand(String componentId, int messageId) {
            this.componentId = componentId;
            this.messageId = messageId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("messageId=" + this.messageId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="messageId")
        public int getMessageId() {
            return this.messageId;
        }
    }

    public static class UpdateMessageCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiChatMessage message;

        @Deprecated
        public UpdateMessageCommand() {
        }

        public UpdateMessageCommand(String componentId, UiChatMessage message) {
            this.componentId = componentId;
            this.message = message;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.message != null ? "message={" + this.message.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="message")
        public UiChatMessage getMessage() {
            return this.message;
        }
    }

    public static class AddMessagesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiChatMessageBatch messages;

        @Deprecated
        public AddMessagesCommand() {
        }

        public AddMessagesCommand(String componentId, UiChatMessageBatch messages) {
            this.componentId = componentId;
            this.messages = messages;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.messages != null ? "messages={" + this.messages.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="messages")
        public UiChatMessageBatch getMessages() {
            return this.messages;
        }
    }

    public static class RequestContextMenuQuery
    implements UiQuery {
        @UiComponentId
        protected String componentId;
        protected int chatMessageId;

        @Deprecated
        public RequestContextMenuQuery() {
        }

        public RequestContextMenuQuery(String componentId, int chatMessageId) {
            this.componentId = componentId;
            this.chatMessageId = chatMessageId;
        }

        @Override
        public UiQueryType getUiQueryType() {
            return UiQueryType.UI_CHAT_DISPLAY_REQUEST_CONTEXT_MENU;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("chatMessageId=" + this.chatMessageId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="chatMessageId")
        public int getChatMessageId() {
            return this.chatMessageId;
        }
    }

    public static class RequestPreviousMessagesQuery
    implements UiQuery {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public RequestPreviousMessagesQuery() {
        }

        public RequestPreviousMessagesQuery(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiQueryType getUiQueryType() {
            return UiQueryType.UI_CHAT_DISPLAY_REQUEST_PREVIOUS_MESSAGES;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }
}

