/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiMediaTrackData;
import org.teamapps.dto.UiMediaTrackMarker;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiMediaTrackGraph.class)
public class UiMediaTrackGraph
extends UiComponent
implements UiObject {
    protected int trackCount;
    protected List<UiMediaTrackData> trackData;
    protected List<UiMediaTrackMarker> markers;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_MEDIA_TRACK_GRAPH;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + ("trackCount=" + this.trackCount) + ", " + (String)(this.trackData != null ? "trackData={" + this.trackData.toString() + "}" : "") + ", " + (String)(this.markers != null ? "markers={" + this.markers.toString() + "}" : "");
    }

    @JsonGetter(value="trackCount")
    public int getTrackCount() {
        return this.trackCount;
    }

    @JsonGetter(value="trackData")
    public List<UiMediaTrackData> getTrackData() {
        return this.trackData;
    }

    @JsonGetter(value="markers")
    public List<UiMediaTrackMarker> getMarkers() {
        return this.markers;
    }

    @Override
    @JsonSetter(value="id")
    public UiMediaTrackGraph setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiMediaTrackGraph setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiMediaTrackGraph setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiMediaTrackGraph setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiMediaTrackGraph setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiMediaTrackGraph setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="trackCount")
    public UiMediaTrackGraph setTrackCount(int trackCount) {
        this.trackCount = trackCount;
        return this;
    }

    @JsonSetter(value="trackData")
    public UiMediaTrackGraph setTrackData(List<UiMediaTrackData> trackData) {
        this.trackData = trackData;
        return this;
    }

    @JsonSetter(value="markers")
    public UiMediaTrackGraph setMarkers(List<UiMediaTrackMarker> markers) {
        this.markers = markers;
        return this;
    }

    public static class SetCursorPositionCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected long time;

        @Deprecated
        public SetCursorPositionCommand() {
        }

        public SetCursorPositionCommand(String componentId, long time) {
            this.componentId = componentId;
            this.time = time;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("time=" + this.time);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="time")
        public long getTime() {
            return this.time;
        }
    }

    public static class HandleTimeSelectionEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected long start;
        protected long end;

        @Deprecated
        public HandleTimeSelectionEvent() {
        }

        public HandleTimeSelectionEvent(String componentId, long start, long end) {
            this.componentId = componentId;
            this.start = start;
            this.end = end;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_TRACK_GRAPH_HANDLE_TIME_SELECTION;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("start=" + this.start) + ", " + ("end=" + this.end);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="start")
        public long getStart() {
            return this.start;
        }

        @JsonGetter(value="end")
        public long getEnd() {
            return this.end;
        }
    }
}

