package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type", defaultImpl = UiToolButton.class)
public class UiToolButton extends UiComponent implements UiObject {


	protected String icon;
	protected String caption;
	protected String popoverText;
	protected boolean grayOutIfNotHovered = true;
	protected int minDropDownWidth = 450;
	protected int minDropDownHeight = 200;
	protected boolean openDropDownIfNotSet = false;
	protected UiClientObjectReference dropDownComponent;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiToolButton() {
		// default constructor for Jackson
	}

	public UiToolButton(String icon, String popoverText) {
		super();
		this.icon = icon;
		this.popoverText = popoverText;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TOOL_BUTTON;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("icon=" + icon).append(", ")
				.append("caption=" + caption).append(", ")
				.append("popoverText=" + popoverText).append(", ")
				.append("grayOutIfNotHovered=" + grayOutIfNotHovered).append(", ")
				.append("minDropDownWidth=" + minDropDownWidth).append(", ")
				.append("minDropDownHeight=" + minDropDownHeight).append(", ")
				.append("openDropDownIfNotSet=" + openDropDownIfNotSet).append(", ")
				.append(dropDownComponent != null ? "dropDownComponent={" + dropDownComponent.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("icon")
	public String getIcon() {
		return icon;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("caption")
	public String getCaption() {
		return caption;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("popoverText")
	public String getPopoverText() {
		return popoverText;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("grayOutIfNotHovered")
	public boolean getGrayOutIfNotHovered() {
		return grayOutIfNotHovered;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("minDropDownWidth")
	public int getMinDropDownWidth() {
		return minDropDownWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("minDropDownHeight")
	public int getMinDropDownHeight() {
		return minDropDownHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("openDropDownIfNotSet")
	public boolean getOpenDropDownIfNotSet() {
		return openDropDownIfNotSet;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("dropDownComponent")
	public UiClientObjectReference getDropDownComponent() {
		return dropDownComponent;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiToolButton setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiToolButton setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiToolButton setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiToolButton setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiToolButton setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiToolButton setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("caption")
	public UiToolButton setCaption(String caption) {
		this.caption = caption;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("grayOutIfNotHovered")
	public UiToolButton setGrayOutIfNotHovered(boolean grayOutIfNotHovered) {
		this.grayOutIfNotHovered = grayOutIfNotHovered;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("minDropDownWidth")
	public UiToolButton setMinDropDownWidth(int minDropDownWidth) {
		this.minDropDownWidth = minDropDownWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("minDropDownHeight")
	public UiToolButton setMinDropDownHeight(int minDropDownHeight) {
		this.minDropDownHeight = minDropDownHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("openDropDownIfNotSet")
	public UiToolButton setOpenDropDownIfNotSet(boolean openDropDownIfNotSet) {
		this.openDropDownIfNotSet = openDropDownIfNotSet;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("dropDownComponent")
	public UiToolButton setDropDownComponent(UiClientObjectReference dropDownComponent) {
		this.dropDownComponent = dropDownComponent;
		return this;
	}

	public static class ClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ClickedEvent() {
			// default constructor for Jackson
		}

		public ClickedEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TOOL_BUTTON_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class DropDownOpenedEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public DropDownOpenedEvent() {
			// default constructor for Jackson
		}

		public DropDownOpenedEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TOOL_BUTTON_DROP_DOWN_OPENED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}


	public static class SetIconCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String icon;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetIconCommand() {
			// default constructor for Jackson
		}

		public SetIconCommand(String componentId, String icon) {
			this.componentId = componentId;
			this.icon = icon;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("icon=" + icon)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("icon")
		public String getIcon() {
			return icon;
		}

	}

	public static class SetPopoverTextCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String popoverText;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetPopoverTextCommand() {
			// default constructor for Jackson
		}

		public SetPopoverTextCommand(String componentId, String popoverText) {
			this.componentId = componentId;
			this.popoverText = popoverText;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("popoverText=" + popoverText)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("popoverText")
		public String getPopoverText() {
			return popoverText;
		}

	}

	public static class SetGrayOutIfNotHoveredCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean grayOutIfNotHovered;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetGrayOutIfNotHoveredCommand() {
			// default constructor for Jackson
		}

		public SetGrayOutIfNotHoveredCommand(String componentId, boolean grayOutIfNotHovered) {
			this.componentId = componentId;
			this.grayOutIfNotHovered = grayOutIfNotHovered;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("grayOutIfNotHovered=" + grayOutIfNotHovered)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("grayOutIfNotHovered")
		public boolean getGrayOutIfNotHovered() {
			return grayOutIfNotHovered;
		}

	}

	public static class SetDropDownSizeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int minDropDownWidth;
		protected int minDropDownHeight;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetDropDownSizeCommand() {
			// default constructor for Jackson
		}

		public SetDropDownSizeCommand(String componentId, int minDropDownWidth, int minDropDownHeight) {
			this.componentId = componentId;
			this.minDropDownWidth = minDropDownWidth;
			this.minDropDownHeight = minDropDownHeight;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("minDropDownWidth=" + minDropDownWidth).append(", ")
					.append("minDropDownHeight=" + minDropDownHeight)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("minDropDownWidth")
		public int getMinDropDownWidth() {
			return minDropDownWidth;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("minDropDownHeight")
		public int getMinDropDownHeight() {
			return minDropDownHeight;
		}

	}

	public static class SetOpenDropDownIfNotSetCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean openDropDownIfNotSet;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetOpenDropDownIfNotSetCommand() {
			// default constructor for Jackson
		}

		public SetOpenDropDownIfNotSetCommand(String componentId, boolean openDropDownIfNotSet) {
			this.componentId = componentId;
			this.openDropDownIfNotSet = openDropDownIfNotSet;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("openDropDownIfNotSet=" + openDropDownIfNotSet)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("openDropDownIfNotSet")
		public boolean getOpenDropDownIfNotSet() {
			return openDropDownIfNotSet;
		}

	}

	public static class SetDropDownComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiClientObjectReference dropDownComponent;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetDropDownComponentCommand() {
			// default constructor for Jackson
		}

		public SetDropDownComponentCommand(String componentId, UiClientObjectReference dropDownComponent) {
			this.componentId = componentId;
			this.dropDownComponent = dropDownComponent;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(dropDownComponent != null ? "dropDownComponent={" + dropDownComponent.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("dropDownComponent")
		public UiClientObjectReference getDropDownComponent() {
			return dropDownComponent;
		}

	}

}