package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiItemView extends UiComponent implements UiObject {


	protected UiTemplate groupHeaderTemplate;
	protected List<UiItemViewItemGroup> itemGroups;
	protected int horizontalPadding = 10;
	protected int verticalPadding = 0;
	protected int groupSpacing;
	protected UiItemViewItemBackgroundMode itemBackgroundMode = UiItemViewItemBackgroundMode.LIGHT;
	protected String filter;

	public UiItemView() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_ITEM_VIEW;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append(groupHeaderTemplate != null ? "groupHeaderTemplate={" + groupHeaderTemplate.toString() + "}" : "").append(", ")
				.append("horizontalPadding=" + horizontalPadding).append(", ")
				.append("verticalPadding=" + verticalPadding).append(", ")
				.append("groupSpacing=" + groupSpacing).append(", ")
				.append("itemBackgroundMode=" + itemBackgroundMode).append(", ")
				.append("filter=" + filter).append(", ")
				.append(itemGroups != null ? "itemGroups={" + itemGroups.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("groupHeaderTemplate")
	public UiTemplate getGroupHeaderTemplate() {
		return groupHeaderTemplate;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("itemGroups")
	public List<UiItemViewItemGroup> getItemGroups() {
		return itemGroups;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("horizontalPadding")
	public int getHorizontalPadding() {
		return horizontalPadding;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("verticalPadding")
	public int getVerticalPadding() {
		return verticalPadding;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("groupSpacing")
	public int getGroupSpacing() {
		return groupSpacing;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("itemBackgroundMode")
	public UiItemViewItemBackgroundMode getItemBackgroundMode() {
		return itemBackgroundMode;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("filter")
	public String getFilter() {
		return filter;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiItemView setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiItemView setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiItemView setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("groupHeaderTemplate")
	public UiItemView setGroupHeaderTemplate(UiTemplate groupHeaderTemplate) {
		this.groupHeaderTemplate = groupHeaderTemplate;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("itemGroups")
	public UiItemView setItemGroups(List<UiItemViewItemGroup> itemGroups) {
		this.itemGroups = itemGroups;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("horizontalPadding")
	public UiItemView setHorizontalPadding(int horizontalPadding) {
		this.horizontalPadding = horizontalPadding;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("verticalPadding")
	public UiItemView setVerticalPadding(int verticalPadding) {
		this.verticalPadding = verticalPadding;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("groupSpacing")
	public UiItemView setGroupSpacing(int groupSpacing) {
		this.groupSpacing = groupSpacing;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("itemBackgroundMode")
	public UiItemView setItemBackgroundMode(UiItemViewItemBackgroundMode itemBackgroundMode) {
		this.itemBackgroundMode = itemBackgroundMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("filter")
	public UiItemView setFilter(String filter) {
		this.filter = filter;
		return this;
	}

	public static class ItemClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String groupId;
		protected int itemId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ItemClickedEvent() {
			// default constructor for Jackson
		}

		public ItemClickedEvent(String componentId, String groupId, int itemId) {
			this.componentId = componentId;
			this.groupId = groupId;
			this.itemId = itemId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_ITEM_VIEW_ITEM_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("groupId=" + groupId).append(", ")
					.append("itemId=" + itemId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("groupId")
		public String getGroupId() {
			return groupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("itemId")
		public int getItemId() {
			return itemId;
		}

	}

	public static class SetFilterCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String filter;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetFilterCommand() {
			// default constructor for Jackson
		}

		public SetFilterCommand(String componentId, String filter) {
			this.componentId = componentId;
			this.filter = filter;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("filter=" + filter)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("filter")
		public String getFilter() {
			return filter;
		}

	}

	public static class AddItemGroupCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiItemViewItemGroup itemGroup;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddItemGroupCommand() {
			// default constructor for Jackson
		}

		public AddItemGroupCommand(String componentId, UiItemViewItemGroup itemGroup) {
			this.componentId = componentId;
			this.itemGroup = itemGroup;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(itemGroup != null ? "itemGroup={" + itemGroup.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("itemGroup")
		public UiItemViewItemGroup getItemGroup() {
			return itemGroup;
		}

	}

	public static class RefreshItemGroupCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiItemViewItemGroup itemGroup;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RefreshItemGroupCommand() {
			// default constructor for Jackson
		}

		public RefreshItemGroupCommand(String componentId, UiItemViewItemGroup itemGroup) {
			this.componentId = componentId;
			this.itemGroup = itemGroup;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(itemGroup != null ? "itemGroup={" + itemGroup.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("itemGroup")
		public UiItemViewItemGroup getItemGroup() {
			return itemGroup;
		}

	}

	public static class RemoveItemGroupCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String groupId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveItemGroupCommand() {
			// default constructor for Jackson
		}

		public RemoveItemGroupCommand(String componentId, String groupId) {
			this.componentId = componentId;
			this.groupId = groupId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("groupId=" + groupId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("groupId")
		public String getGroupId() {
			return groupId;
		}

	}

	public static class AddItemCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String groupId;
		protected UiIdentifiableClientRecord item;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddItemCommand() {
			// default constructor for Jackson
		}

		public AddItemCommand(String componentId, String groupId, UiIdentifiableClientRecord item) {
			this.componentId = componentId;
			this.groupId = groupId;
			this.item = item;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("groupId=" + groupId).append(", ")
					.append(item != null ? "item={" + item.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("groupId")
		public String getGroupId() {
			return groupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("item")
		public UiIdentifiableClientRecord getItem() {
			return item;
		}

	}

	public static class RemoveItemCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String groupId;
		protected int itemId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveItemCommand() {
			// default constructor for Jackson
		}

		public RemoveItemCommand(String componentId, String groupId, int itemId) {
			this.componentId = componentId;
			this.groupId = groupId;
			this.itemId = itemId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("groupId=" + groupId).append(", ")
					.append("itemId=" + itemId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("groupId")
		public String getGroupId() {
			return groupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("itemId")
		public int getItemId() {
			return itemId;
		}

	}




}