package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiMap extends UiComponent implements UiObject {


	protected Map<String, UiTemplate> markerTemplates;
	protected UiMapType mapType = UiMapType.MAP_BOX_STREETS;
	protected int zoomLevel = 5;
	protected UiMapLocation mapPosition;
	protected Map<String, UiMapPolyline> polylines;
	protected List<UiMapMarkerClientRecord> markers;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiMap() {
		// default constructor for Jackson
	}

	public UiMap(Map<String, UiTemplate> markerTemplates) {
		super();
		this.markerTemplates = markerTemplates;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_MAP;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append(markerTemplates != null ? "markerTemplates={" + markerTemplates.toString() + "}" : "").append(", ")
				.append("mapType=" + mapType).append(", ")
				.append("zoomLevel=" + zoomLevel).append(", ")
				.append(mapPosition != null ? "mapPosition={" + mapPosition.toString() + "}" : "").append(", ")
				.append(polylines != null ? "polylines={" + polylines.toString() + "}" : "").append(", ")
				.append(markers != null ? "markers={" + markers.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("markerTemplates")
	public Map<String, UiTemplate> getMarkerTemplates() {
		return markerTemplates;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("mapType")
	public UiMapType getMapType() {
		return mapType;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("zoomLevel")
	public int getZoomLevel() {
		return zoomLevel;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("mapPosition")
	public UiMapLocation getMapPosition() {
		return mapPosition;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("polylines")
	public Map<String, UiMapPolyline> getPolylines() {
		return polylines;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("markers")
	public List<UiMapMarkerClientRecord> getMarkers() {
		return markers;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiMap setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiMap setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiMap setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("mapType")
	public UiMap setMapType(UiMapType mapType) {
		this.mapType = mapType;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("zoomLevel")
	public UiMap setZoomLevel(int zoomLevel) {
		this.zoomLevel = zoomLevel;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("mapPosition")
	public UiMap setMapPosition(UiMapLocation mapPosition) {
		this.mapPosition = mapPosition;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("polylines")
	public UiMap setPolylines(Map<String, UiMapPolyline> polylines) {
		this.polylines = polylines;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("markers")
	public UiMap setMarkers(List<UiMapMarkerClientRecord> markers) {
		this.markers = markers;
		return this;
	}

	public static class ZoomLevelChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int zoomLevel;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ZoomLevelChangedEvent() {
			// default constructor for Jackson
		}

		public ZoomLevelChangedEvent(String componentId, int zoomLevel) {
			this.componentId = componentId;
			this.zoomLevel = zoomLevel;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MAP_ZOOM_LEVEL_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoomLevel=" + zoomLevel)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomLevel")
		public int getZoomLevel() {
			return zoomLevel;
		}

	}

	public static class LocationChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiMapLocation center;
		protected UiMapArea displayedArea;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public LocationChangedEvent() {
			// default constructor for Jackson
		}

		public LocationChangedEvent(String componentId, UiMapLocation center, UiMapArea displayedArea) {
			this.componentId = componentId;
			this.center = center;
			this.displayedArea = displayedArea;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MAP_LOCATION_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(center != null ? "center={" + center.toString() + "}" : "").append(", ")
					.append(displayedArea != null ? "displayedArea={" + displayedArea.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("center")
		public UiMapLocation getCenter() {
			return center;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("displayedArea")
		public UiMapArea getDisplayedArea() {
			return displayedArea;
		}

	}

	public static class MapClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiMapLocation location;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public MapClickedEvent() {
			// default constructor for Jackson
		}

		public MapClickedEvent(String componentId, UiMapLocation location) {
			this.componentId = componentId;
			this.location = location;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MAP_MAP_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(location != null ? "location={" + location.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("location")
		public UiMapLocation getLocation() {
			return location;
		}

	}

	public static class MarkerClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int markerId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public MarkerClickedEvent() {
			// default constructor for Jackson
		}

		public MarkerClickedEvent(String componentId, int markerId) {
			this.componentId = componentId;
			this.markerId = markerId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MAP_MARKER_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("markerId=" + markerId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("markerId")
		public int getMarkerId() {
			return markerId;
		}

	}

	public static class RegisterTemplateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String id;
		protected UiTemplate template;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RegisterTemplateCommand() {
			// default constructor for Jackson
		}

		public RegisterTemplateCommand(String componentId, String id, UiTemplate template) {
			this.componentId = componentId;
			this.id = id;
			this.template = template;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("id=" + id).append(", ")
					.append("componentId=" + componentId).append(", ")
					.append(template != null ? "template={" + template.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("id")
		public String getId() {
			return id;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("template")
		public UiTemplate getTemplate() {
			return template;
		}

	}

	public static class AddMarkerCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMapMarkerClientRecord marker;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddMarkerCommand() {
			// default constructor for Jackson
		}

		public AddMarkerCommand(String componentId, UiMapMarkerClientRecord marker) {
			this.componentId = componentId;
			this.marker = marker;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(marker != null ? "marker={" + marker.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("marker")
		public UiMapMarkerClientRecord getMarker() {
			return marker;
		}

	}

	public static class RemoveMarkerCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int id;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveMarkerCommand() {
			// default constructor for Jackson
		}

		public RemoveMarkerCommand(String componentId, int id) {
			this.componentId = componentId;
			this.id = id;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("id=" + id).append(", ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("id")
		public int getId() {
			return id;
		}

	}

	public static class SetMapMarkerClusterCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMapMarkerCluster cluster;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMapMarkerClusterCommand() {
			// default constructor for Jackson
		}

		public SetMapMarkerClusterCommand(String componentId, UiMapMarkerCluster cluster) {
			this.componentId = componentId;
			this.cluster = cluster;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(cluster != null ? "cluster={" + cluster.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("cluster")
		public UiMapMarkerCluster getCluster() {
			return cluster;
		}

	}

	public static class AddPolylineCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String lineId;
		protected UiMapPolyline polyline;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddPolylineCommand() {
			// default constructor for Jackson
		}

		public AddPolylineCommand(String componentId, String lineId, UiMapPolyline polyline) {
			this.componentId = componentId;
			this.lineId = lineId;
			this.polyline = polyline;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("lineId=" + lineId).append(", ")
					.append(polyline != null ? "polyline={" + polyline.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("lineId")
		public String getLineId() {
			return lineId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("polyline")
		public UiMapPolyline getPolyline() {
			return polyline;
		}

	}

	public static class AddPolylinePointsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String lineId;
		protected List<UiMapLocation> points;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddPolylinePointsCommand() {
			// default constructor for Jackson
		}

		public AddPolylinePointsCommand(String componentId, String lineId, List<UiMapLocation> points) {
			this.componentId = componentId;
			this.lineId = lineId;
			this.points = points;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("lineId=" + lineId).append(", ")
					.append(points != null ? "points={" + points.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("lineId")
		public String getLineId() {
			return lineId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("points")
		public List<UiMapLocation> getPoints() {
			return points;
		}

	}

	public static class RemovePolylineCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String lineId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemovePolylineCommand() {
			// default constructor for Jackson
		}

		public RemovePolylineCommand(String componentId, String lineId) {
			this.componentId = componentId;
			this.lineId = lineId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("lineId=" + lineId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("lineId")
		public String getLineId() {
			return lineId;
		}

	}

	public static class SetZoomLevelCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int zoom;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetZoomLevelCommand() {
			// default constructor for Jackson
		}

		public SetZoomLevelCommand(String componentId, int zoom) {
			this.componentId = componentId;
			this.zoom = zoom;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoom=" + zoom)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoom")
		public int getZoom() {
			return zoom;
		}

	}

	public static class SetLocationCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMapLocation location;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetLocationCommand() {
			// default constructor for Jackson
		}

		public SetLocationCommand(String componentId, UiMapLocation location) {
			this.componentId = componentId;
			this.location = location;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(location != null ? "location={" + location.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("location")
		public UiMapLocation getLocation() {
			return location;
		}

	}

	public static class SetMapTypeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMapType mapType;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMapTypeCommand() {
			// default constructor for Jackson
		}

		public SetMapTypeCommand(String componentId, UiMapType mapType) {
			this.componentId = componentId;
			this.mapType = mapType;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("mapType=" + mapType)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mapType")
		public UiMapType getMapType() {
			return mapType;
		}

	}

	public static class SetHeatMapCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiHeatMapData data;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetHeatMapCommand() {
			// default constructor for Jackson
		}

		public SetHeatMapCommand(String componentId, UiHeatMapData data) {
			this.componentId = componentId;
			this.data = data;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(data != null ? "data={" + data.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("data")
		public UiHeatMapData getData() {
			return data;
		}

	}




}