package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiRootPanel extends UiComponent implements UiObject {


	protected UiComponentReference content;

	public UiRootPanel() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_ROOT_PANEL;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append(content != null ? "content={" + content.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("content")
	public UiComponentReference getContent() {
		return content;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiRootPanel setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiRootPanel setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiRootPanel setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("content")
	public UiRootPanel setContent(UiComponentReference content) {
		this.content = content;
		return this;
	}


	public static class SetContentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference content;
		protected UiPageTransition transition;
		protected long animationDuration;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetContentCommand() {
			// default constructor for Jackson
		}

		public SetContentCommand(String componentId, UiComponentReference content, UiPageTransition transition, long animationDuration) {
			this.componentId = componentId;
			this.content = content;
			this.transition = transition;
			this.animationDuration = animationDuration;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("transition=" + transition).append(", ")
					.append("animationDuration=" + animationDuration).append(", ")
					.append(content != null ? "content={" + content.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("content")
		public UiComponentReference getContent() {
			return content;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("transition")
		public UiPageTransition getTransition() {
			return transition;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("animationDuration")
		public long getAnimationDuration() {
			return animationDuration;
		}

	}

	public static class CreateComponentCommand implements UiCommand<Void> {

		protected UiComponent component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CreateComponentCommand() {
			// default constructor for Jackson
		}

		public CreateComponentCommand(UiComponent component) {
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiComponent getComponent() {
			return component;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class DestroyComponentCommand implements UiCommand<Void> {

		protected String id;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public DestroyComponentCommand() {
			// default constructor for Jackson
		}

		public DestroyComponentCommand(String id) {
			this.id = id;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("id=" + id)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("id")
		public String getId() {
			return id;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class RefreshComponentCommand implements UiCommand<Void> {

		protected UiComponent component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RefreshComponentCommand() {
			// default constructor for Jackson
		}

		public RefreshComponentCommand(UiComponent component) {
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiComponent getComponent() {
			return component;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class SetConfigCommand implements UiCommand<Void> {

		protected UiConfiguration config;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetConfigCommand() {
			// default constructor for Jackson
		}

		public SetConfigCommand(UiConfiguration config) {
			this.config = config;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append(config != null ? "config={" + config.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("config")
		public UiConfiguration getConfig() {
			return config;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class SetThemeClassNameCommand implements UiCommand<Void> {

		protected String theme;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetThemeClassNameCommand() {
			// default constructor for Jackson
		}

		public SetThemeClassNameCommand(String theme) {
			this.theme = theme;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("theme=" + theme)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("theme")
		public String getTheme() {
			return theme;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class SetPageTitleCommand implements UiCommand<Void> {

		protected String pageTitle;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetPageTitleCommand() {
			// default constructor for Jackson
		}

		public SetPageTitleCommand(String pageTitle) {
			this.pageTitle = pageTitle;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("pageTitle=" + pageTitle)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("pageTitle")
		public String getPageTitle() {
			return pageTitle;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class BuildRootPanelCommand implements UiCommand<Void> {

		protected String containerElementId;
		protected UiComponentReference uiRootPanel;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public BuildRootPanelCommand() {
			// default constructor for Jackson
		}

		public BuildRootPanelCommand(String containerElementId, UiComponentReference uiRootPanel) {
			this.containerElementId = containerElementId;
			this.uiRootPanel = uiRootPanel;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("containerElementId=" + containerElementId).append(", ")
					.append(uiRootPanel != null ? "uiRootPanel={" + uiRootPanel.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("containerElementId")
		public String getContainerElementId() {
			return containerElementId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uiRootPanel")
		public UiComponentReference getUiRootPanel() {
			return uiRootPanel;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class RegisterTemplateCommand implements UiCommand<Void> {

		protected String id;
		protected UiTemplate template;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RegisterTemplateCommand() {
			// default constructor for Jackson
		}

		public RegisterTemplateCommand(String id, UiTemplate template) {
			this.id = id;
			this.template = template;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("id=" + id).append(", ")
					.append(template != null ? "template={" + template.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("id")
		public String getId() {
			return id;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("template")
		public UiTemplate getTemplate() {
			return template;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class RegisterTemplatesCommand implements UiCommand<Void> {

		protected Map<String, UiTemplate> templates;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RegisterTemplatesCommand() {
			// default constructor for Jackson
		}

		public RegisterTemplatesCommand(Map<String, UiTemplate> templates) {
			this.templates = templates;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append(templates != null ? "templates={" + templates.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("templates")
		public Map<String, UiTemplate> getTemplates() {
			return templates;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class AddClientTokenCommand implements UiCommand<Void> {

		protected String token;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddClientTokenCommand() {
			// default constructor for Jackson
		}

		public AddClientTokenCommand(String token) {
			this.token = token;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("token=" + token)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("token")
		public String getToken() {
			return token;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class RemoveClientTokenCommand implements UiCommand<Void> {

		protected String token;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveClientTokenCommand() {
			// default constructor for Jackson
		}

		public RemoveClientTokenCommand(String token) {
			this.token = token;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("token=" + token)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("token")
		public String getToken() {
			return token;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class ClearClientTokensCommand implements UiCommand<Void> {


		public ClearClientTokensCommand() {
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.toString();
		}


		public String getComponentId() {
			return null;
		}

	}

	public static class ShowWindowCommand implements UiCommand<Void> {

		protected UiComponentReference window;
		protected int animationDuration;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ShowWindowCommand() {
			// default constructor for Jackson
		}

		public ShowWindowCommand(UiComponentReference window, int animationDuration) {
			this.window = window;
			this.animationDuration = animationDuration;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("animationDuration=" + animationDuration).append(", ")
					.append(window != null ? "window={" + window.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("window")
		public UiComponentReference getWindow() {
			return window;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("animationDuration")
		public int getAnimationDuration() {
			return animationDuration;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class CloseWindowCommand implements UiCommand<Void> {

		protected String windowId;
		protected int animationDuration;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CloseWindowCommand() {
			// default constructor for Jackson
		}

		public CloseWindowCommand(String windowId, int animationDuration) {
			this.windowId = windowId;
			this.animationDuration = animationDuration;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("windowId=" + windowId).append(", ")
					.append("animationDuration=" + animationDuration)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("windowId")
		public String getWindowId() {
			return windowId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("animationDuration")
		public int getAnimationDuration() {
			return animationDuration;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class DownloadFileCommand implements UiCommand<Void> {

		protected String fileUrl;
		protected String downloadFileName;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public DownloadFileCommand() {
			// default constructor for Jackson
		}

		public DownloadFileCommand(String fileUrl, String downloadFileName) {
			this.fileUrl = fileUrl;
			this.downloadFileName = downloadFileName;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("downloadFileName=" + downloadFileName).append(", ")
					.append("fileUrl=" + fileUrl)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileUrl")
		public String getFileUrl() {
			return fileUrl;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("downloadFileName")
		public String getDownloadFileName() {
			return downloadFileName;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class RegisterBackgroundImageCommand implements UiCommand<Void> {

		protected String id;
		protected String image;
		protected String blurredImage;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RegisterBackgroundImageCommand() {
			// default constructor for Jackson
		}

		public RegisterBackgroundImageCommand(String id, String image, String blurredImage) {
			this.id = id;
			this.image = image;
			this.blurredImage = blurredImage;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("id=" + id).append(", ")
					.append("image=" + image).append(", ")
					.append("blurredImage=" + blurredImage)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("id")
		public String getId() {
			return id;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("image")
		public String getImage() {
			return image;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("blurredImage")
		public String getBlurredImage() {
			return blurredImage;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class SetBackgroundImageCommand implements UiCommand<Void> {

		protected String id;
		protected int animationDuration = 1000;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBackgroundImageCommand() {
			// default constructor for Jackson
		}

		public SetBackgroundImageCommand(String id, int animationDuration) {
			this.id = id;
			this.animationDuration = animationDuration;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("id=" + id).append(", ")
					.append("animationDuration=" + animationDuration)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("id")
		public String getId() {
			return id;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("animationDuration")
		public int getAnimationDuration() {
			return animationDuration;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class SetBackgroundColorCommand implements UiCommand<Void> {

		protected UiColor color;
		protected int animationDuration = 1000;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBackgroundColorCommand() {
			// default constructor for Jackson
		}

		public SetBackgroundColorCommand(UiColor color, int animationDuration) {
			this.color = color;
			this.animationDuration = animationDuration;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("animationDuration=" + animationDuration).append(", ")
					.append(color != null ? "color={" + color.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("color")
		public UiColor getColor() {
			return color;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("animationDuration")
		public int getAnimationDuration() {
			return animationDuration;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class ExitFullScreenCommand implements UiCommand<Void> {


		public ExitFullScreenCommand() {
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.toString();
		}


		public String getComponentId() {
			return null;
		}

	}

	public static class ShowNotificationCommand implements UiCommand<Void> {

		protected UiNotification notification;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ShowNotificationCommand() {
			// default constructor for Jackson
		}

		public ShowNotificationCommand(UiNotification notification) {
			this.notification = notification;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append(notification != null ? "notification={" + notification.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("notification")
		public UiNotification getNotification() {
			return notification;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class ShowDialogMessageCommand implements UiCommand<Void> {

		protected String icon;
		protected String title;
		protected String message;
		protected List<UiGenericErrorMessageOption> options;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ShowDialogMessageCommand() {
			// default constructor for Jackson
		}

		public ShowDialogMessageCommand(String icon, String title, String message, List<UiGenericErrorMessageOption> options) {
			this.icon = icon;
			this.title = title;
			this.message = message;
			this.options = options;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("icon=" + icon).append(", ")
					.append("title=" + title).append(", ")
					.append("message=" + message).append(", ")
					.append("options=" + options)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("icon")
		public String getIcon() {
			return icon;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("title")
		public String getTitle() {
			return title;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("message")
		public String getMessage() {
			return message;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("options")
		public List<UiGenericErrorMessageOption> getOptions() {
			return options;
		}

		public String getComponentId() {
			return null;
		}

	}




}