package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiTableColumn implements UiObject {


	protected String propertyName;
	protected String icon;
	protected String title;
	protected UiComponentReference field;
	protected int minWidth;
	protected int defaultWidth;
	protected int maxWidth;
	protected boolean sortable = true;
	protected boolean resizeable = true;
	protected boolean visible = true;
	protected boolean hiddenIfOnlyEmptyCellsVisible = false;
	protected List<UiFieldMessage> messages;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiTableColumn() {
		// default constructor for Jackson
	}

	public UiTableColumn(String propertyName, String icon, String title, UiComponentReference field) {
		this.propertyName = propertyName;
		this.icon = icon;
		this.title = title;
		this.field = field;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TABLE_COLUMN;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("propertyName=" + propertyName).append(", ")
				.append("icon=" + icon).append(", ")
				.append("title=" + title).append(", ")
				.append("minWidth=" + minWidth).append(", ")
				.append("defaultWidth=" + defaultWidth).append(", ")
				.append("maxWidth=" + maxWidth).append(", ")
				.append("sortable=" + sortable).append(", ")
				.append("resizeable=" + resizeable).append(", ")
				.append("visible=" + visible).append(", ")
				.append("hiddenIfOnlyEmptyCellsVisible=" + hiddenIfOnlyEmptyCellsVisible).append(", ")
				.append(field != null ? "field={" + field.toString() + "}" : "").append(", ")
				.append(messages != null ? "messages={" + messages.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("propertyName")
	public String getPropertyName() {
		return propertyName;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("icon")
	public String getIcon() {
		return icon;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("title")
	public String getTitle() {
		return title;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("field")
	public UiComponentReference getField() {
		return field;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("minWidth")
	public int getMinWidth() {
		return minWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("defaultWidth")
	public int getDefaultWidth() {
		return defaultWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxWidth")
	public int getMaxWidth() {
		return maxWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("sortable")
	public boolean getSortable() {
		return sortable;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("resizeable")
	public boolean getResizeable() {
		return resizeable;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("visible")
	public boolean getVisible() {
		return visible;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("hiddenIfOnlyEmptyCellsVisible")
	public boolean getHiddenIfOnlyEmptyCellsVisible() {
		return hiddenIfOnlyEmptyCellsVisible;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("messages")
	public List<UiFieldMessage> getMessages() {
		return messages;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("minWidth")
	public UiTableColumn setMinWidth(int minWidth) {
		this.minWidth = minWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("defaultWidth")
	public UiTableColumn setDefaultWidth(int defaultWidth) {
		this.defaultWidth = defaultWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxWidth")
	public UiTableColumn setMaxWidth(int maxWidth) {
		this.maxWidth = maxWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("sortable")
	public UiTableColumn setSortable(boolean sortable) {
		this.sortable = sortable;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("resizeable")
	public UiTableColumn setResizeable(boolean resizeable) {
		this.resizeable = resizeable;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiTableColumn setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("hiddenIfOnlyEmptyCellsVisible")
	public UiTableColumn setHiddenIfOnlyEmptyCellsVisible(boolean hiddenIfOnlyEmptyCellsVisible) {
		this.hiddenIfOnlyEmptyCellsVisible = hiddenIfOnlyEmptyCellsVisible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("messages")
	public UiTableColumn setMessages(List<UiFieldMessage> messages) {
		this.messages = messages;
		return this;
	}






}