package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiTimeGraph extends UiComponent implements UiObject {


	protected UiLineChartYScaleZoomMode yScaleZoomMode = UiLineChartYScaleZoomMode.DYNAMIC_INCLUDING_ZERO;
	protected UiLongInterval intervalX;
	protected List<UiTimeChartZoomLevel> zoomLevels;
	protected int maxPixelsBetweenDataPoints;
	protected Map<String, UiLineChartLineFormat> lineFormats;
	protected UiScaleType yScaleType = UiScaleType.LINEAR;
	protected UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode = UiLineChartMouseScrollZoomPanMode.ENABLED;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiTimeGraph() {
		// default constructor for Jackson
	}

	public UiTimeGraph(UiLongInterval intervalX, List<UiTimeChartZoomLevel> zoomLevels, int maxPixelsBetweenDataPoints, Map<String, UiLineChartLineFormat> lineFormats) {
		super();
		this.intervalX = intervalX;
		this.zoomLevels = zoomLevels;
		this.maxPixelsBetweenDataPoints = maxPixelsBetweenDataPoints;
		this.lineFormats = lineFormats;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TIME_GRAPH;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("yScaleZoomMode=" + yScaleZoomMode).append(", ")
				.append("maxPixelsBetweenDataPoints=" + maxPixelsBetweenDataPoints).append(", ")
				.append("yScaleType=" + yScaleType).append(", ")
				.append("mouseScrollZoomPanMode=" + mouseScrollZoomPanMode).append(", ")
				.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "").append(", ")
				.append(zoomLevels != null ? "zoomLevels={" + zoomLevels.toString() + "}" : "").append(", ")
				.append(lineFormats != null ? "lineFormats={" + lineFormats.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("yScaleZoomMode")
	public UiLineChartYScaleZoomMode getYScaleZoomMode() {
		return yScaleZoomMode;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
	public UiLongInterval getIntervalX() {
		return intervalX;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("zoomLevels")
	public List<UiTimeChartZoomLevel> getZoomLevels() {
		return zoomLevels;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxPixelsBetweenDataPoints")
	public int getMaxPixelsBetweenDataPoints() {
		return maxPixelsBetweenDataPoints;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("lineFormats")
	public Map<String, UiLineChartLineFormat> getLineFormats() {
		return lineFormats;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("yScaleType")
	public UiScaleType getYScaleType() {
		return yScaleType;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("mouseScrollZoomPanMode")
	public UiLineChartMouseScrollZoomPanMode getMouseScrollZoomPanMode() {
		return mouseScrollZoomPanMode;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiTimeGraph setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiTimeGraph setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiTimeGraph setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("yScaleZoomMode")
	public UiTimeGraph setYScaleZoomMode(UiLineChartYScaleZoomMode yScaleZoomMode) {
		this.yScaleZoomMode = yScaleZoomMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("yScaleType")
	public UiTimeGraph setYScaleType(UiScaleType yScaleType) {
		this.yScaleType = yScaleType;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("mouseScrollZoomPanMode")
	public UiTimeGraph setMouseScrollZoomPanMode(UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode) {
		this.mouseScrollZoomPanMode = mouseScrollZoomPanMode;
		return this;
	}

	public static class DataNeededEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int zoomLevelIndex;
		protected UiLongInterval neededIntervalX;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public DataNeededEvent() {
			// default constructor for Jackson
		}

		public DataNeededEvent(String componentId, int zoomLevelIndex, UiLongInterval neededIntervalX) {
			this.componentId = componentId;
			this.zoomLevelIndex = zoomLevelIndex;
			this.neededIntervalX = neededIntervalX;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TIME_GRAPH_DATA_NEEDED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoomLevelIndex=" + zoomLevelIndex).append(", ")
					.append(neededIntervalX != null ? "neededIntervalX={" + neededIntervalX.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomLevelIndex")
		public int getZoomLevelIndex() {
			return zoomLevelIndex;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("neededIntervalX")
		public UiLongInterval getNeededIntervalX() {
			return neededIntervalX;
		}

	}

	public static class ZoomedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiLongInterval intervalX;
		protected int zoomLevelIndex;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ZoomedEvent() {
			// default constructor for Jackson
		}

		public ZoomedEvent(String componentId, UiLongInterval intervalX, int zoomLevelIndex) {
			this.componentId = componentId;
			this.intervalX = intervalX;
			this.zoomLevelIndex = zoomLevelIndex;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TIME_GRAPH_ZOOMED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoomLevelIndex=" + zoomLevelIndex).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomLevelIndex")
		public int getZoomLevelIndex() {
			return zoomLevelIndex;
		}

	}

	public static class IntervalSelectedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiLongInterval intervalX;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public IntervalSelectedEvent() {
			// default constructor for Jackson
		}

		public IntervalSelectedEvent(String componentId, UiLongInterval intervalX) {
			this.componentId = componentId;
			this.intervalX = intervalX;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TIME_GRAPH_INTERVAL_SELECTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

	}

	public static class SetIntervalXCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiLongInterval intervalX;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetIntervalXCommand() {
			// default constructor for Jackson
		}

		public SetIntervalXCommand(String componentId, UiLongInterval intervalX) {
			this.componentId = componentId;
			this.intervalX = intervalX;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

	}

	public static class SetMaxPixelsBetweenDataPointsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int maxPixelsBetweenDataPoints;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMaxPixelsBetweenDataPointsCommand() {
			// default constructor for Jackson
		}

		public SetMaxPixelsBetweenDataPointsCommand(String componentId, int maxPixelsBetweenDataPoints) {
			this.componentId = componentId;
			this.maxPixelsBetweenDataPoints = maxPixelsBetweenDataPoints;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("maxPixelsBetweenDataPoints=" + maxPixelsBetweenDataPoints)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("maxPixelsBetweenDataPoints")
		public int getMaxPixelsBetweenDataPoints() {
			return maxPixelsBetweenDataPoints;
		}

	}

	public static class AddDataCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int zoomLevel;
		protected UiLongInterval intervalX;
		protected Map<String, List<UiTimeGraphDataPoint>> data;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddDataCommand() {
			// default constructor for Jackson
		}

		public AddDataCommand(String componentId, int zoomLevel, UiLongInterval intervalX, Map<String, List<UiTimeGraphDataPoint>> data) {
			this.componentId = componentId;
			this.zoomLevel = zoomLevel;
			this.intervalX = intervalX;
			this.data = data;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoomLevel=" + zoomLevel).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "").append(", ")
					.append(data != null ? "data={" + data.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomLevel")
		public int getZoomLevel() {
			return zoomLevel;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("data")
		public Map<String, List<UiTimeGraphDataPoint>> getData() {
			return data;
		}

	}

	public static class ResetAllDataCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiTimeChartZoomLevel> newZoomLevels;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ResetAllDataCommand() {
			// default constructor for Jackson
		}

		public ResetAllDataCommand(String componentId, List<UiTimeChartZoomLevel> newZoomLevels) {
			this.componentId = componentId;
			this.newZoomLevels = newZoomLevels;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(newZoomLevels != null ? "newZoomLevels={" + newZoomLevels.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("newZoomLevels")
		public List<UiTimeChartZoomLevel> getNewZoomLevels() {
			return newZoomLevels;
		}

	}

	public static class ReplaceAllDataCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiTimeChartZoomLevel> newZoomLevels;
		protected int zoomLevel;
		protected UiLongInterval intervalX;
		protected Map<String, List<UiTimeGraphDataPoint>> data;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ReplaceAllDataCommand() {
			// default constructor for Jackson
		}

		public ReplaceAllDataCommand(String componentId, List<UiTimeChartZoomLevel> newZoomLevels, int zoomLevel, UiLongInterval intervalX, Map<String, List<UiTimeGraphDataPoint>> data) {
			this.componentId = componentId;
			this.newZoomLevels = newZoomLevels;
			this.zoomLevel = zoomLevel;
			this.intervalX = intervalX;
			this.data = data;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoomLevel=" + zoomLevel).append(", ")
					.append(newZoomLevels != null ? "newZoomLevels={" + newZoomLevels.toString() + "}" : "").append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "").append(", ")
					.append(data != null ? "data={" + data.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("newZoomLevels")
		public List<UiTimeChartZoomLevel> getNewZoomLevels() {
			return newZoomLevels;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomLevel")
		public int getZoomLevel() {
			return zoomLevel;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("data")
		public Map<String, List<UiTimeGraphDataPoint>> getData() {
			return data;
		}

	}

	public static class SetMouseScrollZoomPanModeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMouseScrollZoomPanModeCommand() {
			// default constructor for Jackson
		}

		public SetMouseScrollZoomPanModeCommand(String componentId, UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode) {
			this.componentId = componentId;
			this.mouseScrollZoomPanMode = mouseScrollZoomPanMode;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("mouseScrollZoomPanMode=" + mouseScrollZoomPanMode)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mouseScrollZoomPanMode")
		public UiLineChartMouseScrollZoomPanMode getMouseScrollZoomPanMode() {
			return mouseScrollZoomPanMode;
		}

	}

	public static class SetSelectedIntervalCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiLongInterval intervalX;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetSelectedIntervalCommand() {
			// default constructor for Jackson
		}

		public SetSelectedIntervalCommand(String componentId, UiLongInterval intervalX) {
			this.componentId = componentId;
			this.intervalX = intervalX;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

	}

	public static class SetLineFormatsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected Map<String, UiLineChartLineFormat> lineFormats;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetLineFormatsCommand() {
			// default constructor for Jackson
		}

		public SetLineFormatsCommand(String componentId, Map<String, UiLineChartLineFormat> lineFormats) {
			this.componentId = componentId;
			this.lineFormats = lineFormats;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(lineFormats != null ? "lineFormats={" + lineFormats.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("lineFormats")
		public Map<String, UiLineChartLineFormat> getLineFormats() {
			return lineFormats;
		}

	}

	public static class SetLineFormatCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String lineId;
		protected UiLineChartLineFormat lineFormat;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetLineFormatCommand() {
			// default constructor for Jackson
		}

		public SetLineFormatCommand(String componentId, String lineId, UiLineChartLineFormat lineFormat) {
			this.componentId = componentId;
			this.lineId = lineId;
			this.lineFormat = lineFormat;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("lineId=" + lineId).append(", ")
					.append(lineFormat != null ? "lineFormat={" + lineFormat.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("lineId")
		public String getLineId() {
			return lineId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("lineFormat")
		public UiLineChartLineFormat getLineFormat() {
			return lineFormat;
		}

	}

	public static class SetIntervalYCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String lineId;
		protected UiLongInterval intervalY;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetIntervalYCommand() {
			// default constructor for Jackson
		}

		public SetIntervalYCommand(String componentId, String lineId, UiLongInterval intervalY) {
			this.componentId = componentId;
			this.lineId = lineId;
			this.intervalY = intervalY;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("lineId=" + lineId).append(", ")
					.append(intervalY != null ? "intervalY={" + intervalY.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("lineId")
		public String getLineId() {
			return lineId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalY")
		public UiLongInterval getIntervalY() {
			return intervalY;
		}

	}

	public static class SetYScaleTypeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String lineId;
		protected UiScaleType yScaleType;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetYScaleTypeCommand() {
			// default constructor for Jackson
		}

		public SetYScaleTypeCommand(String componentId, String lineId, UiScaleType yScaleType) {
			this.componentId = componentId;
			this.lineId = lineId;
			this.yScaleType = yScaleType;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("lineId=" + lineId).append(", ")
					.append("yScaleType=" + yScaleType)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("lineId")
		public String getLineId() {
			return lineId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("yScaleType")
		public UiScaleType getYScaleType() {
			return yScaleType;
		}

	}

	public static class SetYScaleZoomModeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String lineId;
		protected UiLineChartYScaleZoomMode yScaleZoomMode;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetYScaleZoomModeCommand() {
			// default constructor for Jackson
		}

		public SetYScaleZoomModeCommand(String componentId, String lineId, UiLineChartYScaleZoomMode yScaleZoomMode) {
			this.componentId = componentId;
			this.lineId = lineId;
			this.yScaleZoomMode = yScaleZoomMode;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("lineId=" + lineId).append(", ")
					.append("yScaleZoomMode=" + yScaleZoomMode)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("lineId")
		public String getLineId() {
			return lineId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("yScaleZoomMode")
		public UiLineChartYScaleZoomMode getYScaleZoomMode() {
			return yScaleZoomMode;
		}

	}




}