/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiImageCropperSelection;
import org.teamapps.dto.UiImageCropperSelectionMode;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiImageCropper
extends UiComponent
implements UiObject {
    protected String imageUrl;
    protected UiImageCropperSelectionMode selectionMode;
    protected float aspectRatio = 1.0f;
    protected UiImageCropperSelection selection;

    @Deprecated
    public UiImageCropper() {
    }

    public UiImageCropper(String imageUrl, UiImageCropperSelectionMode selectionMode, float aspectRatio) {
        this.imageUrl = imageUrl;
        this.selectionMode = selectionMode;
        this.aspectRatio = aspectRatio;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_IMAGE_CROPPER;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("imageUrl=" + this.imageUrl) + ", " + ("selectionMode=" + this.selectionMode) + ", " + ("aspectRatio=" + this.aspectRatio) + ", " + (String)(this.selection != null ? "selection={" + this.selection.toString() + "}" : "");
    }

    @JsonGetter(value="imageUrl")
    public String getImageUrl() {
        return this.imageUrl;
    }

    @JsonGetter(value="selectionMode")
    public UiImageCropperSelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    @JsonGetter(value="aspectRatio")
    public float getAspectRatio() {
        return this.aspectRatio;
    }

    @JsonGetter(value="selection")
    public UiImageCropperSelection getSelection() {
        return this.selection;
    }

    @Override
    @JsonSetter(value="id")
    public UiImageCropper setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiImageCropper setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiImageCropper setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="selection")
    public UiImageCropper setSelection(UiImageCropperSelection selection) {
        this.selection = selection;
        return this;
    }

    public static class SetSelectionCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiImageCropperSelection selection;

        @Deprecated
        public SetSelectionCommand() {
        }

        public SetSelectionCommand(String componentId, UiImageCropperSelection selection) {
            this.componentId = componentId;
            this.selection = selection;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.selection != null ? "selection={" + this.selection.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="selection")
        public UiImageCropperSelection getSelection() {
            return this.selection;
        }
    }

    public static class SetAspectRatioCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected float aspectRatio;

        @Deprecated
        public SetAspectRatioCommand() {
        }

        public SetAspectRatioCommand(String componentId, float aspectRatio) {
            this.componentId = componentId;
            this.aspectRatio = aspectRatio;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("aspectRatio=" + this.aspectRatio);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="aspectRatio")
        public float getAspectRatio() {
            return this.aspectRatio;
        }
    }

    public static class SetSelectionModeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiImageCropperSelectionMode selectionMode;

        @Deprecated
        public SetSelectionModeCommand() {
        }

        public SetSelectionModeCommand(String componentId, UiImageCropperSelectionMode selectionMode) {
            this.componentId = componentId;
            this.selectionMode = selectionMode;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("selectionMode=" + this.selectionMode);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="selectionMode")
        public UiImageCropperSelectionMode getSelectionMode() {
            return this.selectionMode;
        }
    }

    public static class SetImageUrlCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String imageUrl;

        @Deprecated
        public SetImageUrlCommand() {
        }

        public SetImageUrlCommand(String componentId, String imageUrl) {
            this.componentId = componentId;
            this.imageUrl = imageUrl;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("imageUrl=" + this.imageUrl);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="imageUrl")
        public String getImageUrl() {
            return this.imageUrl;
        }
    }

    public static class SelectionChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiImageCropperSelection selection;

        @Deprecated
        public SelectionChangedEvent() {
        }

        public SelectionChangedEvent(String componentId, UiImageCropperSelection selection) {
            this.componentId = componentId;
            this.selection = selection;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_IMAGE_CROPPER_SELECTION_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.selection != null ? "selection={" + this.selection.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="selection")
        public UiImageCropperSelection getSelection() {
            return this.selection;
        }
    }
}

