package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type", defaultImpl = UiChatDisplay.class)
public class UiChatDisplay extends UiComponent implements UiObject {


	protected UiChatMessageBatch initialMessages;
	protected boolean contextMenuEnabled = false;
	protected String deletedMessageIcon;

	public UiChatDisplay() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_CHAT_DISPLAY;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("contextMenuEnabled=" + contextMenuEnabled).append(", ")
				.append("deletedMessageIcon=" + deletedMessageIcon).append(", ")
				.append(initialMessages != null ? "initialMessages={" + initialMessages.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("initialMessages")
	public UiChatMessageBatch getInitialMessages() {
		return initialMessages;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("contextMenuEnabled")
	public boolean getContextMenuEnabled() {
		return contextMenuEnabled;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("deletedMessageIcon")
	public String getDeletedMessageIcon() {
		return deletedMessageIcon;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiChatDisplay setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiChatDisplay setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiChatDisplay setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiChatDisplay setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiChatDisplay setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiChatDisplay setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("initialMessages")
	public UiChatDisplay setInitialMessages(UiChatMessageBatch initialMessages) {
		this.initialMessages = initialMessages;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("contextMenuEnabled")
	public UiChatDisplay setContextMenuEnabled(boolean contextMenuEnabled) {
		this.contextMenuEnabled = contextMenuEnabled;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("deletedMessageIcon")
	public UiChatDisplay setDeletedMessageIcon(String deletedMessageIcon) {
		this.deletedMessageIcon = deletedMessageIcon;
		return this;
	}


	public static class RequestPreviousMessagesQuery implements UiQuery {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RequestPreviousMessagesQuery() {
			// default constructor for Jackson
		}

		public RequestPreviousMessagesQuery(String componentId) {
			this.componentId = componentId;
		}

		public UiQueryType getUiQueryType() {
			return UiQueryType.UI_CHAT_DISPLAY_REQUEST_PREVIOUS_MESSAGES;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class RequestContextMenuQuery implements UiQuery {

		@UiComponentId protected String componentId;
		protected int chatMessageId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RequestContextMenuQuery() {
			// default constructor for Jackson
		}

		public RequestContextMenuQuery(String componentId, int chatMessageId) {
			this.componentId = componentId;
			this.chatMessageId = chatMessageId;
		}

		public UiQueryType getUiQueryType() {
			return UiQueryType.UI_CHAT_DISPLAY_REQUEST_CONTEXT_MENU;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("chatMessageId=" + chatMessageId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("chatMessageId")
		public int getChatMessageId() {
			return chatMessageId;
		}

	}

	public static class AddMessagesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiChatMessageBatch messages;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddMessagesCommand() {
			// default constructor for Jackson
		}

		public AddMessagesCommand(String componentId, UiChatMessageBatch messages) {
			this.componentId = componentId;
			this.messages = messages;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(messages != null ? "messages={" + messages.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("messages")
		public UiChatMessageBatch getMessages() {
			return messages;
		}

	}

	public static class UpdateMessageCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiChatMessage message;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateMessageCommand() {
			// default constructor for Jackson
		}

		public UpdateMessageCommand(String componentId, UiChatMessage message) {
			this.componentId = componentId;
			this.message = message;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(message != null ? "message={" + message.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("message")
		public UiChatMessage getMessage() {
			return message;
		}

	}

	public static class DeleteMessageCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int messageId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public DeleteMessageCommand() {
			// default constructor for Jackson
		}

		public DeleteMessageCommand(String componentId, int messageId) {
			this.componentId = componentId;
			this.messageId = messageId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("messageId=" + messageId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("messageId")
		public int getMessageId() {
			return messageId;
		}

	}

	public static class ClearMessagesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiChatMessageBatch messages;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ClearMessagesCommand() {
			// default constructor for Jackson
		}

		public ClearMessagesCommand(String componentId, UiChatMessageBatch messages) {
			this.componentId = componentId;
			this.messages = messages;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(messages != null ? "messages={" + messages.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("messages")
		public UiChatMessageBatch getMessages() {
			return messages;
		}

	}

	public static class CloseContextMenuCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CloseContextMenuCommand() {
			// default constructor for Jackson
		}

		public CloseContextMenuCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

}