package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type", defaultImpl = UiMap2.class)
public class UiMap2 extends UiComponent implements UiObject {


	protected Map<String, UiTemplate> markerTemplates;
	protected String baseApiUrl;
	protected String accessToken;
	protected String styleUrl;
	protected boolean displayAttributionControl;
	protected float zoomLevel = 5;
	protected UiMapLocation mapPosition;
	protected Map<String, AbstractUiMapShape> shapes;
	protected List<UiMapMarkerClientRecord> markers;
	protected UiMapMarkerCluster markerCluster;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiMap2() {
		// default constructor for Jackson
	}

	public UiMap2(Map<String, UiTemplate> markerTemplates) {
		super();
		this.markerTemplates = markerTemplates;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_MAP2;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append(markerTemplates != null ? "markerTemplates={" + markerTemplates.toString() + "}" : "").append(", ")
				.append("baseApiUrl=" + baseApiUrl).append(", ")
				.append("accessToken=" + accessToken).append(", ")
				.append("styleUrl=" + styleUrl).append(", ")
				.append("displayAttributionControl=" + displayAttributionControl).append(", ")
				.append("zoomLevel=" + zoomLevel).append(", ")
				.append(mapPosition != null ? "mapPosition={" + mapPosition.toString() + "}" : "").append(", ")
				.append(shapes != null ? "shapes={" + shapes.toString() + "}" : "").append(", ")
				.append(markers != null ? "markers={" + markers.toString() + "}" : "").append(", ")
				.append(markerCluster != null ? "markerCluster={" + markerCluster.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("markerTemplates")
	public Map<String, UiTemplate> getMarkerTemplates() {
		return markerTemplates;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("baseApiUrl")
	public String getBaseApiUrl() {
		return baseApiUrl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("accessToken")
	public String getAccessToken() {
		return accessToken;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("styleUrl")
	public String getStyleUrl() {
		return styleUrl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("displayAttributionControl")
	public boolean getDisplayAttributionControl() {
		return displayAttributionControl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("zoomLevel")
	public float getZoomLevel() {
		return zoomLevel;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("mapPosition")
	public UiMapLocation getMapPosition() {
		return mapPosition;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("shapes")
	public Map<String, AbstractUiMapShape> getShapes() {
		return shapes;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("markers")
	public List<UiMapMarkerClientRecord> getMarkers() {
		return markers;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("markerCluster")
	public UiMapMarkerCluster getMarkerCluster() {
		return markerCluster;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiMap2 setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiMap2 setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiMap2 setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiMap2 setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiMap2 setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiMap2 setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("baseApiUrl")
	public UiMap2 setBaseApiUrl(String baseApiUrl) {
		this.baseApiUrl = baseApiUrl;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("accessToken")
	public UiMap2 setAccessToken(String accessToken) {
		this.accessToken = accessToken;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("styleUrl")
	public UiMap2 setStyleUrl(String styleUrl) {
		this.styleUrl = styleUrl;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("displayAttributionControl")
	public UiMap2 setDisplayAttributionControl(boolean displayAttributionControl) {
		this.displayAttributionControl = displayAttributionControl;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("zoomLevel")
	public UiMap2 setZoomLevel(float zoomLevel) {
		this.zoomLevel = zoomLevel;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("mapPosition")
	public UiMap2 setMapPosition(UiMapLocation mapPosition) {
		this.mapPosition = mapPosition;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("shapes")
	public UiMap2 setShapes(Map<String, AbstractUiMapShape> shapes) {
		this.shapes = shapes;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("markers")
	public UiMap2 setMarkers(List<UiMapMarkerClientRecord> markers) {
		this.markers = markers;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("markerCluster")
	public UiMap2 setMarkerCluster(UiMapMarkerCluster markerCluster) {
		this.markerCluster = markerCluster;
		return this;
	}

	public static class ZoomLevelChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected float zoomLevel;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ZoomLevelChangedEvent() {
			// default constructor for Jackson
		}

		public ZoomLevelChangedEvent(String componentId, float zoomLevel) {
			this.componentId = componentId;
			this.zoomLevel = zoomLevel;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MAP2_ZOOM_LEVEL_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoomLevel=" + zoomLevel)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomLevel")
		public float getZoomLevel() {
			return zoomLevel;
		}

	}

	public static class LocationChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiMapLocation center;
		protected UiMapArea displayedArea;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public LocationChangedEvent() {
			// default constructor for Jackson
		}

		public LocationChangedEvent(String componentId, UiMapLocation center, UiMapArea displayedArea) {
			this.componentId = componentId;
			this.center = center;
			this.displayedArea = displayedArea;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MAP2_LOCATION_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(center != null ? "center={" + center.toString() + "}" : "").append(", ")
					.append(displayedArea != null ? "displayedArea={" + displayedArea.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("center")
		public UiMapLocation getCenter() {
			return center;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("displayedArea")
		public UiMapArea getDisplayedArea() {
			return displayedArea;
		}

	}

	public static class MapClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiMapLocation location;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public MapClickedEvent() {
			// default constructor for Jackson
		}

		public MapClickedEvent(String componentId, UiMapLocation location) {
			this.componentId = componentId;
			this.location = location;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MAP2_MAP_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(location != null ? "location={" + location.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("location")
		public UiMapLocation getLocation() {
			return location;
		}

	}

	public static class MarkerClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int markerId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public MarkerClickedEvent() {
			// default constructor for Jackson
		}

		public MarkerClickedEvent(String componentId, int markerId) {
			this.componentId = componentId;
			this.markerId = markerId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MAP2_MARKER_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("markerId=" + markerId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("markerId")
		public int getMarkerId() {
			return markerId;
		}

	}

	public static class ShapeDrawnEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String shapeId;
		protected AbstractUiMapShape shape;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ShapeDrawnEvent() {
			// default constructor for Jackson
		}

		public ShapeDrawnEvent(String componentId, String shapeId, AbstractUiMapShape shape) {
			this.componentId = componentId;
			this.shapeId = shapeId;
			this.shape = shape;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MAP2_SHAPE_DRAWN;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("shapeId=" + shapeId).append(", ")
					.append(shape != null ? "shape={" + shape.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("shapeId")
		public String getShapeId() {
			return shapeId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("shape")
		public AbstractUiMapShape getShape() {
			return shape;
		}

	}


	public static class RegisterTemplateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String id;
		protected UiTemplate template;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RegisterTemplateCommand() {
			// default constructor for Jackson
		}

		public RegisterTemplateCommand(String componentId, String id, UiTemplate template) {
			this.componentId = componentId;
			this.id = id;
			this.template = template;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("id=" + id).append(", ")
					.append("componentId=" + componentId).append(", ")
					.append(template != null ? "template={" + template.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("id")
		public String getId() {
			return id;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("template")
		public UiTemplate getTemplate() {
			return template;
		}

	}

	public static class AddMarkerCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMapMarkerClientRecord marker;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddMarkerCommand() {
			// default constructor for Jackson
		}

		public AddMarkerCommand(String componentId, UiMapMarkerClientRecord marker) {
			this.componentId = componentId;
			this.marker = marker;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(marker != null ? "marker={" + marker.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("marker")
		public UiMapMarkerClientRecord getMarker() {
			return marker;
		}

	}

	public static class RemoveMarkerCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int id;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveMarkerCommand() {
			// default constructor for Jackson
		}

		public RemoveMarkerCommand(String componentId, int id) {
			this.componentId = componentId;
			this.id = id;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("id=" + id).append(", ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("id")
		public int getId() {
			return id;
		}

	}

	public static class ClearMarkersCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ClearMarkersCommand() {
			// default constructor for Jackson
		}

		public ClearMarkersCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class SetMapMarkerClusterCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMapMarkerCluster cluster;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMapMarkerClusterCommand() {
			// default constructor for Jackson
		}

		public SetMapMarkerClusterCommand(String componentId, UiMapMarkerCluster cluster) {
			this.componentId = componentId;
			this.cluster = cluster;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(cluster != null ? "cluster={" + cluster.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("cluster")
		public UiMapMarkerCluster getCluster() {
			return cluster;
		}

	}

	public static class SetHeatMapCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiHeatMapData data;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetHeatMapCommand() {
			// default constructor for Jackson
		}

		public SetHeatMapCommand(String componentId, UiHeatMapData data) {
			this.componentId = componentId;
			this.data = data;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(data != null ? "data={" + data.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("data")
		public UiHeatMapData getData() {
			return data;
		}

	}

	public static class AddShapeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String shapeId;
		protected AbstractUiMapShape shape;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddShapeCommand() {
			// default constructor for Jackson
		}

		public AddShapeCommand(String componentId, String shapeId, AbstractUiMapShape shape) {
			this.componentId = componentId;
			this.shapeId = shapeId;
			this.shape = shape;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("shapeId=" + shapeId).append(", ")
					.append(shape != null ? "shape={" + shape.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("shapeId")
		public String getShapeId() {
			return shapeId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("shape")
		public AbstractUiMapShape getShape() {
			return shape;
		}

	}

	public static class UpdateShapeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String shapeId;
		protected AbstractUiMapShape shape;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateShapeCommand() {
			// default constructor for Jackson
		}

		public UpdateShapeCommand(String componentId, String shapeId, AbstractUiMapShape shape) {
			this.componentId = componentId;
			this.shapeId = shapeId;
			this.shape = shape;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("shapeId=" + shapeId).append(", ")
					.append(shape != null ? "shape={" + shape.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("shapeId")
		public String getShapeId() {
			return shapeId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("shape")
		public AbstractUiMapShape getShape() {
			return shape;
		}

	}

	public static class ChangeShapeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String shapeId;
		protected AbstractUiMapShapeChange change;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ChangeShapeCommand() {
			// default constructor for Jackson
		}

		public ChangeShapeCommand(String componentId, String shapeId, AbstractUiMapShapeChange change) {
			this.componentId = componentId;
			this.shapeId = shapeId;
			this.change = change;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("shapeId=" + shapeId).append(", ")
					.append(change != null ? "change={" + change.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("shapeId")
		public String getShapeId() {
			return shapeId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("change")
		public AbstractUiMapShapeChange getChange() {
			return change;
		}

	}

	public static class RemoveShapeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String shapeId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveShapeCommand() {
			// default constructor for Jackson
		}

		public RemoveShapeCommand(String componentId, String shapeId) {
			this.componentId = componentId;
			this.shapeId = shapeId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("shapeId=" + shapeId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("shapeId")
		public String getShapeId() {
			return shapeId;
		}

	}

	public static class ClearShapesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ClearShapesCommand() {
			// default constructor for Jackson
		}

		public ClearShapesCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class StartDrawingShapeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMapShapeType shapeType;
		protected UiShapeProperties shapeProperties;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public StartDrawingShapeCommand() {
			// default constructor for Jackson
		}

		public StartDrawingShapeCommand(String componentId, UiMapShapeType shapeType, UiShapeProperties shapeProperties) {
			this.componentId = componentId;
			this.shapeType = shapeType;
			this.shapeProperties = shapeProperties;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("shapeType=" + shapeType).append(", ")
					.append(shapeProperties != null ? "shapeProperties={" + shapeProperties.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("shapeType")
		public UiMapShapeType getShapeType() {
			return shapeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("shapeProperties")
		public UiShapeProperties getShapeProperties() {
			return shapeProperties;
		}

	}

	public static class StopDrawingShapeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public StopDrawingShapeCommand() {
			// default constructor for Jackson
		}

		public StopDrawingShapeCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class SetZoomLevelCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected float zoom;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetZoomLevelCommand() {
			// default constructor for Jackson
		}

		public SetZoomLevelCommand(String componentId, float zoom) {
			this.componentId = componentId;
			this.zoom = zoom;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoom=" + zoom)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoom")
		public float getZoom() {
			return zoom;
		}

	}

	public static class SetLocationCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMapLocation location;
		protected long animationDurationMillis;
		protected float targetZoomLevel;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetLocationCommand() {
			// default constructor for Jackson
		}

		public SetLocationCommand(String componentId, UiMapLocation location, long animationDurationMillis, float targetZoomLevel) {
			this.componentId = componentId;
			this.location = location;
			this.animationDurationMillis = animationDurationMillis;
			this.targetZoomLevel = targetZoomLevel;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("animationDurationMillis=" + animationDurationMillis).append(", ")
					.append("targetZoomLevel=" + targetZoomLevel).append(", ")
					.append(location != null ? "location={" + location.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("location")
		public UiMapLocation getLocation() {
			return location;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("animationDurationMillis")
		public long getAnimationDurationMillis() {
			return animationDurationMillis;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("targetZoomLevel")
		public float getTargetZoomLevel() {
			return targetZoomLevel;
		}

	}

	public static class SetStyleUrlCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String styleUrl;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetStyleUrlCommand() {
			// default constructor for Jackson
		}

		public SetStyleUrlCommand(String componentId, String styleUrl) {
			this.componentId = componentId;
			this.styleUrl = styleUrl;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("styleUrl=" + styleUrl)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("styleUrl")
		public String getStyleUrl() {
			return styleUrl;
		}

	}

	public static class FitBoundsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMapLocation southWest;
		protected UiMapLocation northEast;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public FitBoundsCommand() {
			// default constructor for Jackson
		}

		public FitBoundsCommand(String componentId, UiMapLocation southWest, UiMapLocation northEast) {
			this.componentId = componentId;
			this.southWest = southWest;
			this.northEast = northEast;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(southWest != null ? "southWest={" + southWest.toString() + "}" : "").append(", ")
					.append(northEast != null ? "northEast={" + northEast.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("southWest")
		public UiMapLocation getSouthWest() {
			return southWest;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("northEast")
		public UiMapLocation getNorthEast() {
			return northEast;
		}

	}

}