/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.ObjectDeserializer;
import org.teamapps.dto.ObjectSerializer;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiFieldEditingMode;
import org.teamapps.dto.UiFieldMessage;
import org.teamapps.dto.UiObject;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class UiField
extends UiComponent
implements UiObject {
    protected UiFieldEditingMode editingMode = UiFieldEditingMode.EDITABLE;
    @JsonSerialize(using=ObjectSerializer.class)
    @JsonDeserialize(using=ObjectDeserializer.class)
    protected Object value;
    protected List<UiFieldMessage> fieldMessages;

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + ("editingMode=" + this.editingMode) + ", " + ("value=" + this.value) + ", " + (String)(this.fieldMessages != null ? "fieldMessages={" + this.fieldMessages.toString() + "}" : "");
    }

    @JsonGetter(value="editingMode")
    public UiFieldEditingMode getEditingMode() {
        return this.editingMode;
    }

    @JsonGetter(value="value")
    public Object getValue() {
        return this.value;
    }

    @JsonGetter(value="fieldMessages")
    public List<UiFieldMessage> getFieldMessages() {
        return this.fieldMessages;
    }

    @Override
    @JsonSetter(value="id")
    public UiField setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiField setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiField setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiField setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiField setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiField setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="editingMode")
    public UiField setEditingMode(UiFieldEditingMode editingMode) {
        this.editingMode = editingMode;
        return this;
    }

    @JsonSetter(value="value")
    public UiField setValue(Object value) {
        this.value = value;
        return this;
    }

    @JsonSetter(value="fieldMessages")
    public UiField setFieldMessages(List<UiFieldMessage> fieldMessages) {
        this.fieldMessages = fieldMessages;
        return this;
    }

    public static class SetFieldMessagesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<UiFieldMessage> fieldMessages;

        @Deprecated
        public SetFieldMessagesCommand() {
        }

        public SetFieldMessagesCommand(String componentId, List<UiFieldMessage> fieldMessages) {
            this.componentId = componentId;
            this.fieldMessages = fieldMessages;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.fieldMessages != null ? "fieldMessages={" + this.fieldMessages.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fieldMessages")
        public List<UiFieldMessage> getFieldMessages() {
            return this.fieldMessages;
        }
    }

    public static class FocusCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public FocusCommand() {
        }

        public FocusCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class SetValueCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        @JsonSerialize(using=ObjectSerializer.class)
        @JsonDeserialize(using=ObjectDeserializer.class)
        protected Object value;

        @Deprecated
        public SetValueCommand() {
        }

        public SetValueCommand(String componentId, Object value) {
            this.componentId = componentId;
            this.value = value;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("value=" + this.value);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="value")
        public Object getValue() {
            return this.value;
        }
    }

    public static class SetEditingModeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiFieldEditingMode editingMode;

        @Deprecated
        public SetEditingModeCommand() {
        }

        public SetEditingModeCommand(String componentId, UiFieldEditingMode editingMode) {
            this.componentId = componentId;
            this.editingMode = editingMode;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("editingMode=" + this.editingMode);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="editingMode")
        public UiFieldEditingMode getEditingMode() {
            return this.editingMode;
        }
    }

    public static class BlurEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public BlurEvent() {
        }

        public BlurEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_FIELD_BLUR;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class FocusEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public FocusEvent() {
        }

        public FocusEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_FIELD_FOCUS;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class ValueChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        @JsonSerialize(using=ObjectSerializer.class)
        @JsonDeserialize(using=ObjectDeserializer.class)
        protected Object value;

        @Deprecated
        public ValueChangedEvent() {
        }

        public ValueChangedEvent(String componentId, Object value) {
            this.componentId = componentId;
            this.value = value;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_FIELD_VALUE_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("value=" + this.value);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="value")
        public Object getValue() {
            return this.value;
        }
    }
}

