/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiFieldEditingMode;
import org.teamapps.dto.UiFieldMessage;
import org.teamapps.dto.UiFileFieldDisplayType;
import org.teamapps.dto.UiFileItem;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiSimpleFileField.class)
public class UiSimpleFileField
extends UiField
implements UiObject {
    protected String browseButtonIcon;
    protected String browseButtonCaption = "Select";
    protected String uploadUrl = "/upload";
    protected long maxBytesPerFile = 5000000L;
    protected String fileTooLargeMessage = "File too large!";
    protected String uploadErrorMessage = "Error while transmitting file...";
    protected int maxFiles = 0;
    protected UiFileFieldDisplayType displayMode = UiFileFieldDisplayType.LIST;
    protected List<UiFileItem> fileItems;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_SIMPLE_FILE_FIELD;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + ("editingMode=" + this.editingMode) + ", " + ("value=" + this.value) + ", " + ("browseButtonIcon=" + this.browseButtonIcon) + ", " + ("browseButtonCaption=" + this.browseButtonCaption) + ", " + ("uploadUrl=" + this.uploadUrl) + ", " + ("maxBytesPerFile=" + this.maxBytesPerFile) + ", " + ("fileTooLargeMessage=" + this.fileTooLargeMessage) + ", " + ("uploadErrorMessage=" + this.uploadErrorMessage) + ", " + ("maxFiles=" + this.maxFiles) + ", " + ("displayMode=" + this.displayMode) + ", " + (String)(this.fieldMessages != null ? "fieldMessages={" + this.fieldMessages.toString() + "}" : "") + ", " + (String)(this.fileItems != null ? "fileItems={" + this.fileItems.toString() + "}" : "");
    }

    @JsonGetter(value="browseButtonIcon")
    public String getBrowseButtonIcon() {
        return this.browseButtonIcon;
    }

    @JsonGetter(value="browseButtonCaption")
    public String getBrowseButtonCaption() {
        return this.browseButtonCaption;
    }

    @JsonGetter(value="uploadUrl")
    public String getUploadUrl() {
        return this.uploadUrl;
    }

    @JsonGetter(value="maxBytesPerFile")
    public long getMaxBytesPerFile() {
        return this.maxBytesPerFile;
    }

    @JsonGetter(value="fileTooLargeMessage")
    public String getFileTooLargeMessage() {
        return this.fileTooLargeMessage;
    }

    @JsonGetter(value="uploadErrorMessage")
    public String getUploadErrorMessage() {
        return this.uploadErrorMessage;
    }

    @JsonGetter(value="maxFiles")
    public int getMaxFiles() {
        return this.maxFiles;
    }

    @JsonGetter(value="displayMode")
    public UiFileFieldDisplayType getDisplayMode() {
        return this.displayMode;
    }

    @JsonGetter(value="fileItems")
    public List<UiFileItem> getFileItems() {
        return this.fileItems;
    }

    @Override
    @JsonSetter(value="id")
    public UiSimpleFileField setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiSimpleFileField setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiSimpleFileField setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiSimpleFileField setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiSimpleFileField setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiSimpleFileField setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="editingMode")
    public UiSimpleFileField setEditingMode(UiFieldEditingMode editingMode) {
        this.editingMode = editingMode;
        return this;
    }

    @Override
    @JsonSetter(value="value")
    public UiSimpleFileField setValue(Object value) {
        this.value = value;
        return this;
    }

    @Override
    @JsonSetter(value="fieldMessages")
    public UiSimpleFileField setFieldMessages(List<UiFieldMessage> fieldMessages) {
        this.fieldMessages = fieldMessages;
        return this;
    }

    @JsonSetter(value="browseButtonIcon")
    public UiSimpleFileField setBrowseButtonIcon(String browseButtonIcon) {
        this.browseButtonIcon = browseButtonIcon;
        return this;
    }

    @JsonSetter(value="browseButtonCaption")
    public UiSimpleFileField setBrowseButtonCaption(String browseButtonCaption) {
        this.browseButtonCaption = browseButtonCaption;
        return this;
    }

    @JsonSetter(value="uploadUrl")
    public UiSimpleFileField setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
        return this;
    }

    @JsonSetter(value="maxBytesPerFile")
    public UiSimpleFileField setMaxBytesPerFile(long maxBytesPerFile) {
        this.maxBytesPerFile = maxBytesPerFile;
        return this;
    }

    @JsonSetter(value="fileTooLargeMessage")
    public UiSimpleFileField setFileTooLargeMessage(String fileTooLargeMessage) {
        this.fileTooLargeMessage = fileTooLargeMessage;
        return this;
    }

    @JsonSetter(value="uploadErrorMessage")
    public UiSimpleFileField setUploadErrorMessage(String uploadErrorMessage) {
        this.uploadErrorMessage = uploadErrorMessage;
        return this;
    }

    @JsonSetter(value="maxFiles")
    public UiSimpleFileField setMaxFiles(int maxFiles) {
        this.maxFiles = maxFiles;
        return this;
    }

    @JsonSetter(value="displayMode")
    public UiSimpleFileField setDisplayMode(UiFileFieldDisplayType displayMode) {
        this.displayMode = displayMode;
        return this;
    }

    @JsonSetter(value="fileItems")
    public UiSimpleFileField setFileItems(List<UiFileItem> fileItems) {
        this.fileItems = fileItems;
        return this;
    }

    public static class SetDisplayModeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiFileFieldDisplayType displayType;

        @Deprecated
        public SetDisplayModeCommand() {
        }

        public SetDisplayModeCommand(String componentId, UiFileFieldDisplayType displayType) {
            this.componentId = componentId;
            this.displayType = displayType;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("displayType=" + this.displayType);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="displayType")
        public UiFileFieldDisplayType getDisplayType() {
            return this.displayType;
        }
    }

    public static class SetMaxFilesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int maxFiles;

        @Deprecated
        public SetMaxFilesCommand() {
        }

        public SetMaxFilesCommand(String componentId, int maxFiles) {
            this.componentId = componentId;
            this.maxFiles = maxFiles;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("maxFiles=" + this.maxFiles);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="maxFiles")
        public int getMaxFiles() {
            return this.maxFiles;
        }
    }

    public static class SetUploadErrorMessageCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String uploadErrorMessage;

        @Deprecated
        public SetUploadErrorMessageCommand() {
        }

        public SetUploadErrorMessageCommand(String componentId, String uploadErrorMessage) {
            this.componentId = componentId;
            this.uploadErrorMessage = uploadErrorMessage;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("uploadErrorMessage=" + this.uploadErrorMessage);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="uploadErrorMessage")
        public String getUploadErrorMessage() {
            return this.uploadErrorMessage;
        }
    }

    public static class SetFileTooLargeMessageCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String fileTooLargeMessage;

        @Deprecated
        public SetFileTooLargeMessageCommand() {
        }

        public SetFileTooLargeMessageCommand(String componentId, String fileTooLargeMessage) {
            this.componentId = componentId;
            this.fileTooLargeMessage = fileTooLargeMessage;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileTooLargeMessage=" + this.fileTooLargeMessage);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileTooLargeMessage")
        public String getFileTooLargeMessage() {
            return this.fileTooLargeMessage;
        }
    }

    public static class SetMaxBytesPerFileCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected long maxBytesPerFile;

        @Deprecated
        public SetMaxBytesPerFileCommand() {
        }

        public SetMaxBytesPerFileCommand(String componentId, long maxBytesPerFile) {
            this.componentId = componentId;
            this.maxBytesPerFile = maxBytesPerFile;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("maxBytesPerFile=" + this.maxBytesPerFile);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="maxBytesPerFile")
        public long getMaxBytesPerFile() {
            return this.maxBytesPerFile;
        }
    }

    public static class SetUploadUrlCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String uploadUrl;

        @Deprecated
        public SetUploadUrlCommand() {
        }

        public SetUploadUrlCommand(String componentId, String uploadUrl) {
            this.componentId = componentId;
            this.uploadUrl = uploadUrl;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("uploadUrl=" + this.uploadUrl);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="uploadUrl")
        public String getUploadUrl() {
            return this.uploadUrl;
        }
    }

    public static class SetBrowseButtonCaptionCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String browseButtonCaption;

        @Deprecated
        public SetBrowseButtonCaptionCommand() {
        }

        public SetBrowseButtonCaptionCommand(String componentId, String browseButtonCaption) {
            this.componentId = componentId;
            this.browseButtonCaption = browseButtonCaption;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("browseButtonCaption=" + this.browseButtonCaption);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="browseButtonCaption")
        public String getBrowseButtonCaption() {
            return this.browseButtonCaption;
        }
    }

    public static class SetBrowseButtonIconCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String browseButtonIcon;

        @Deprecated
        public SetBrowseButtonIconCommand() {
        }

        public SetBrowseButtonIconCommand(String componentId, String browseButtonIcon) {
            this.componentId = componentId;
            this.browseButtonIcon = browseButtonIcon;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("browseButtonIcon=" + this.browseButtonIcon);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="browseButtonIcon")
        public String getBrowseButtonIcon() {
            return this.browseButtonIcon;
        }
    }

    public static class RemoveFileItemCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String itemUuid;

        @Deprecated
        public RemoveFileItemCommand() {
        }

        public RemoveFileItemCommand(String componentId, String itemUuid) {
            this.componentId = componentId;
            this.itemUuid = itemUuid;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("itemUuid=" + this.itemUuid);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="itemUuid")
        public String getItemUuid() {
            return this.itemUuid;
        }
    }

    public static class UpdateFileItemCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiFileItem item;

        @Deprecated
        public UpdateFileItemCommand() {
        }

        public UpdateFileItemCommand(String componentId, UiFileItem item) {
            this.componentId = componentId;
            this.item = item;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.item != null ? "item={" + this.item.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="item")
        public UiFileItem getItem() {
            return this.item;
        }
    }

    public static class AddFileItemCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiFileItem item;

        @Deprecated
        public AddFileItemCommand() {
        }

        public AddFileItemCommand(String componentId, UiFileItem item) {
            this.componentId = componentId;
            this.item = item;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.item != null ? "item={" + this.item.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="item")
        public UiFileItem getItem() {
            return this.item;
        }
    }

    public static class FileItemRemovedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;

        @Deprecated
        public FileItemRemovedEvent() {
        }

        public FileItemRemovedEvent(String componentId, String fileItemUuid) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_SIMPLE_FILE_FIELD_FILE_ITEM_REMOVED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileItemUuid=" + this.fileItemUuid);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }
    }

    public static class FileItemClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;

        @Deprecated
        public FileItemClickedEvent() {
        }

        public FileItemClickedEvent(String componentId, String fileItemUuid) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_SIMPLE_FILE_FIELD_FILE_ITEM_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileItemUuid=" + this.fileItemUuid);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }
    }

    public static class UploadSuccessfulEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;
        protected String uploadedFileUuid;

        @Deprecated
        public UploadSuccessfulEvent() {
        }

        public UploadSuccessfulEvent(String componentId, String fileItemUuid, String uploadedFileUuid) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
            this.uploadedFileUuid = uploadedFileUuid;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_SIMPLE_FILE_FIELD_UPLOAD_SUCCESSFUL;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileItemUuid=" + this.fileItemUuid) + ", " + ("uploadedFileUuid=" + this.uploadedFileUuid);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }

        @JsonGetter(value="uploadedFileUuid")
        public String getUploadedFileUuid() {
            return this.uploadedFileUuid;
        }
    }

    public static class UploadFailedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;

        @Deprecated
        public UploadFailedEvent() {
        }

        public UploadFailedEvent(String componentId, String fileItemUuid) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_SIMPLE_FILE_FIELD_UPLOAD_FAILED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileItemUuid=" + this.fileItemUuid);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }
    }

    public static class UploadCanceledEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;

        @Deprecated
        public UploadCanceledEvent() {
        }

        public UploadCanceledEvent(String componentId, String fileItemUuid) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_SIMPLE_FILE_FIELD_UPLOAD_CANCELED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileItemUuid=" + this.fileItemUuid);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }
    }

    public static class UploadStartedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;

        @Deprecated
        public UploadStartedEvent() {
        }

        public UploadStartedEvent(String componentId, String fileItemUuid) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_SIMPLE_FILE_FIELD_UPLOAD_STARTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileItemUuid=" + this.fileItemUuid);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }
    }

    public static class UploadTooLargeEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;

        @Deprecated
        public UploadTooLargeEvent() {
        }

        public UploadTooLargeEvent(String componentId, String fileItemUuid) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_SIMPLE_FILE_FIELD_UPLOAD_TOO_LARGE;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileItemUuid=" + this.fileItemUuid);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }
    }

    public static class UploadInitiatedByUserEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String uuid;
        protected String fileName;
        protected String mimeType;
        protected long sizeInBytes;

        @Deprecated
        public UploadInitiatedByUserEvent() {
        }

        public UploadInitiatedByUserEvent(String componentId, String uuid, String fileName, String mimeType, long sizeInBytes) {
            this.componentId = componentId;
            this.uuid = uuid;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.sizeInBytes = sizeInBytes;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_SIMPLE_FILE_FIELD_UPLOAD_INITIATED_BY_USER;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileName=" + this.fileName) + ", " + ("uuid=" + this.uuid) + ", " + ("mimeType=" + this.mimeType) + ", " + ("sizeInBytes=" + this.sizeInBytes);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="uuid")
        public String getUuid() {
            return this.uuid;
        }

        @JsonGetter(value="fileName")
        public String getFileName() {
            return this.fileName;
        }

        @JsonGetter(value="mimeType")
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonGetter(value="sizeInBytes")
        public long getSizeInBytes() {
            return this.sizeInBytes;
        }
    }
}

