/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiToolButton.class)
public class UiToolButton
extends UiComponent
implements UiObject {
    protected String icon;
    protected String caption;
    protected String popoverText;
    protected boolean grayOutIfNotHovered = true;
    protected int minDropDownWidth = 450;
    protected int minDropDownHeight = 200;
    protected boolean openDropDownIfNotSet = false;
    protected UiClientObjectReference dropDownComponent;

    @Deprecated
    public UiToolButton() {
    }

    public UiToolButton(String icon, String popoverText) {
        this.icon = icon;
        this.popoverText = popoverText;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_TOOL_BUTTON;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + ("icon=" + this.icon) + ", " + ("caption=" + this.caption) + ", " + ("popoverText=" + this.popoverText) + ", " + ("grayOutIfNotHovered=" + this.grayOutIfNotHovered) + ", " + ("minDropDownWidth=" + this.minDropDownWidth) + ", " + ("minDropDownHeight=" + this.minDropDownHeight) + ", " + ("openDropDownIfNotSet=" + this.openDropDownIfNotSet) + ", " + (String)(this.dropDownComponent != null ? "dropDownComponent={" + this.dropDownComponent.toString() + "}" : "");
    }

    @JsonGetter(value="icon")
    public String getIcon() {
        return this.icon;
    }

    @JsonGetter(value="caption")
    public String getCaption() {
        return this.caption;
    }

    @JsonGetter(value="popoverText")
    public String getPopoverText() {
        return this.popoverText;
    }

    @JsonGetter(value="grayOutIfNotHovered")
    public boolean getGrayOutIfNotHovered() {
        return this.grayOutIfNotHovered;
    }

    @JsonGetter(value="minDropDownWidth")
    public int getMinDropDownWidth() {
        return this.minDropDownWidth;
    }

    @JsonGetter(value="minDropDownHeight")
    public int getMinDropDownHeight() {
        return this.minDropDownHeight;
    }

    @JsonGetter(value="openDropDownIfNotSet")
    public boolean getOpenDropDownIfNotSet() {
        return this.openDropDownIfNotSet;
    }

    @JsonGetter(value="dropDownComponent")
    public UiClientObjectReference getDropDownComponent() {
        return this.dropDownComponent;
    }

    @Override
    @JsonSetter(value="id")
    public UiToolButton setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiToolButton setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiToolButton setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiToolButton setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiToolButton setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiToolButton setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="caption")
    public UiToolButton setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    @JsonSetter(value="grayOutIfNotHovered")
    public UiToolButton setGrayOutIfNotHovered(boolean grayOutIfNotHovered) {
        this.grayOutIfNotHovered = grayOutIfNotHovered;
        return this;
    }

    @JsonSetter(value="minDropDownWidth")
    public UiToolButton setMinDropDownWidth(int minDropDownWidth) {
        this.minDropDownWidth = minDropDownWidth;
        return this;
    }

    @JsonSetter(value="minDropDownHeight")
    public UiToolButton setMinDropDownHeight(int minDropDownHeight) {
        this.minDropDownHeight = minDropDownHeight;
        return this;
    }

    @JsonSetter(value="openDropDownIfNotSet")
    public UiToolButton setOpenDropDownIfNotSet(boolean openDropDownIfNotSet) {
        this.openDropDownIfNotSet = openDropDownIfNotSet;
        return this;
    }

    @JsonSetter(value="dropDownComponent")
    public UiToolButton setDropDownComponent(UiClientObjectReference dropDownComponent) {
        this.dropDownComponent = dropDownComponent;
        return this;
    }

    public static class SetDropDownComponentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiClientObjectReference dropDownComponent;

        @Deprecated
        public SetDropDownComponentCommand() {
        }

        public SetDropDownComponentCommand(String componentId, UiClientObjectReference dropDownComponent) {
            this.componentId = componentId;
            this.dropDownComponent = dropDownComponent;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.dropDownComponent != null ? "dropDownComponent={" + this.dropDownComponent.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="dropDownComponent")
        public UiClientObjectReference getDropDownComponent() {
            return this.dropDownComponent;
        }
    }

    public static class SetOpenDropDownIfNotSetCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean openDropDownIfNotSet;

        @Deprecated
        public SetOpenDropDownIfNotSetCommand() {
        }

        public SetOpenDropDownIfNotSetCommand(String componentId, boolean openDropDownIfNotSet) {
            this.componentId = componentId;
            this.openDropDownIfNotSet = openDropDownIfNotSet;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("openDropDownIfNotSet=" + this.openDropDownIfNotSet);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="openDropDownIfNotSet")
        public boolean getOpenDropDownIfNotSet() {
            return this.openDropDownIfNotSet;
        }
    }

    public static class SetDropDownSizeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int minDropDownWidth;
        protected int minDropDownHeight;

        @Deprecated
        public SetDropDownSizeCommand() {
        }

        public SetDropDownSizeCommand(String componentId, int minDropDownWidth, int minDropDownHeight) {
            this.componentId = componentId;
            this.minDropDownWidth = minDropDownWidth;
            this.minDropDownHeight = minDropDownHeight;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("minDropDownWidth=" + this.minDropDownWidth) + ", " + ("minDropDownHeight=" + this.minDropDownHeight);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="minDropDownWidth")
        public int getMinDropDownWidth() {
            return this.minDropDownWidth;
        }

        @JsonGetter(value="minDropDownHeight")
        public int getMinDropDownHeight() {
            return this.minDropDownHeight;
        }
    }

    public static class SetGrayOutIfNotHoveredCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean grayOutIfNotHovered;

        @Deprecated
        public SetGrayOutIfNotHoveredCommand() {
        }

        public SetGrayOutIfNotHoveredCommand(String componentId, boolean grayOutIfNotHovered) {
            this.componentId = componentId;
            this.grayOutIfNotHovered = grayOutIfNotHovered;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("grayOutIfNotHovered=" + this.grayOutIfNotHovered);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="grayOutIfNotHovered")
        public boolean getGrayOutIfNotHovered() {
            return this.grayOutIfNotHovered;
        }
    }

    public static class SetPopoverTextCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String popoverText;

        @Deprecated
        public SetPopoverTextCommand() {
        }

        public SetPopoverTextCommand(String componentId, String popoverText) {
            this.componentId = componentId;
            this.popoverText = popoverText;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("popoverText=" + this.popoverText);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="popoverText")
        public String getPopoverText() {
            return this.popoverText;
        }
    }

    public static class SetIconCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String icon;

        @Deprecated
        public SetIconCommand() {
        }

        public SetIconCommand(String componentId, String icon) {
            this.componentId = componentId;
            this.icon = icon;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("icon=" + this.icon);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="icon")
        public String getIcon() {
            return this.icon;
        }
    }

    public static class DropDownOpenedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public DropDownOpenedEvent() {
        }

        public DropDownOpenedEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TOOL_BUTTON_DROP_DOWN_OPENED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class ClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public ClickedEvent() {
        }

        public ClickedEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TOOL_BUTTON_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }
}

