/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.KeyEventType;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiConfiguration;
import org.teamapps.dto.UiEntranceAnimation;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiExitAnimation;
import org.teamapps.dto.UiGenericErrorMessageOption;
import org.teamapps.dto.UiLocation;
import org.teamapps.dto.UiNotificationPosition;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiPageTransition;
import org.teamapps.dto.UiTemplate;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiRootPanel.class)
public class UiRootPanel
extends UiComponent
implements UiObject {
    protected UiClientObjectReference content;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_ROOT_PANEL;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + (String)(this.content != null ? "content={" + this.content.toString() + "}" : "");
    }

    @JsonGetter(value="content")
    public UiClientObjectReference getContent() {
        return this.content;
    }

    @Override
    @JsonSetter(value="id")
    public UiRootPanel setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiRootPanel setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiRootPanel setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiRootPanel setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiRootPanel setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiRootPanel setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="content")
    public UiRootPanel setContent(UiClientObjectReference content) {
        this.content = content;
        return this;
    }

    public static class SetTitleCommand
    implements UiCommand<Void> {
        protected String title;

        @Deprecated
        public SetTitleCommand() {
        }

        public SetTitleCommand(String title) {
            this.title = title;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("title=" + this.title);
        }

        @JsonGetter(value="title")
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetFaviconCommand
    implements UiCommand<Void> {
        protected String url;

        @Deprecated
        public SetFaviconCommand() {
        }

        public SetFaviconCommand(String url) {
            this.url = url;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("url=" + this.url);
        }

        @JsonGetter(value="url")
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class NavigateForwardCommand
    implements UiCommand<Void> {
        protected int steps;

        @Deprecated
        public NavigateForwardCommand() {
        }

        public NavigateForwardCommand(int steps) {
            this.steps = steps;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("steps=" + this.steps);
        }

        @JsonGetter(value="steps")
        public int getSteps() {
            return this.steps;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class ChangeNavigationHistoryStateCommand
    implements UiCommand<Void> {
        protected String pathOrUrl;
        protected boolean fireEvent;
        protected boolean push;

        @Deprecated
        public ChangeNavigationHistoryStateCommand() {
        }

        public ChangeNavigationHistoryStateCommand(String pathOrUrl, boolean fireEvent, boolean push) {
            this.pathOrUrl = pathOrUrl;
            this.fireEvent = fireEvent;
            this.push = push;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("pathOrUrl=" + this.pathOrUrl) + ", " + ("fireEvent=" + this.fireEvent) + ", " + ("push=" + this.push);
        }

        @JsonGetter(value="pathOrUrl")
        public String getPathOrUrl() {
            return this.pathOrUrl;
        }

        @JsonGetter(value="fireEvent")
        public boolean getFireEvent() {
            return this.fireEvent;
        }

        @JsonGetter(value="push")
        public boolean getPush() {
            return this.push;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class GoToUrlCommand
    implements UiCommand<Void> {
        protected String url;
        protected boolean blankPage;

        @Deprecated
        public GoToUrlCommand() {
        }

        public GoToUrlCommand(String url, boolean blankPage) {
            this.url = url;
            this.blankPage = blankPage;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("url=" + this.url) + ", " + ("blankPage=" + this.blankPage);
        }

        @JsonGetter(value="url")
        public String getUrl() {
            return this.url;
        }

        @JsonGetter(value="blankPage")
        public boolean getBlankPage() {
            return this.blankPage;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class ReleaseWakeLockCommand
    implements UiCommand<Void> {
        protected String uuid;

        @Deprecated
        public ReleaseWakeLockCommand() {
        }

        public ReleaseWakeLockCommand(String uuid) {
            this.uuid = uuid;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("uuid=" + this.uuid);
        }

        @JsonGetter(value="uuid")
        public String getUuid() {
            return this.uuid;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class RequestWakeLockCommand
    implements UiCommand<Boolean> {
        protected String uuid;

        @Deprecated
        public RequestWakeLockCommand() {
        }

        public RequestWakeLockCommand(String uuid) {
            this.uuid = uuid;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("uuid=" + this.uuid);
        }

        @JsonGetter(value="uuid")
        public String getUuid() {
            return this.uuid;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class ShowPopupAtCurrentMousePositionCommand
    implements UiCommand<Void> {
        protected UiClientObjectReference popup;

        @Deprecated
        public ShowPopupAtCurrentMousePositionCommand() {
        }

        public ShowPopupAtCurrentMousePositionCommand(UiClientObjectReference popup) {
            this.popup = popup;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + (String)(this.popup != null ? "popup={" + this.popup.toString() + "}" : "");
        }

        @JsonGetter(value="popup")
        public UiClientObjectReference getPopup() {
            return this.popup;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class ShowPopupCommand
    implements UiCommand<Void> {
        protected UiClientObjectReference popup;

        @Deprecated
        public ShowPopupCommand() {
        }

        public ShowPopupCommand(UiClientObjectReference popup) {
            this.popup = popup;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + (String)(this.popup != null ? "popup={" + this.popup.toString() + "}" : "");
        }

        @JsonGetter(value="popup")
        public UiClientObjectReference getPopup() {
            return this.popup;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class ShowDialogMessageCommand
    implements UiCommand<Void> {
        protected String icon;
        protected String title;
        protected String message;
        protected List<UiGenericErrorMessageOption> options;

        @Deprecated
        public ShowDialogMessageCommand() {
        }

        public ShowDialogMessageCommand(String icon, String title, String message, List<UiGenericErrorMessageOption> options) {
            this.icon = icon;
            this.title = title;
            this.message = message;
            this.options = options;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("icon=" + this.icon) + ", " + ("title=" + this.title) + ", " + ("message=" + this.message) + ", " + ("options=" + this.options);
        }

        @JsonGetter(value="icon")
        public String getIcon() {
            return this.icon;
        }

        @JsonGetter(value="title")
        public String getTitle() {
            return this.title;
        }

        @JsonGetter(value="message")
        public String getMessage() {
            return this.message;
        }

        @JsonGetter(value="options")
        public List<UiGenericErrorMessageOption> getOptions() {
            return this.options;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class ShowNotificationCommand
    implements UiCommand<Void> {
        protected UiClientObjectReference notification;
        protected UiNotificationPosition position;
        protected UiEntranceAnimation entranceAnimation;
        protected UiExitAnimation exitAnimation;

        @Deprecated
        public ShowNotificationCommand() {
        }

        public ShowNotificationCommand(UiClientObjectReference notification, UiNotificationPosition position, UiEntranceAnimation entranceAnimation, UiExitAnimation exitAnimation) {
            this.notification = notification;
            this.position = position;
            this.entranceAnimation = entranceAnimation;
            this.exitAnimation = exitAnimation;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("position=" + this.position) + ", " + ("entranceAnimation=" + this.entranceAnimation) + ", " + ("exitAnimation=" + this.exitAnimation) + ", " + (String)(this.notification != null ? "notification={" + this.notification.toString() + "}" : "");
        }

        @JsonGetter(value="notification")
        public UiClientObjectReference getNotification() {
            return this.notification;
        }

        @JsonGetter(value="position")
        public UiNotificationPosition getPosition() {
            return this.position;
        }

        @JsonGetter(value="entranceAnimation")
        public UiEntranceAnimation getEntranceAnimation() {
            return this.entranceAnimation;
        }

        @JsonGetter(value="exitAnimation")
        public UiExitAnimation getExitAnimation() {
            return this.exitAnimation;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class ExitFullScreenCommand
    implements UiCommand<Void> {
        public String toString() {
            return this.getClass().getSimpleName() + ": ";
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetBackgroundColorCommand
    implements UiCommand<Void> {
        protected String color;
        protected int animationDuration = 1000;

        @Deprecated
        public SetBackgroundColorCommand() {
        }

        public SetBackgroundColorCommand(String color, int animationDuration) {
            this.color = color;
            this.animationDuration = animationDuration;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("color=" + this.color) + ", " + ("animationDuration=" + this.animationDuration);
        }

        @JsonGetter(value="color")
        public String getColor() {
            return this.color;
        }

        @JsonGetter(value="animationDuration")
        public int getAnimationDuration() {
            return this.animationDuration;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetBackgroundImageCommand
    implements UiCommand<Void> {
        protected String id;
        protected int animationDuration = 1000;

        @Deprecated
        public SetBackgroundImageCommand() {
        }

        public SetBackgroundImageCommand(String id, int animationDuration) {
            this.id = id;
            this.animationDuration = animationDuration;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("animationDuration=" + this.animationDuration);
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JsonGetter(value="animationDuration")
        public int getAnimationDuration() {
            return this.animationDuration;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class RegisterBackgroundImageCommand
    implements UiCommand<Void> {
        protected String id;
        protected String image;
        protected String blurredImage;

        @Deprecated
        public RegisterBackgroundImageCommand() {
        }

        public RegisterBackgroundImageCommand(String id, String image, String blurredImage) {
            this.id = id;
            this.image = image;
            this.blurredImage = blurredImage;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("image=" + this.image) + ", " + ("blurredImage=" + this.blurredImage);
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JsonGetter(value="image")
        public String getImage() {
            return this.image;
        }

        @JsonGetter(value="blurredImage")
        public String getBlurredImage() {
            return this.blurredImage;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class DownloadFileCommand
    implements UiCommand<Void> {
        protected String fileUrl;
        protected String downloadFileName;

        @Deprecated
        public DownloadFileCommand() {
        }

        public DownloadFileCommand(String fileUrl, String downloadFileName) {
            this.fileUrl = fileUrl;
            this.downloadFileName = downloadFileName;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("downloadFileName=" + this.downloadFileName) + ", " + ("fileUrl=" + this.fileUrl);
        }

        @JsonGetter(value="fileUrl")
        public String getFileUrl() {
            return this.fileUrl;
        }

        @JsonGetter(value="downloadFileName")
        public String getDownloadFileName() {
            return this.downloadFileName;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class ClearClientTokensCommand
    implements UiCommand<Void> {
        public String toString() {
            return this.getClass().getSimpleName() + ": ";
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class RemoveClientTokenCommand
    implements UiCommand<Void> {
        protected String token;

        @Deprecated
        public RemoveClientTokenCommand() {
        }

        public RemoveClientTokenCommand(String token) {
            this.token = token;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("token=" + this.token);
        }

        @JsonGetter(value="token")
        public String getToken() {
            return this.token;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class AddClientTokenCommand
    implements UiCommand<Void> {
        protected String token;

        @Deprecated
        public AddClientTokenCommand() {
        }

        public AddClientTokenCommand(String token) {
            this.token = token;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("token=" + this.token);
        }

        @JsonGetter(value="token")
        public String getToken() {
            return this.token;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class RegisterTemplatesCommand
    implements UiCommand<Void> {
        protected Map<String, UiTemplate> templates;

        @Deprecated
        public RegisterTemplatesCommand() {
        }

        public RegisterTemplatesCommand(Map<String, UiTemplate> templates) {
            this.templates = templates;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + (String)(this.templates != null ? "templates={" + this.templates.toString() + "}" : "");
        }

        @JsonGetter(value="templates")
        public Map<String, UiTemplate> getTemplates() {
            return this.templates;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class RegisterTemplateCommand
    implements UiCommand<Void> {
        protected String id;
        protected UiTemplate template;

        @Deprecated
        public RegisterTemplateCommand() {
        }

        public RegisterTemplateCommand(String id, UiTemplate template) {
            this.id = id;
            this.template = template;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + (String)(this.template != null ? "template={" + this.template.toString() + "}" : "");
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JsonGetter(value="template")
        public UiTemplate getTemplate() {
            return this.template;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class BuildRootPanelCommand
    implements UiCommand<Void> {
        protected String containerElementId;
        protected UiClientObjectReference uiRootPanel;

        @Deprecated
        public BuildRootPanelCommand() {
        }

        public BuildRootPanelCommand(String containerElementId, UiClientObjectReference uiRootPanel) {
            this.containerElementId = containerElementId;
            this.uiRootPanel = uiRootPanel;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("containerElementId=" + this.containerElementId) + ", " + (String)(this.uiRootPanel != null ? "uiRootPanel={" + this.uiRootPanel.toString() + "}" : "");
        }

        @JsonGetter(value="containerElementId")
        public String getContainerElementId() {
            return this.containerElementId;
        }

        @JsonGetter(value="uiRootPanel")
        public UiClientObjectReference getUiRootPanel() {
            return this.uiRootPanel;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetPageTitleCommand
    implements UiCommand<Void> {
        protected String pageTitle;

        @Deprecated
        public SetPageTitleCommand() {
        }

        public SetPageTitleCommand(String pageTitle) {
            this.pageTitle = pageTitle;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("pageTitle=" + this.pageTitle);
        }

        @JsonGetter(value="pageTitle")
        public String getPageTitle() {
            return this.pageTitle;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetSessionMessageWindowsCommand
    implements UiCommand<Void> {
        protected UiClientObjectReference expiredMessageWindow;
        protected UiClientObjectReference errorMessageWindow;
        protected UiClientObjectReference terminatedMessageWindow;

        @Deprecated
        public SetSessionMessageWindowsCommand() {
        }

        public SetSessionMessageWindowsCommand(UiClientObjectReference expiredMessageWindow, UiClientObjectReference errorMessageWindow, UiClientObjectReference terminatedMessageWindow) {
            this.expiredMessageWindow = expiredMessageWindow;
            this.errorMessageWindow = errorMessageWindow;
            this.terminatedMessageWindow = terminatedMessageWindow;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + (String)(this.expiredMessageWindow != null ? "expiredMessageWindow={" + this.expiredMessageWindow.toString() + "}" : "") + ", " + (String)(this.errorMessageWindow != null ? "errorMessageWindow={" + this.errorMessageWindow.toString() + "}" : "") + ", " + (String)(this.terminatedMessageWindow != null ? "terminatedMessageWindow={" + this.terminatedMessageWindow.toString() + "}" : "");
        }

        @JsonGetter(value="expiredMessageWindow")
        public UiClientObjectReference getExpiredMessageWindow() {
            return this.expiredMessageWindow;
        }

        @JsonGetter(value="errorMessageWindow")
        public UiClientObjectReference getErrorMessageWindow() {
            return this.errorMessageWindow;
        }

        @JsonGetter(value="terminatedMessageWindow")
        public UiClientObjectReference getTerminatedMessageWindow() {
            return this.terminatedMessageWindow;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetThemeClassNameCommand
    implements UiCommand<Void> {
        protected String theme;

        @Deprecated
        public SetThemeClassNameCommand() {
        }

        public SetThemeClassNameCommand(String theme) {
            this.theme = theme;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("theme=" + this.theme);
        }

        @JsonGetter(value="theme")
        public String getTheme() {
            return this.theme;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetConfigCommand
    implements UiCommand<Void> {
        protected UiConfiguration config;

        @Deprecated
        public SetConfigCommand() {
        }

        public SetConfigCommand(UiConfiguration config) {
            this.config = config;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + (String)(this.config != null ? "config={" + this.config.toString() + "}" : "");
        }

        @JsonGetter(value="config")
        public UiConfiguration getConfig() {
            return this.config;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class RefreshComponentCommand
    implements UiCommand<Void> {
        protected UiComponent component;

        @Deprecated
        public RefreshComponentCommand() {
        }

        public RefreshComponentCommand(UiComponent component) {
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @JsonGetter(value="component")
        public UiComponent getComponent() {
            return this.component;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class DestroyComponentCommand
    implements UiCommand<Void> {
        protected String id;

        @Deprecated
        public DestroyComponentCommand() {
        }

        public DestroyComponentCommand(String id) {
            this.id = id;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id);
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class CreateComponentCommand
    implements UiCommand<Void> {
        protected UiComponent component;

        @Deprecated
        public CreateComponentCommand() {
        }

        public CreateComponentCommand(UiComponent component) {
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @JsonGetter(value="component")
        public UiComponent getComponent() {
            return this.component;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetGlobalKeyEventsEnabledCommand
    implements UiCommand<Void> {
        protected boolean unmodified;
        protected boolean modifiedWithAltKey;
        protected boolean modifiedWithCtrlKey;
        protected boolean modifiedWithMetaKey;
        protected boolean includeRepeats;
        protected boolean keyDown;
        protected boolean keyUp;

        @Deprecated
        public SetGlobalKeyEventsEnabledCommand() {
        }

        public SetGlobalKeyEventsEnabledCommand(boolean unmodified, boolean modifiedWithAltKey, boolean modifiedWithCtrlKey, boolean modifiedWithMetaKey, boolean includeRepeats, boolean keyDown, boolean keyUp) {
            this.unmodified = unmodified;
            this.modifiedWithAltKey = modifiedWithAltKey;
            this.modifiedWithCtrlKey = modifiedWithCtrlKey;
            this.modifiedWithMetaKey = modifiedWithMetaKey;
            this.includeRepeats = includeRepeats;
            this.keyDown = keyDown;
            this.keyUp = keyUp;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("unmodified=" + this.unmodified) + ", " + ("modifiedWithAltKey=" + this.modifiedWithAltKey) + ", " + ("modifiedWithCtrlKey=" + this.modifiedWithCtrlKey) + ", " + ("modifiedWithMetaKey=" + this.modifiedWithMetaKey) + ", " + ("includeRepeats=" + this.includeRepeats) + ", " + ("keyDown=" + this.keyDown) + ", " + ("keyUp=" + this.keyUp);
        }

        @JsonGetter(value="unmodified")
        public boolean getUnmodified() {
            return this.unmodified;
        }

        @JsonGetter(value="modifiedWithAltKey")
        public boolean getModifiedWithAltKey() {
            return this.modifiedWithAltKey;
        }

        @JsonGetter(value="modifiedWithCtrlKey")
        public boolean getModifiedWithCtrlKey() {
            return this.modifiedWithCtrlKey;
        }

        @JsonGetter(value="modifiedWithMetaKey")
        public boolean getModifiedWithMetaKey() {
            return this.modifiedWithMetaKey;
        }

        @JsonGetter(value="includeRepeats")
        public boolean getIncludeRepeats() {
            return this.includeRepeats;
        }

        @JsonGetter(value="keyDown")
        public boolean getKeyDown() {
            return this.keyDown;
        }

        @JsonGetter(value="keyUp")
        public boolean getKeyUp() {
            return this.keyUp;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetContentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiClientObjectReference content;
        protected UiPageTransition transition;
        protected long animationDuration;

        @Deprecated
        public SetContentCommand() {
        }

        public SetContentCommand(String componentId, UiClientObjectReference content, UiPageTransition transition, long animationDuration) {
            this.componentId = componentId;
            this.content = content;
            this.transition = transition;
            this.animationDuration = animationDuration;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("transition=" + this.transition) + ", " + ("animationDuration=" + this.animationDuration) + ", " + (String)(this.content != null ? "content={" + this.content.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="content")
        public UiClientObjectReference getContent() {
            return this.content;
        }

        @JsonGetter(value="transition")
        public UiPageTransition getTransition() {
            return this.transition;
        }

        @JsonGetter(value="animationDuration")
        public long getAnimationDuration() {
            return this.animationDuration;
        }
    }

    public static class NavigationStateChangeEvent
    implements UiEvent {
        protected UiLocation location;
        protected boolean triggeredBrowserNavigation;

        @Deprecated
        public NavigationStateChangeEvent() {
        }

        public NavigationStateChangeEvent(UiLocation location, boolean triggeredBrowserNavigation) {
            this.location = location;
            this.triggeredBrowserNavigation = triggeredBrowserNavigation;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_ROOT_PANEL_NAVIGATION_STATE_CHANGE;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("triggeredBrowserNavigation=" + this.triggeredBrowserNavigation) + ", " + (String)(this.location != null ? "location={" + this.location.toString() + "}" : "");
        }

        @JsonGetter(value="location")
        public UiLocation getLocation() {
            return this.location;
        }

        @JsonGetter(value="triggeredBrowserNavigation")
        public boolean getTriggeredBrowserNavigation() {
            return this.triggeredBrowserNavigation;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class GlobalKeyEventOccurredEvent
    implements UiEvent {
        protected KeyEventType eventType;
        protected String sourceComponentId;
        protected String code;
        protected boolean isComposing;
        protected String key;
        protected int charCode;
        protected int keyCode;
        protected String locale;
        protected int location;
        protected boolean repeat;
        protected boolean altKey;
        protected boolean ctrlKey;
        protected boolean shiftKey;
        protected boolean metaKey;

        @Deprecated
        public GlobalKeyEventOccurredEvent() {
        }

        public GlobalKeyEventOccurredEvent(KeyEventType eventType, String sourceComponentId, String code, boolean isComposing, String key, int charCode, int keyCode, String locale, int location, boolean repeat, boolean altKey, boolean ctrlKey, boolean shiftKey, boolean metaKey) {
            this.eventType = eventType;
            this.sourceComponentId = sourceComponentId;
            this.code = code;
            this.isComposing = isComposing;
            this.key = key;
            this.charCode = charCode;
            this.keyCode = keyCode;
            this.locale = locale;
            this.location = location;
            this.repeat = repeat;
            this.altKey = altKey;
            this.ctrlKey = ctrlKey;
            this.shiftKey = shiftKey;
            this.metaKey = metaKey;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_ROOT_PANEL_GLOBAL_KEY_EVENT_OCCURRED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("sourceComponentId=" + this.sourceComponentId) + ", " + ("eventType=" + this.eventType) + ", " + ("code=" + this.code) + ", " + ("isComposing=" + this.isComposing) + ", " + ("key=" + this.key) + ", " + ("charCode=" + this.charCode) + ", " + ("keyCode=" + this.keyCode) + ", " + ("locale=" + this.locale) + ", " + ("location=" + this.location) + ", " + ("repeat=" + this.repeat) + ", " + ("altKey=" + this.altKey) + ", " + ("ctrlKey=" + this.ctrlKey) + ", " + ("shiftKey=" + this.shiftKey) + ", " + ("metaKey=" + this.metaKey);
        }

        @JsonGetter(value="eventType")
        public KeyEventType getEventType() {
            return this.eventType;
        }

        @JsonGetter(value="sourceComponentId")
        public String getSourceComponentId() {
            return this.sourceComponentId;
        }

        @JsonGetter(value="code")
        public String getCode() {
            return this.code;
        }

        @JsonGetter(value="isComposing")
        public boolean getIsComposing() {
            return this.isComposing;
        }

        @JsonGetter(value="key")
        public String getKey() {
            return this.key;
        }

        @JsonGetter(value="charCode")
        public int getCharCode() {
            return this.charCode;
        }

        @JsonGetter(value="keyCode")
        public int getKeyCode() {
            return this.keyCode;
        }

        @JsonGetter(value="locale")
        public String getLocale() {
            return this.locale;
        }

        @JsonGetter(value="location")
        public int getLocation() {
            return this.location;
        }

        @JsonGetter(value="repeat")
        public boolean getRepeat() {
            return this.repeat;
        }

        @JsonGetter(value="altKey")
        public boolean getAltKey() {
            return this.altKey;
        }

        @JsonGetter(value="ctrlKey")
        public boolean getCtrlKey() {
            return this.ctrlKey;
        }

        @JsonGetter(value="shiftKey")
        public boolean getShiftKey() {
            return this.shiftKey;
        }

        @JsonGetter(value="metaKey")
        public boolean getMetaKey() {
            return this.metaKey;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }
}

