package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type", defaultImpl = UiTimeGraph.class)
public class UiTimeGraph extends UiComponent implements UiObject {


	protected UiLineChartYScaleZoomMode yScaleZoomMode = UiLineChartYScaleZoomMode.DYNAMIC_INCLUDING_ZERO;
	protected UiLongInterval intervalX;
	protected List<UiTimeChartZoomLevel> zoomLevels;
	protected int maxPixelsBetweenDataPoints;
	protected List<UiGraph> graphs;
	protected UiScaleType yScaleType = UiScaleType.LINEAR;
	protected UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode = UiLineChartMouseScrollZoomPanMode.ENABLED;
	protected String locale;
	protected String timeZoneId = null;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiTimeGraph() {
		// default constructor for Jackson
	}

	public UiTimeGraph(UiLongInterval intervalX, List<UiTimeChartZoomLevel> zoomLevels, int maxPixelsBetweenDataPoints, List<UiGraph> graphs) {
		super();
		this.intervalX = intervalX;
		this.zoomLevels = zoomLevels;
		this.maxPixelsBetweenDataPoints = maxPixelsBetweenDataPoints;
		this.graphs = graphs;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TIME_GRAPH;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("timeZoneId=" + timeZoneId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("yScaleZoomMode=" + yScaleZoomMode).append(", ")
				.append("maxPixelsBetweenDataPoints=" + maxPixelsBetweenDataPoints).append(", ")
				.append(graphs != null ? "graphs={" + graphs.toString() + "}" : "").append(", ")
				.append("yScaleType=" + yScaleType).append(", ")
				.append("mouseScrollZoomPanMode=" + mouseScrollZoomPanMode).append(", ")
				.append("locale=" + locale).append(", ")
				.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "").append(", ")
				.append(zoomLevels != null ? "zoomLevels={" + zoomLevels.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("yScaleZoomMode")
	public UiLineChartYScaleZoomMode getYScaleZoomMode() {
		return yScaleZoomMode;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
	public UiLongInterval getIntervalX() {
		return intervalX;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("zoomLevels")
	public List<UiTimeChartZoomLevel> getZoomLevels() {
		return zoomLevels;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxPixelsBetweenDataPoints")
	public int getMaxPixelsBetweenDataPoints() {
		return maxPixelsBetweenDataPoints;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("graphs")
	public List<UiGraph> getGraphs() {
		return graphs;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("yScaleType")
	public UiScaleType getYScaleType() {
		return yScaleType;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("mouseScrollZoomPanMode")
	public UiLineChartMouseScrollZoomPanMode getMouseScrollZoomPanMode() {
		return mouseScrollZoomPanMode;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("locale")
	public String getLocale() {
		return locale;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("timeZoneId")
	public String getTimeZoneId() {
		return timeZoneId;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiTimeGraph setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiTimeGraph setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiTimeGraph setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiTimeGraph setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiTimeGraph setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiTimeGraph setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("yScaleZoomMode")
	public UiTimeGraph setYScaleZoomMode(UiLineChartYScaleZoomMode yScaleZoomMode) {
		this.yScaleZoomMode = yScaleZoomMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("yScaleType")
	public UiTimeGraph setYScaleType(UiScaleType yScaleType) {
		this.yScaleType = yScaleType;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("mouseScrollZoomPanMode")
	public UiTimeGraph setMouseScrollZoomPanMode(UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode) {
		this.mouseScrollZoomPanMode = mouseScrollZoomPanMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("locale")
	public UiTimeGraph setLocale(String locale) {
		this.locale = locale;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("timeZoneId")
	public UiTimeGraph setTimeZoneId(String timeZoneId) {
		this.timeZoneId = timeZoneId;
		return this;
	}

	public static class ZoomedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiLongInterval displayedInterval;
		protected int zoomLevelIndex;
		protected double millisecondsPerPixel;
		protected Map<String, List<UiLongInterval>> neededIntervalsByGraphId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ZoomedEvent() {
			// default constructor for Jackson
		}

		public ZoomedEvent(String componentId, UiLongInterval displayedInterval, int zoomLevelIndex, double millisecondsPerPixel, Map<String, List<UiLongInterval>> neededIntervalsByGraphId) {
			this.componentId = componentId;
			this.displayedInterval = displayedInterval;
			this.zoomLevelIndex = zoomLevelIndex;
			this.millisecondsPerPixel = millisecondsPerPixel;
			this.neededIntervalsByGraphId = neededIntervalsByGraphId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TIME_GRAPH_ZOOMED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(neededIntervalsByGraphId != null ? "neededIntervalsByGraphId={" + neededIntervalsByGraphId.toString() + "}" : "").append(", ")
					.append("zoomLevelIndex=" + zoomLevelIndex).append(", ")
					.append("millisecondsPerPixel=" + millisecondsPerPixel).append(", ")
					.append(displayedInterval != null ? "displayedInterval={" + displayedInterval.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("displayedInterval")
		public UiLongInterval getDisplayedInterval() {
			return displayedInterval;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomLevelIndex")
		public int getZoomLevelIndex() {
			return zoomLevelIndex;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("millisecondsPerPixel")
		public double getMillisecondsPerPixel() {
			return millisecondsPerPixel;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("neededIntervalsByGraphId")
		public Map<String, List<UiLongInterval>> getNeededIntervalsByGraphId() {
			return neededIntervalsByGraphId;
		}

	}

	public static class IntervalSelectedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiLongInterval intervalX;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public IntervalSelectedEvent() {
			// default constructor for Jackson
		}

		public IntervalSelectedEvent(String componentId, UiLongInterval intervalX) {
			this.componentId = componentId;
			this.intervalX = intervalX;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TIME_GRAPH_INTERVAL_SELECTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

	}


	public static class SetIntervalXCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiLongInterval intervalX;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetIntervalXCommand() {
			// default constructor for Jackson
		}

		public SetIntervalXCommand(String componentId, UiLongInterval intervalX) {
			this.componentId = componentId;
			this.intervalX = intervalX;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

	}

	public static class SetMaxPixelsBetweenDataPointsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int maxPixelsBetweenDataPoints;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMaxPixelsBetweenDataPointsCommand() {
			// default constructor for Jackson
		}

		public SetMaxPixelsBetweenDataPointsCommand(String componentId, int maxPixelsBetweenDataPoints) {
			this.componentId = componentId;
			this.maxPixelsBetweenDataPoints = maxPixelsBetweenDataPoints;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("maxPixelsBetweenDataPoints=" + maxPixelsBetweenDataPoints)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("maxPixelsBetweenDataPoints")
		public int getMaxPixelsBetweenDataPoints() {
			return maxPixelsBetweenDataPoints;
		}

	}

	public static class AddDataCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int zoomLevel;
		protected Map<String, UiGraphData> data;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddDataCommand() {
			// default constructor for Jackson
		}

		public AddDataCommand(String componentId, int zoomLevel, Map<String, UiGraphData> data) {
			this.componentId = componentId;
			this.zoomLevel = zoomLevel;
			this.data = data;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoomLevel=" + zoomLevel).append(", ")
					.append(data != null ? "data={" + data.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomLevel")
		public int getZoomLevel() {
			return zoomLevel;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("data")
		public Map<String, UiGraphData> getData() {
			return data;
		}

	}

	public static class ResetGraphDataCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String graphId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ResetGraphDataCommand() {
			// default constructor for Jackson
		}

		public ResetGraphDataCommand(String componentId, String graphId) {
			this.componentId = componentId;
			this.graphId = graphId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("graphId=" + graphId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("graphId")
		public String getGraphId() {
			return graphId;
		}

	}

	public static class ResetAllDataCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiLongInterval intervalX;
		protected List<UiTimeChartZoomLevel> newZoomLevels;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ResetAllDataCommand() {
			// default constructor for Jackson
		}

		public ResetAllDataCommand(String componentId, UiLongInterval intervalX, List<UiTimeChartZoomLevel> newZoomLevels) {
			this.componentId = componentId;
			this.intervalX = intervalX;
			this.newZoomLevels = newZoomLevels;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "").append(", ")
					.append(newZoomLevels != null ? "newZoomLevels={" + newZoomLevels.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("newZoomLevels")
		public List<UiTimeChartZoomLevel> getNewZoomLevels() {
			return newZoomLevels;
		}

	}

	public static class SetMouseScrollZoomPanModeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMouseScrollZoomPanModeCommand() {
			// default constructor for Jackson
		}

		public SetMouseScrollZoomPanModeCommand(String componentId, UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode) {
			this.componentId = componentId;
			this.mouseScrollZoomPanMode = mouseScrollZoomPanMode;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("mouseScrollZoomPanMode=" + mouseScrollZoomPanMode)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mouseScrollZoomPanMode")
		public UiLineChartMouseScrollZoomPanMode getMouseScrollZoomPanMode() {
			return mouseScrollZoomPanMode;
		}

	}

	public static class SetSelectedIntervalCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiLongInterval intervalX;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetSelectedIntervalCommand() {
			// default constructor for Jackson
		}

		public SetSelectedIntervalCommand(String componentId, UiLongInterval intervalX) {
			this.componentId = componentId;
			this.intervalX = intervalX;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

	}

	public static class SetGraphsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiGraph> graphs;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetGraphsCommand() {
			// default constructor for Jackson
		}

		public SetGraphsCommand(String componentId, List<UiGraph> graphs) {
			this.componentId = componentId;
			this.graphs = graphs;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(graphs != null ? "graphs={" + graphs.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("graphs")
		public List<UiGraph> getGraphs() {
			return graphs;
		}

	}

	public static class AddOrUpdateGraphCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiGraph graph;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddOrUpdateGraphCommand() {
			// default constructor for Jackson
		}

		public AddOrUpdateGraphCommand(String componentId, UiGraph graph) {
			this.componentId = componentId;
			this.graph = graph;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(graph != null ? "graph={" + graph.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("graph")
		public UiGraph getGraph() {
			return graph;
		}

	}

	public static class ZoomToCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiLongInterval intervalX;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ZoomToCommand() {
			// default constructor for Jackson
		}

		public ZoomToCommand(String componentId, UiLongInterval intervalX) {
			this.componentId = componentId;
			this.intervalX = intervalX;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

	}

}