package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type", defaultImpl = UiShakaPlayer.class)
public class UiShakaPlayer extends UiComponent implements UiObject {


	protected String hlsUrl;
	protected String dashUrl;
	protected String posterImageUrl;
	protected UiPosterImageSize posterImageSize = UiPosterImageSize.CONTAIN;
	protected int timeUpdateEventThrottleMillis;
	protected String backgroundColor;
	protected boolean autoplay;
	protected UiTrackLabelFormat trackLabelFormat;
	protected boolean videoDisabled;
	protected long timeMillis;
	protected String preferredAudioLanguage;
	protected boolean bigPlayButtonEnabled;
	protected int controlFadeDelaySeconds;

	public UiShakaPlayer() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_SHAKA_PLAYER;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("hlsUrl=" + hlsUrl).append(", ")
				.append("dashUrl=" + dashUrl).append(", ")
				.append("posterImageUrl=" + posterImageUrl).append(", ")
				.append("posterImageSize=" + posterImageSize).append(", ")
				.append("timeUpdateEventThrottleMillis=" + timeUpdateEventThrottleMillis).append(", ")
				.append("backgroundColor=" + backgroundColor).append(", ")
				.append("autoplay=" + autoplay).append(", ")
				.append("trackLabelFormat=" + trackLabelFormat).append(", ")
				.append("videoDisabled=" + videoDisabled).append(", ")
				.append("timeMillis=" + timeMillis).append(", ")
				.append("preferredAudioLanguage=" + preferredAudioLanguage).append(", ")
				.append("bigPlayButtonEnabled=" + bigPlayButtonEnabled).append(", ")
				.append("controlFadeDelaySeconds=" + controlFadeDelaySeconds)
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("hlsUrl")
	public String getHlsUrl() {
		return hlsUrl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("dashUrl")
	public String getDashUrl() {
		return dashUrl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("posterImageUrl")
	public String getPosterImageUrl() {
		return posterImageUrl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("posterImageSize")
	public UiPosterImageSize getPosterImageSize() {
		return posterImageSize;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("timeUpdateEventThrottleMillis")
	public int getTimeUpdateEventThrottleMillis() {
		return timeUpdateEventThrottleMillis;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public String getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("autoplay")
	public boolean getAutoplay() {
		return autoplay;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("trackLabelFormat")
	public UiTrackLabelFormat getTrackLabelFormat() {
		return trackLabelFormat;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("videoDisabled")
	public boolean getVideoDisabled() {
		return videoDisabled;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("timeMillis")
	public long getTimeMillis() {
		return timeMillis;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("preferredAudioLanguage")
	public String getPreferredAudioLanguage() {
		return preferredAudioLanguage;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("bigPlayButtonEnabled")
	public boolean getBigPlayButtonEnabled() {
		return bigPlayButtonEnabled;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("controlFadeDelaySeconds")
	public int getControlFadeDelaySeconds() {
		return controlFadeDelaySeconds;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiShakaPlayer setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiShakaPlayer setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiShakaPlayer setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiShakaPlayer setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiShakaPlayer setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiShakaPlayer setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("hlsUrl")
	public UiShakaPlayer setHlsUrl(String hlsUrl) {
		this.hlsUrl = hlsUrl;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("dashUrl")
	public UiShakaPlayer setDashUrl(String dashUrl) {
		this.dashUrl = dashUrl;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("posterImageUrl")
	public UiShakaPlayer setPosterImageUrl(String posterImageUrl) {
		this.posterImageUrl = posterImageUrl;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("posterImageSize")
	public UiShakaPlayer setPosterImageSize(UiPosterImageSize posterImageSize) {
		this.posterImageSize = posterImageSize;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("timeUpdateEventThrottleMillis")
	public UiShakaPlayer setTimeUpdateEventThrottleMillis(int timeUpdateEventThrottleMillis) {
		this.timeUpdateEventThrottleMillis = timeUpdateEventThrottleMillis;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiShakaPlayer setBackgroundColor(String backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("autoplay")
	public UiShakaPlayer setAutoplay(boolean autoplay) {
		this.autoplay = autoplay;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("trackLabelFormat")
	public UiShakaPlayer setTrackLabelFormat(UiTrackLabelFormat trackLabelFormat) {
		this.trackLabelFormat = trackLabelFormat;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("videoDisabled")
	public UiShakaPlayer setVideoDisabled(boolean videoDisabled) {
		this.videoDisabled = videoDisabled;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("timeMillis")
	public UiShakaPlayer setTimeMillis(long timeMillis) {
		this.timeMillis = timeMillis;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("preferredAudioLanguage")
	public UiShakaPlayer setPreferredAudioLanguage(String preferredAudioLanguage) {
		this.preferredAudioLanguage = preferredAudioLanguage;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("bigPlayButtonEnabled")
	public UiShakaPlayer setBigPlayButtonEnabled(boolean bigPlayButtonEnabled) {
		this.bigPlayButtonEnabled = bigPlayButtonEnabled;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("controlFadeDelaySeconds")
	public UiShakaPlayer setControlFadeDelaySeconds(int controlFadeDelaySeconds) {
		this.controlFadeDelaySeconds = controlFadeDelaySeconds;
		return this;
	}

	public static class ErrorLoadingEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ErrorLoadingEvent() {
			// default constructor for Jackson
		}

		public ErrorLoadingEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_SHAKA_PLAYER_ERROR_LOADING;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class ManifestLoadedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiShakaManifest manifest;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ManifestLoadedEvent() {
			// default constructor for Jackson
		}

		public ManifestLoadedEvent(String componentId, UiShakaManifest manifest) {
			this.componentId = componentId;
			this.manifest = manifest;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_SHAKA_PLAYER_MANIFEST_LOADED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(manifest != null ? "manifest={" + manifest.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("manifest")
		public UiShakaManifest getManifest() {
			return manifest;
		}

	}

	public static class TimeUpdateEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected long timeMillis;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public TimeUpdateEvent() {
			// default constructor for Jackson
		}

		public TimeUpdateEvent(String componentId, long timeMillis) {
			this.componentId = componentId;
			this.timeMillis = timeMillis;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_SHAKA_PLAYER_TIME_UPDATE;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("timeMillis=" + timeMillis)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("timeMillis")
		public long getTimeMillis() {
			return timeMillis;
		}

	}

	public static class EndedEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public EndedEvent() {
			// default constructor for Jackson
		}

		public EndedEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_SHAKA_PLAYER_ENDED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}


	public static class SetUrlsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String hlsUrl;
		protected String dashUrl;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetUrlsCommand() {
			// default constructor for Jackson
		}

		public SetUrlsCommand(String componentId, String hlsUrl, String dashUrl) {
			this.componentId = componentId;
			this.hlsUrl = hlsUrl;
			this.dashUrl = dashUrl;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("hlsUrl=" + hlsUrl).append(", ")
					.append("dashUrl=" + dashUrl)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("hlsUrl")
		public String getHlsUrl() {
			return hlsUrl;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("dashUrl")
		public String getDashUrl() {
			return dashUrl;
		}

	}

	public static class SetTimeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected long timeMillis;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetTimeCommand() {
			// default constructor for Jackson
		}

		public SetTimeCommand(String componentId, long timeMillis) {
			this.componentId = componentId;
			this.timeMillis = timeMillis;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("timeMillis=" + timeMillis)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("timeMillis")
		public long getTimeMillis() {
			return timeMillis;
		}

	}

	public static class SelectAudioLanguageCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String language;
		protected String role;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SelectAudioLanguageCommand() {
			// default constructor for Jackson
		}

		public SelectAudioLanguageCommand(String componentId, String language, String role) {
			this.componentId = componentId;
			this.language = language;
			this.role = role;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("language=" + language).append(", ")
					.append("role=" + role)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("language")
		public String getLanguage() {
			return language;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("role")
		public String getRole() {
			return role;
		}

	}

	public static class SetDistinctManifestAudioTracksFixEnabledCommand implements UiCommand<Void> {

		protected boolean enabled;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetDistinctManifestAudioTracksFixEnabledCommand() {
			// default constructor for Jackson
		}

		public SetDistinctManifestAudioTracksFixEnabledCommand(boolean enabled) {
			this.enabled = enabled;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("enabled=" + enabled)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("enabled")
		public boolean getEnabled() {
			return enabled;
		}

		public String getComponentId() {
			return null;
		}

	}

}