/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.teamapps.dto.UiObjectJacksonTypeIdMaps;

public class TeamAppsJacksonTypeIdResolver
implements TypeIdResolver {
    private static final Map<String, JavaType> JAVA_TYPE_BY_ID = new ConcurrentHashMap<String, JavaType>();
    private static final Map<Class, String> ID_BY_CLASS = new ConcurrentHashMap<Class, String>();

    public TeamAppsJacksonTypeIdResolver() {
        UiObjectJacksonTypeIdMaps.CLASS_BY_ID.forEach((typeId, clazz) -> TeamAppsJacksonTypeIdResolver.registerPojoClass(clazz, typeId));
    }

    public static String registerPojoClass(Class clazz) {
        return TeamAppsJacksonTypeIdResolver.registerPojoClass(clazz, clazz.getCanonicalName());
    }

    private static String registerPojoClass(Class clazz, String typeId) {
        ID_BY_CLASS.put(clazz, typeId);
        JAVA_TYPE_BY_ID.put(typeId, TypeFactory.defaultInstance().constructType((Type)clazz));
        return typeId;
    }

    public void init(JavaType baseType) {
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public String idFromClass(Class clazz) {
        return this.idFromValueAndType(null, clazz);
    }

    public String idFromValue(Object obj) {
        return this.idFromValueAndType(obj, obj.getClass());
    }

    public String idFromValueAndType(Object obj, Class<?> clazz) {
        String id = ID_BY_CLASS.get(clazz);
        if (id != null) {
            return id;
        }
        return TeamAppsJacksonTypeIdResolver.registerPojoClass(clazz);
    }

    public String idFromBaseType() {
        return "java.util.Map";
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        JavaType javaType = JAVA_TYPE_BY_ID.get(id);
        if (javaType == null) {
            throw new IllegalArgumentException("Unregistered type id: " + id + ". Pojo types must be registered in order to be deserialized. Use registerPojoClass().");
        }
        return javaType;
    }

    public String getDescForKnownTypeIds() {
        return "Known ids/types: \n" + JAVA_TYPE_BY_ID.entrySet().stream().map(e -> (String)e.getKey() + ": " + ((JavaType)e.getValue()).getTypeName()).collect(Collectors.joining(",\n"));
    }
}

