/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiComponentReference;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiFormLayoutPolicy;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiGridForm
extends UiComponent
implements UiObject {
    protected List<UiComponentReference> fields;
    protected List<UiFormLayoutPolicy> layoutPolicies;

    @Deprecated
    public UiGridForm() {
    }

    public UiGridForm(List<UiComponentReference> fields, List<UiFormLayoutPolicy> layoutPolicies) {
        this.fields = fields;
        this.layoutPolicies = layoutPolicies;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_GRID_FORM;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + (String)(this.fields != null ? "fields={" + this.fields.toString() + "}" : "") + ", " + (String)(this.layoutPolicies != null ? "layoutPolicies={" + this.layoutPolicies.toString() + "}" : "");
    }

    @JsonGetter(value="fields")
    public List<UiComponentReference> getFields() {
        return this.fields;
    }

    @JsonGetter(value="layoutPolicies")
    public List<UiFormLayoutPolicy> getLayoutPolicies() {
        return this.layoutPolicies;
    }

    @Override
    @JsonSetter(value="id")
    public UiGridForm setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiGridForm setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiGridForm setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    public static class AddOrReplaceFieldCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiComponentReference field;

        @Deprecated
        public AddOrReplaceFieldCommand() {
        }

        public AddOrReplaceFieldCommand(String componentId, UiComponentReference field) {
            this.componentId = componentId;
            this.field = field;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.field != null ? "field={" + this.field.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="field")
        public UiComponentReference getField() {
            return this.field;
        }
    }

    public static class SetSectionCollapsedCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String sectionId;
        protected boolean collapsed;

        @Deprecated
        public SetSectionCollapsedCommand() {
        }

        public SetSectionCollapsedCommand(String componentId, String sectionId, boolean collapsed) {
            this.componentId = componentId;
            this.sectionId = sectionId;
            this.collapsed = collapsed;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("sectionId=" + this.sectionId) + ", " + ("collapsed=" + this.collapsed);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="sectionId")
        public String getSectionId() {
            return this.sectionId;
        }

        @JsonGetter(value="collapsed")
        public boolean getCollapsed() {
            return this.collapsed;
        }
    }

    public static class UpdateLayoutPoliciesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<UiFormLayoutPolicy> layoutPolicies;

        @Deprecated
        public UpdateLayoutPoliciesCommand() {
        }

        public UpdateLayoutPoliciesCommand(String componentId, List<UiFormLayoutPolicy> layoutPolicies) {
            this.componentId = componentId;
            this.layoutPolicies = layoutPolicies;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.layoutPolicies != null ? "layoutPolicies={" + this.layoutPolicies.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="layoutPolicies")
        public List<UiFormLayoutPolicy> getLayoutPolicies() {
            return this.layoutPolicies;
        }
    }

    public static class SectionCollapsedStateChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String sectionId;
        protected boolean collapsed;

        @Deprecated
        public SectionCollapsedStateChangedEvent() {
        }

        public SectionCollapsedStateChangedEvent(String componentId, String sectionId, boolean collapsed) {
            this.componentId = componentId;
            this.sectionId = sectionId;
            this.collapsed = collapsed;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_GRID_FORM_SECTION_COLLAPSED_STATE_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("sectionId=" + this.sectionId) + ", " + ("collapsed=" + this.collapsed);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="sectionId")
        public String getSectionId() {
            return this.sectionId;
        }

        @JsonGetter(value="collapsed")
        public boolean getCollapsed() {
            return this.collapsed;
        }
    }
}

