/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiDropDownButtonClickInfo;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiToolbarButton;
import org.teamapps.dto.UiToolbarButtonGroup;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class AbstractUiToolContainer
extends UiComponent
implements UiObject {
    protected List<UiToolbarButtonGroup> leftButtonGroups;
    protected List<UiToolbarButtonGroup> rightButtonGroups;
    protected String backgroundColor = "rgba(255, 255, 255, 0.84)";

    @Deprecated
    public AbstractUiToolContainer() {
    }

    public AbstractUiToolContainer(List<UiToolbarButtonGroup> leftButtonGroups, List<UiToolbarButtonGroup> rightButtonGroups) {
        this.leftButtonGroups = leftButtonGroups;
        this.rightButtonGroups = rightButtonGroups;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + ("backgroundColor=" + this.backgroundColor) + ", " + (String)(this.leftButtonGroups != null ? "leftButtonGroups={" + this.leftButtonGroups.toString() + "}" : "") + ", " + (String)(this.rightButtonGroups != null ? "rightButtonGroups={" + this.rightButtonGroups.toString() + "}" : "");
    }

    @JsonGetter(value="leftButtonGroups")
    public List<UiToolbarButtonGroup> getLeftButtonGroups() {
        return this.leftButtonGroups;
    }

    @JsonGetter(value="rightButtonGroups")
    public List<UiToolbarButtonGroup> getRightButtonGroups() {
        return this.rightButtonGroups;
    }

    @JsonGetter(value="backgroundColor")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    @JsonSetter(value="id")
    public AbstractUiToolContainer setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public AbstractUiToolContainer setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public AbstractUiToolContainer setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public AbstractUiToolContainer setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public AbstractUiToolContainer setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public AbstractUiToolContainer setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public AbstractUiToolContainer setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public static class CloseDropDownCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String groupId;
        protected String buttonId;

        @Deprecated
        public CloseDropDownCommand() {
        }

        public CloseDropDownCommand(String componentId, String groupId, String buttonId) {
            this.componentId = componentId;
            this.groupId = groupId;
            this.buttonId = buttonId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("groupId=" + this.groupId) + ", " + ("buttonId=" + this.buttonId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="groupId")
        public String getGroupId() {
            return this.groupId;
        }

        @JsonGetter(value="buttonId")
        public String getButtonId() {
            return this.buttonId;
        }
    }

    public static class SetDropDownComponentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String groupId;
        protected String buttonId;
        protected UiClientObjectReference component;

        @Deprecated
        public SetDropDownComponentCommand() {
        }

        public SetDropDownComponentCommand(String componentId, String groupId, String buttonId, UiClientObjectReference component) {
            this.componentId = componentId;
            this.groupId = groupId;
            this.buttonId = buttonId;
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("groupId=" + this.groupId) + ", " + ("buttonId=" + this.buttonId) + ", " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="groupId")
        public String getGroupId() {
            return this.groupId;
        }

        @JsonGetter(value="buttonId")
        public String getButtonId() {
            return this.buttonId;
        }

        @JsonGetter(value="component")
        public UiClientObjectReference getComponent() {
            return this.component;
        }
    }

    public static class SetButtonHasDropDownCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String groupId;
        protected String buttonId;
        protected boolean hasDropDown;

        @Deprecated
        public SetButtonHasDropDownCommand() {
        }

        public SetButtonHasDropDownCommand(String componentId, String groupId, String buttonId, boolean hasDropDown) {
            this.componentId = componentId;
            this.groupId = groupId;
            this.buttonId = buttonId;
            this.hasDropDown = hasDropDown;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("groupId=" + this.groupId) + ", " + ("buttonId=" + this.buttonId) + ", " + ("hasDropDown=" + this.hasDropDown);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="groupId")
        public String getGroupId() {
            return this.groupId;
        }

        @JsonGetter(value="buttonId")
        public String getButtonId() {
            return this.buttonId;
        }

        @JsonGetter(value="hasDropDown")
        public boolean getHasDropDown() {
            return this.hasDropDown;
        }
    }

    public static class RemoveButtonGroupCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String groupId;

        @Deprecated
        public RemoveButtonGroupCommand() {
        }

        public RemoveButtonGroupCommand(String componentId, String groupId) {
            this.componentId = componentId;
            this.groupId = groupId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("groupId=" + this.groupId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="groupId")
        public String getGroupId() {
            return this.groupId;
        }
    }

    public static class AddButtonGroupCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiToolbarButtonGroup group;
        protected boolean rightSide;

        @Deprecated
        public AddButtonGroupCommand() {
        }

        public AddButtonGroupCommand(String componentId, UiToolbarButtonGroup group, boolean rightSide) {
            this.componentId = componentId;
            this.group = group;
            this.rightSide = rightSide;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("rightSide=" + this.rightSide) + ", " + (String)(this.group != null ? "group={" + this.group.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="group")
        public UiToolbarButtonGroup getGroup() {
            return this.group;
        }

        @JsonGetter(value="rightSide")
        public boolean getRightSide() {
            return this.rightSide;
        }
    }

    public static class RemoveButtonCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String groupId;
        protected String buttonId;

        @Deprecated
        public RemoveButtonCommand() {
        }

        public RemoveButtonCommand(String componentId, String groupId, String buttonId) {
            this.componentId = componentId;
            this.groupId = groupId;
            this.buttonId = buttonId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("groupId=" + this.groupId) + ", " + ("buttonId=" + this.buttonId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="groupId")
        public String getGroupId() {
            return this.groupId;
        }

        @JsonGetter(value="buttonId")
        public String getButtonId() {
            return this.buttonId;
        }
    }

    public static class AddButtonCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String groupId;
        protected UiToolbarButton button;
        protected String neighborButtonId;
        protected boolean beforeNeighbor;

        @Deprecated
        public AddButtonCommand() {
        }

        public AddButtonCommand(String componentId, String groupId, UiToolbarButton button, String neighborButtonId, boolean beforeNeighbor) {
            this.componentId = componentId;
            this.groupId = groupId;
            this.button = button;
            this.neighborButtonId = neighborButtonId;
            this.beforeNeighbor = beforeNeighbor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("groupId=" + this.groupId) + ", " + ("neighborButtonId=" + this.neighborButtonId) + ", " + ("beforeNeighbor=" + this.beforeNeighbor) + ", " + (String)(this.button != null ? "button={" + this.button.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="groupId")
        public String getGroupId() {
            return this.groupId;
        }

        @JsonGetter(value="button")
        public UiToolbarButton getButton() {
            return this.button;
        }

        @JsonGetter(value="neighborButtonId")
        public String getNeighborButtonId() {
            return this.neighborButtonId;
        }

        @JsonGetter(value="beforeNeighbor")
        public boolean getBeforeNeighbor() {
            return this.beforeNeighbor;
        }
    }

    public static class SetButtonGroupVisibleCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String groupId;
        protected boolean visible;

        @Deprecated
        public SetButtonGroupVisibleCommand() {
        }

        public SetButtonGroupVisibleCommand(String componentId, String groupId, boolean visible) {
            this.componentId = componentId;
            this.groupId = groupId;
            this.visible = visible;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("groupId=" + this.groupId) + ", " + ("visible=" + this.visible);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="groupId")
        public String getGroupId() {
            return this.groupId;
        }

        @JsonGetter(value="visible")
        public boolean getVisible() {
            return this.visible;
        }
    }

    public static class SetButtonColorsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String groupId;
        protected String buttonId;
        protected String backgroundColor;
        protected String hoverBackgroundColor;

        @Deprecated
        public SetButtonColorsCommand() {
        }

        public SetButtonColorsCommand(String componentId, String groupId, String buttonId, String backgroundColor, String hoverBackgroundColor) {
            this.componentId = componentId;
            this.groupId = groupId;
            this.buttonId = buttonId;
            this.backgroundColor = backgroundColor;
            this.hoverBackgroundColor = hoverBackgroundColor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("groupId=" + this.groupId) + ", " + ("buttonId=" + this.buttonId) + ", " + ("backgroundColor=" + this.backgroundColor) + ", " + ("hoverBackgroundColor=" + this.hoverBackgroundColor);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="groupId")
        public String getGroupId() {
            return this.groupId;
        }

        @JsonGetter(value="buttonId")
        public String getButtonId() {
            return this.buttonId;
        }

        @JsonGetter(value="backgroundColor")
        public String getBackgroundColor() {
            return this.backgroundColor;
        }

        @JsonGetter(value="hoverBackgroundColor")
        public String getHoverBackgroundColor() {
            return this.hoverBackgroundColor;
        }
    }

    public static class SetButtonVisibleCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String groupId;
        protected String buttonId;
        protected boolean visible;

        @Deprecated
        public SetButtonVisibleCommand() {
        }

        public SetButtonVisibleCommand(String componentId, String groupId, String buttonId, boolean visible) {
            this.componentId = componentId;
            this.groupId = groupId;
            this.buttonId = buttonId;
            this.visible = visible;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("groupId=" + this.groupId) + ", " + ("buttonId=" + this.buttonId) + ", " + ("visible=" + this.visible);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="groupId")
        public String getGroupId() {
            return this.groupId;
        }

        @JsonGetter(value="buttonId")
        public String getButtonId() {
            return this.buttonId;
        }

        @JsonGetter(value="visible")
        public boolean getVisible() {
            return this.visible;
        }
    }

    public static class ToolbarButtonClickEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String groupId;
        protected String buttonId;
        protected UiDropDownButtonClickInfo dropDownClickInfo;

        @Deprecated
        public ToolbarButtonClickEvent() {
        }

        public ToolbarButtonClickEvent(String componentId, String groupId, String buttonId, UiDropDownButtonClickInfo dropDownClickInfo) {
            this.componentId = componentId;
            this.groupId = groupId;
            this.buttonId = buttonId;
            this.dropDownClickInfo = dropDownClickInfo;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.ABSTRACT_UI_TOOL_CONTAINER_TOOLBAR_BUTTON_CLICK;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("groupId=" + this.groupId) + ", " + ("buttonId=" + this.buttonId) + ", " + (String)(this.dropDownClickInfo != null ? "dropDownClickInfo={" + this.dropDownClickInfo.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="groupId")
        public String getGroupId() {
            return this.groupId;
        }

        @JsonGetter(value="buttonId")
        public String getButtonId() {
            return this.buttonId;
        }

        @JsonGetter(value="dropDownClickInfo")
        public UiDropDownButtonClickInfo getDropDownClickInfo() {
            return this.dropDownClickInfo;
        }
    }
}

