package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type", defaultImpl = UiRootPanel.class)
public class UiRootPanel extends UiComponent implements UiObject {


	protected UiClientObjectReference content;

	public UiRootPanel() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_ROOT_PANEL;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append(content != null ? "content={" + content.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("content")
	public UiClientObjectReference getContent() {
		return content;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiRootPanel setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiRootPanel setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiRootPanel setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiRootPanel setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiRootPanel setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiRootPanel setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("content")
	public UiRootPanel setContent(UiClientObjectReference content) {
		this.content = content;
		return this;
	}

	public static class GlobalKeyEventOccurredEvent implements UiEvent {

		protected KeyEventType eventType;
		protected String sourceComponentId;
		protected String code;
		protected boolean isComposing;
		protected String key;
		protected int charCode;
		protected int keyCode;
		protected String locale;
		protected int location;
		protected boolean repeat;
		protected boolean altKey;
		protected boolean ctrlKey;
		protected boolean shiftKey;
		protected boolean metaKey;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public GlobalKeyEventOccurredEvent() {
			// default constructor for Jackson
		}

		public GlobalKeyEventOccurredEvent(KeyEventType eventType, String sourceComponentId, String code, boolean isComposing, String key, int charCode, int keyCode, String locale, int location, boolean repeat, boolean altKey, boolean ctrlKey, boolean shiftKey, boolean metaKey) {
			this.eventType = eventType;
			this.sourceComponentId = sourceComponentId;
			this.code = code;
			this.isComposing = isComposing;
			this.key = key;
			this.charCode = charCode;
			this.keyCode = keyCode;
			this.locale = locale;
			this.location = location;
			this.repeat = repeat;
			this.altKey = altKey;
			this.ctrlKey = ctrlKey;
			this.shiftKey = shiftKey;
			this.metaKey = metaKey;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_ROOT_PANEL_GLOBAL_KEY_EVENT_OCCURRED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("sourceComponentId=" + sourceComponentId).append(", ")
					.append("eventType=" + eventType).append(", ")
					.append("code=" + code).append(", ")
					.append("isComposing=" + isComposing).append(", ")
					.append("key=" + key).append(", ")
					.append("charCode=" + charCode).append(", ")
					.append("keyCode=" + keyCode).append(", ")
					.append("locale=" + locale).append(", ")
					.append("location=" + location).append(", ")
					.append("repeat=" + repeat).append(", ")
					.append("altKey=" + altKey).append(", ")
					.append("ctrlKey=" + ctrlKey).append(", ")
					.append("shiftKey=" + shiftKey).append(", ")
					.append("metaKey=" + metaKey)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("eventType")
		public KeyEventType getEventType() {
			return eventType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sourceComponentId")
		public String getSourceComponentId() {
			return sourceComponentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("code")
		public String getCode() {
			return code;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("isComposing")
		public boolean getIsComposing() {
			return isComposing;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("key")
		public String getKey() {
			return key;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("charCode")
		public int getCharCode() {
			return charCode;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("keyCode")
		public int getKeyCode() {
			return keyCode;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("locale")
		public String getLocale() {
			return locale;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("location")
		public int getLocation() {
			return location;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("repeat")
		public boolean getRepeat() {
			return repeat;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("altKey")
		public boolean getAltKey() {
			return altKey;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("ctrlKey")
		public boolean getCtrlKey() {
			return ctrlKey;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("shiftKey")
		public boolean getShiftKey() {
			return shiftKey;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("metaKey")
		public boolean getMetaKey() {
			return metaKey;
		}

	    public String getComponentId() {
	        return null;
	    }

	}

	public static class NavigationStateChangeEvent implements UiEvent {

		protected UiLocation location;
		protected boolean triggeredBrowserNavigation;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public NavigationStateChangeEvent() {
			// default constructor for Jackson
		}

		public NavigationStateChangeEvent(UiLocation location, boolean triggeredBrowserNavigation) {
			this.location = location;
			this.triggeredBrowserNavigation = triggeredBrowserNavigation;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_ROOT_PANEL_NAVIGATION_STATE_CHANGE;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("triggeredBrowserNavigation=" + triggeredBrowserNavigation).append(", ")
					.append(location != null ? "location={" + location.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("location")
		public UiLocation getLocation() {
			return location;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("triggeredBrowserNavigation")
		public boolean getTriggeredBrowserNavigation() {
			return triggeredBrowserNavigation;
		}

	    public String getComponentId() {
	        return null;
	    }

	}


	public static class SetContentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiClientObjectReference content;
		protected UiPageTransition transition;
		protected long animationDuration;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetContentCommand() {
			// default constructor for Jackson
		}

		public SetContentCommand(String componentId, UiClientObjectReference content, UiPageTransition transition, long animationDuration) {
			this.componentId = componentId;
			this.content = content;
			this.transition = transition;
			this.animationDuration = animationDuration;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("transition=" + transition).append(", ")
					.append("animationDuration=" + animationDuration).append(", ")
					.append(content != null ? "content={" + content.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("content")
		public UiClientObjectReference getContent() {
			return content;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("transition")
		public UiPageTransition getTransition() {
			return transition;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("animationDuration")
		public long getAnimationDuration() {
			return animationDuration;
		}

	}

	public static class SetGlobalKeyEventsEnabledCommand implements UiCommand<Void> {

		protected boolean unmodified;
		protected boolean modifiedWithAltKey;
		protected boolean modifiedWithCtrlKey;
		protected boolean modifiedWithMetaKey;
		protected boolean includeRepeats;
		protected boolean keyDown;
		protected boolean keyUp;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetGlobalKeyEventsEnabledCommand() {
			// default constructor for Jackson
		}

		public SetGlobalKeyEventsEnabledCommand(boolean unmodified, boolean modifiedWithAltKey, boolean modifiedWithCtrlKey, boolean modifiedWithMetaKey, boolean includeRepeats, boolean keyDown, boolean keyUp) {
			this.unmodified = unmodified;
			this.modifiedWithAltKey = modifiedWithAltKey;
			this.modifiedWithCtrlKey = modifiedWithCtrlKey;
			this.modifiedWithMetaKey = modifiedWithMetaKey;
			this.includeRepeats = includeRepeats;
			this.keyDown = keyDown;
			this.keyUp = keyUp;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("unmodified=" + unmodified).append(", ")
					.append("modifiedWithAltKey=" + modifiedWithAltKey).append(", ")
					.append("modifiedWithCtrlKey=" + modifiedWithCtrlKey).append(", ")
					.append("modifiedWithMetaKey=" + modifiedWithMetaKey).append(", ")
					.append("includeRepeats=" + includeRepeats).append(", ")
					.append("keyDown=" + keyDown).append(", ")
					.append("keyUp=" + keyUp)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("unmodified")
		public boolean getUnmodified() {
			return unmodified;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("modifiedWithAltKey")
		public boolean getModifiedWithAltKey() {
			return modifiedWithAltKey;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("modifiedWithCtrlKey")
		public boolean getModifiedWithCtrlKey() {
			return modifiedWithCtrlKey;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("modifiedWithMetaKey")
		public boolean getModifiedWithMetaKey() {
			return modifiedWithMetaKey;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("includeRepeats")
		public boolean getIncludeRepeats() {
			return includeRepeats;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("keyDown")
		public boolean getKeyDown() {
			return keyDown;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("keyUp")
		public boolean getKeyUp() {
			return keyUp;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class CreateComponentCommand implements UiCommand<Void> {

		protected UiComponent component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CreateComponentCommand() {
			// default constructor for Jackson
		}

		public CreateComponentCommand(UiComponent component) {
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiComponent getComponent() {
			return component;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class DestroyComponentCommand implements UiCommand<Void> {

		protected String id;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public DestroyComponentCommand() {
			// default constructor for Jackson
		}

		public DestroyComponentCommand(String id) {
			this.id = id;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("id=" + id)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("id")
		public String getId() {
			return id;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class RefreshComponentCommand implements UiCommand<Void> {

		protected UiComponent component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RefreshComponentCommand() {
			// default constructor for Jackson
		}

		public RefreshComponentCommand(UiComponent component) {
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiComponent getComponent() {
			return component;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class SetConfigCommand implements UiCommand<Void> {

		protected UiConfiguration config;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetConfigCommand() {
			// default constructor for Jackson
		}

		public SetConfigCommand(UiConfiguration config) {
			this.config = config;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append(config != null ? "config={" + config.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("config")
		public UiConfiguration getConfig() {
			return config;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class SetThemeClassNameCommand implements UiCommand<Void> {

		protected String theme;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetThemeClassNameCommand() {
			// default constructor for Jackson
		}

		public SetThemeClassNameCommand(String theme) {
			this.theme = theme;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("theme=" + theme)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("theme")
		public String getTheme() {
			return theme;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class SetSessionMessageWindowsCommand implements UiCommand<Void> {

		protected UiClientObjectReference expiredMessageWindow;
		protected UiClientObjectReference errorMessageWindow;
		protected UiClientObjectReference terminatedMessageWindow;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetSessionMessageWindowsCommand() {
			// default constructor for Jackson
		}

		public SetSessionMessageWindowsCommand(UiClientObjectReference expiredMessageWindow, UiClientObjectReference errorMessageWindow, UiClientObjectReference terminatedMessageWindow) {
			this.expiredMessageWindow = expiredMessageWindow;
			this.errorMessageWindow = errorMessageWindow;
			this.terminatedMessageWindow = terminatedMessageWindow;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append(expiredMessageWindow != null ? "expiredMessageWindow={" + expiredMessageWindow.toString() + "}" : "").append(", ")
					.append(errorMessageWindow != null ? "errorMessageWindow={" + errorMessageWindow.toString() + "}" : "").append(", ")
					.append(terminatedMessageWindow != null ? "terminatedMessageWindow={" + terminatedMessageWindow.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("expiredMessageWindow")
		public UiClientObjectReference getExpiredMessageWindow() {
			return expiredMessageWindow;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("errorMessageWindow")
		public UiClientObjectReference getErrorMessageWindow() {
			return errorMessageWindow;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("terminatedMessageWindow")
		public UiClientObjectReference getTerminatedMessageWindow() {
			return terminatedMessageWindow;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class SetPageTitleCommand implements UiCommand<Void> {

		protected String pageTitle;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetPageTitleCommand() {
			// default constructor for Jackson
		}

		public SetPageTitleCommand(String pageTitle) {
			this.pageTitle = pageTitle;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("pageTitle=" + pageTitle)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("pageTitle")
		public String getPageTitle() {
			return pageTitle;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class BuildRootPanelCommand implements UiCommand<Void> {

		protected String containerElementId;
		protected UiClientObjectReference uiRootPanel;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public BuildRootPanelCommand() {
			// default constructor for Jackson
		}

		public BuildRootPanelCommand(String containerElementId, UiClientObjectReference uiRootPanel) {
			this.containerElementId = containerElementId;
			this.uiRootPanel = uiRootPanel;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("containerElementId=" + containerElementId).append(", ")
					.append(uiRootPanel != null ? "uiRootPanel={" + uiRootPanel.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("containerElementId")
		public String getContainerElementId() {
			return containerElementId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uiRootPanel")
		public UiClientObjectReference getUiRootPanel() {
			return uiRootPanel;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class RegisterTemplateCommand implements UiCommand<Void> {

		protected String id;
		protected UiTemplate template;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RegisterTemplateCommand() {
			// default constructor for Jackson
		}

		public RegisterTemplateCommand(String id, UiTemplate template) {
			this.id = id;
			this.template = template;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("id=" + id).append(", ")
					.append(template != null ? "template={" + template.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("id")
		public String getId() {
			return id;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("template")
		public UiTemplate getTemplate() {
			return template;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class RegisterTemplatesCommand implements UiCommand<Void> {

		protected Map<String, UiTemplate> templates;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RegisterTemplatesCommand() {
			// default constructor for Jackson
		}

		public RegisterTemplatesCommand(Map<String, UiTemplate> templates) {
			this.templates = templates;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append(templates != null ? "templates={" + templates.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("templates")
		public Map<String, UiTemplate> getTemplates() {
			return templates;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class AddClientTokenCommand implements UiCommand<Void> {

		protected String token;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddClientTokenCommand() {
			// default constructor for Jackson
		}

		public AddClientTokenCommand(String token) {
			this.token = token;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("token=" + token)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("token")
		public String getToken() {
			return token;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class RemoveClientTokenCommand implements UiCommand<Void> {

		protected String token;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveClientTokenCommand() {
			// default constructor for Jackson
		}

		public RemoveClientTokenCommand(String token) {
			this.token = token;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("token=" + token)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("token")
		public String getToken() {
			return token;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class ClearClientTokensCommand implements UiCommand<Void> {


		public ClearClientTokensCommand() {
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.toString();
		}


		public String getComponentId() {
			return null;
		}

	}

	public static class DownloadFileCommand implements UiCommand<Void> {

		protected String fileUrl;
		protected String downloadFileName;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public DownloadFileCommand() {
			// default constructor for Jackson
		}

		public DownloadFileCommand(String fileUrl, String downloadFileName) {
			this.fileUrl = fileUrl;
			this.downloadFileName = downloadFileName;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("downloadFileName=" + downloadFileName).append(", ")
					.append("fileUrl=" + fileUrl)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileUrl")
		public String getFileUrl() {
			return fileUrl;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("downloadFileName")
		public String getDownloadFileName() {
			return downloadFileName;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class RegisterBackgroundImageCommand implements UiCommand<Void> {

		protected String id;
		protected String image;
		protected String blurredImage;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RegisterBackgroundImageCommand() {
			// default constructor for Jackson
		}

		public RegisterBackgroundImageCommand(String id, String image, String blurredImage) {
			this.id = id;
			this.image = image;
			this.blurredImage = blurredImage;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("id=" + id).append(", ")
					.append("image=" + image).append(", ")
					.append("blurredImage=" + blurredImage)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("id")
		public String getId() {
			return id;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("image")
		public String getImage() {
			return image;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("blurredImage")
		public String getBlurredImage() {
			return blurredImage;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class SetBackgroundImageCommand implements UiCommand<Void> {

		protected String id;
		protected int animationDuration = 1000;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBackgroundImageCommand() {
			// default constructor for Jackson
		}

		public SetBackgroundImageCommand(String id, int animationDuration) {
			this.id = id;
			this.animationDuration = animationDuration;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("id=" + id).append(", ")
					.append("animationDuration=" + animationDuration)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("id")
		public String getId() {
			return id;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("animationDuration")
		public int getAnimationDuration() {
			return animationDuration;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class SetBackgroundColorCommand implements UiCommand<Void> {

		protected String color;
		protected int animationDuration = 1000;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBackgroundColorCommand() {
			// default constructor for Jackson
		}

		public SetBackgroundColorCommand(String color, int animationDuration) {
			this.color = color;
			this.animationDuration = animationDuration;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("color=" + color).append(", ")
					.append("animationDuration=" + animationDuration)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("color")
		public String getColor() {
			return color;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("animationDuration")
		public int getAnimationDuration() {
			return animationDuration;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class ExitFullScreenCommand implements UiCommand<Void> {


		public ExitFullScreenCommand() {
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.toString();
		}


		public String getComponentId() {
			return null;
		}

	}

	public static class ShowNotificationCommand implements UiCommand<Void> {

		protected UiClientObjectReference notification;
		protected UiNotificationPosition position;
		protected UiEntranceAnimation entranceAnimation;
		protected UiExitAnimation exitAnimation;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ShowNotificationCommand() {
			// default constructor for Jackson
		}

		public ShowNotificationCommand(UiClientObjectReference notification, UiNotificationPosition position, UiEntranceAnimation entranceAnimation, UiExitAnimation exitAnimation) {
			this.notification = notification;
			this.position = position;
			this.entranceAnimation = entranceAnimation;
			this.exitAnimation = exitAnimation;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("position=" + position).append(", ")
					.append("entranceAnimation=" + entranceAnimation).append(", ")
					.append("exitAnimation=" + exitAnimation).append(", ")
					.append(notification != null ? "notification={" + notification.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("notification")
		public UiClientObjectReference getNotification() {
			return notification;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("position")
		public UiNotificationPosition getPosition() {
			return position;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("entranceAnimation")
		public UiEntranceAnimation getEntranceAnimation() {
			return entranceAnimation;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("exitAnimation")
		public UiExitAnimation getExitAnimation() {
			return exitAnimation;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class ShowDialogMessageCommand implements UiCommand<Void> {

		protected String icon;
		protected String title;
		protected String message;
		protected List<UiGenericErrorMessageOption> options;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ShowDialogMessageCommand() {
			// default constructor for Jackson
		}

		public ShowDialogMessageCommand(String icon, String title, String message, List<UiGenericErrorMessageOption> options) {
			this.icon = icon;
			this.title = title;
			this.message = message;
			this.options = options;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("icon=" + icon).append(", ")
					.append("title=" + title).append(", ")
					.append("message=" + message).append(", ")
					.append("options=" + options)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("icon")
		public String getIcon() {
			return icon;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("title")
		public String getTitle() {
			return title;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("message")
		public String getMessage() {
			return message;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("options")
		public List<UiGenericErrorMessageOption> getOptions() {
			return options;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class ShowPopupCommand implements UiCommand<Void> {

		protected UiClientObjectReference popup;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ShowPopupCommand() {
			// default constructor for Jackson
		}

		public ShowPopupCommand(UiClientObjectReference popup) {
			this.popup = popup;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append(popup != null ? "popup={" + popup.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("popup")
		public UiClientObjectReference getPopup() {
			return popup;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class ShowPopupAtCurrentMousePositionCommand implements UiCommand<Void> {

		protected UiClientObjectReference popup;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ShowPopupAtCurrentMousePositionCommand() {
			// default constructor for Jackson
		}

		public ShowPopupAtCurrentMousePositionCommand(UiClientObjectReference popup) {
			this.popup = popup;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append(popup != null ? "popup={" + popup.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("popup")
		public UiClientObjectReference getPopup() {
			return popup;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class RequestWakeLockCommand implements UiCommand<Boolean> {

		protected String uuid;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RequestWakeLockCommand() {
			// default constructor for Jackson
		}

		public RequestWakeLockCommand(String uuid) {
			this.uuid = uuid;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("uuid=" + uuid)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uuid")
		public String getUuid() {
			return uuid;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class ReleaseWakeLockCommand implements UiCommand<Void> {

		protected String uuid;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ReleaseWakeLockCommand() {
			// default constructor for Jackson
		}

		public ReleaseWakeLockCommand(String uuid) {
			this.uuid = uuid;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("uuid=" + uuid)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uuid")
		public String getUuid() {
			return uuid;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class GoToUrlCommand implements UiCommand<Void> {

		protected String url;
		protected boolean blankPage;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public GoToUrlCommand() {
			// default constructor for Jackson
		}

		public GoToUrlCommand(String url, boolean blankPage) {
			this.url = url;
			this.blankPage = blankPage;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("url=" + url).append(", ")
					.append("blankPage=" + blankPage)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("url")
		public String getUrl() {
			return url;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("blankPage")
		public boolean getBlankPage() {
			return blankPage;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class ChangeNavigationHistoryStateCommand implements UiCommand<Void> {

		protected String pathOrUrl;
		protected boolean fireEvent;
		protected boolean push;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ChangeNavigationHistoryStateCommand() {
			// default constructor for Jackson
		}

		public ChangeNavigationHistoryStateCommand(String pathOrUrl, boolean fireEvent, boolean push) {
			this.pathOrUrl = pathOrUrl;
			this.fireEvent = fireEvent;
			this.push = push;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("pathOrUrl=" + pathOrUrl).append(", ")
					.append("fireEvent=" + fireEvent).append(", ")
					.append("push=" + push)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("pathOrUrl")
		public String getPathOrUrl() {
			return pathOrUrl;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fireEvent")
		public boolean getFireEvent() {
			return fireEvent;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("push")
		public boolean getPush() {
			return push;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class NavigateForwardCommand implements UiCommand<Void> {

		protected int steps;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public NavigateForwardCommand() {
			// default constructor for Jackson
		}

		public NavigateForwardCommand(int steps) {
			this.steps = steps;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("steps=" + steps)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("steps")
		public int getSteps() {
			return steps;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class SetFaviconCommand implements UiCommand<Void> {

		protected String url;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetFaviconCommand() {
			// default constructor for Jackson
		}

		public SetFaviconCommand(String url) {
			this.url = url;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("url=" + url)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("url")
		public String getUrl() {
			return url;
		}

		public String getComponentId() {
			return null;
		}

	}

	public static class SetTitleCommand implements UiCommand<Void> {

		protected String title;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetTitleCommand() {
			// default constructor for Jackson
		}

		public SetTitleCommand(String title) {
			this.title = title;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("title=" + title)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("title")
		public String getTitle() {
			return title;
		}

		public String getComponentId() {
			return null;
		}

	}

}