/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.dto.UiInfiniteItemViewDataRequest;
import org.teamapps.dto.UiItemJustification;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;
import org.teamapps.dto.UiVerticalItemAlignment;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiInfiniteItemView.class)
public class UiInfiniteItemView
extends UiComponent
implements UiObject {
    protected UiTemplate itemTemplate;
    protected float itemWidth = 0.0f;
    protected int rowHeight;
    protected List<UiIdentifiableClientRecord> data;
    protected int totalNumberOfRecords = 0;
    protected int horizontalItemMargin = 0;
    protected boolean autoHeight = false;
    protected UiItemJustification itemJustification = UiItemJustification.LEFT;
    protected UiVerticalItemAlignment verticalItemAlignment = UiVerticalItemAlignment.STRETCH;
    protected boolean contextMenuEnabled = false;

    @Deprecated
    public UiInfiniteItemView() {
    }

    public UiInfiniteItemView(UiTemplate itemTemplate, int rowHeight) {
        this.itemTemplate = itemTemplate;
        this.rowHeight = rowHeight;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_INFINITE_ITEM_VIEW;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + (String)(this.itemTemplate != null ? "itemTemplate={" + this.itemTemplate.toString() + "}" : "") + ", " + ("itemWidth=" + this.itemWidth) + ", " + ("rowHeight=" + this.rowHeight) + ", " + ("totalNumberOfRecords=" + this.totalNumberOfRecords) + ", " + ("horizontalItemMargin=" + this.horizontalItemMargin) + ", " + ("autoHeight=" + this.autoHeight) + ", " + ("itemJustification=" + this.itemJustification) + ", " + ("verticalItemAlignment=" + this.verticalItemAlignment) + ", " + ("contextMenuEnabled=" + this.contextMenuEnabled) + ", " + (String)(this.data != null ? "data={" + this.data.toString() + "}" : "");
    }

    @JsonGetter(value="itemTemplate")
    public UiTemplate getItemTemplate() {
        return this.itemTemplate;
    }

    @JsonGetter(value="itemWidth")
    public float getItemWidth() {
        return this.itemWidth;
    }

    @JsonGetter(value="rowHeight")
    public int getRowHeight() {
        return this.rowHeight;
    }

    @JsonGetter(value="data")
    public List<UiIdentifiableClientRecord> getData() {
        return this.data;
    }

    @JsonGetter(value="totalNumberOfRecords")
    public int getTotalNumberOfRecords() {
        return this.totalNumberOfRecords;
    }

    @JsonGetter(value="horizontalItemMargin")
    public int getHorizontalItemMargin() {
        return this.horizontalItemMargin;
    }

    @JsonGetter(value="autoHeight")
    public boolean getAutoHeight() {
        return this.autoHeight;
    }

    @JsonGetter(value="itemJustification")
    public UiItemJustification getItemJustification() {
        return this.itemJustification;
    }

    @JsonGetter(value="verticalItemAlignment")
    public UiVerticalItemAlignment getVerticalItemAlignment() {
        return this.verticalItemAlignment;
    }

    @JsonGetter(value="contextMenuEnabled")
    public boolean getContextMenuEnabled() {
        return this.contextMenuEnabled;
    }

    @Override
    @JsonSetter(value="id")
    public UiInfiniteItemView setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiInfiniteItemView setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiInfiniteItemView setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiInfiniteItemView setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiInfiniteItemView setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiInfiniteItemView setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="itemWidth")
    public UiInfiniteItemView setItemWidth(float itemWidth) {
        this.itemWidth = itemWidth;
        return this;
    }

    @JsonSetter(value="data")
    public UiInfiniteItemView setData(List<UiIdentifiableClientRecord> data) {
        this.data = data;
        return this;
    }

    @JsonSetter(value="totalNumberOfRecords")
    public UiInfiniteItemView setTotalNumberOfRecords(int totalNumberOfRecords) {
        this.totalNumberOfRecords = totalNumberOfRecords;
        return this;
    }

    @JsonSetter(value="horizontalItemMargin")
    public UiInfiniteItemView setHorizontalItemMargin(int horizontalItemMargin) {
        this.horizontalItemMargin = horizontalItemMargin;
        return this;
    }

    @JsonSetter(value="autoHeight")
    public UiInfiniteItemView setAutoHeight(boolean autoHeight) {
        this.autoHeight = autoHeight;
        return this;
    }

    @JsonSetter(value="itemJustification")
    public UiInfiniteItemView setItemJustification(UiItemJustification itemJustification) {
        this.itemJustification = itemJustification;
        return this;
    }

    @JsonSetter(value="verticalItemAlignment")
    public UiInfiniteItemView setVerticalItemAlignment(UiVerticalItemAlignment verticalItemAlignment) {
        this.verticalItemAlignment = verticalItemAlignment;
        return this;
    }

    @JsonSetter(value="contextMenuEnabled")
    public UiInfiniteItemView setContextMenuEnabled(boolean contextMenuEnabled) {
        this.contextMenuEnabled = contextMenuEnabled;
        return this;
    }

    public static class CloseContextMenuCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int requestId;

        @Deprecated
        public CloseContextMenuCommand() {
        }

        public CloseContextMenuCommand(String componentId, int requestId) {
            this.componentId = componentId;
            this.requestId = requestId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestId=" + this.requestId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestId")
        public int getRequestId() {
            return this.requestId;
        }
    }

    public static class SetContextMenuContentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int requestId;
        protected UiClientObjectReference component;

        @Deprecated
        public SetContextMenuContentCommand() {
        }

        public SetContextMenuContentCommand(String componentId, int requestId, UiClientObjectReference component) {
            this.componentId = componentId;
            this.requestId = requestId;
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestId=" + this.requestId) + ", " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestId")
        public int getRequestId() {
            return this.requestId;
        }

        @JsonGetter(value="component")
        public UiClientObjectReference getComponent() {
            return this.component;
        }
    }

    public static class SetVerticalItemAlignmentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiVerticalItemAlignment verticalItemAlignment;

        @Deprecated
        public SetVerticalItemAlignmentCommand() {
        }

        public SetVerticalItemAlignmentCommand(String componentId, UiVerticalItemAlignment verticalItemAlignment) {
            this.componentId = componentId;
            this.verticalItemAlignment = verticalItemAlignment;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("verticalItemAlignment=" + this.verticalItemAlignment);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="verticalItemAlignment")
        public UiVerticalItemAlignment getVerticalItemAlignment() {
            return this.verticalItemAlignment;
        }
    }

    public static class SetItemJustificationCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiItemJustification itemJustification;

        @Deprecated
        public SetItemJustificationCommand() {
        }

        public SetItemJustificationCommand(String componentId, UiItemJustification itemJustification) {
            this.componentId = componentId;
            this.itemJustification = itemJustification;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("itemJustification=" + this.itemJustification);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="itemJustification")
        public UiItemJustification getItemJustification() {
            return this.itemJustification;
        }
    }

    public static class SetHorizontalItemMarginCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int horizontalItemMargin;

        @Deprecated
        public SetHorizontalItemMarginCommand() {
        }

        public SetHorizontalItemMarginCommand(String componentId, int horizontalItemMargin) {
            this.componentId = componentId;
            this.horizontalItemMargin = horizontalItemMargin;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("horizontalItemMargin=" + this.horizontalItemMargin);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="horizontalItemMargin")
        public int getHorizontalItemMargin() {
            return this.horizontalItemMargin;
        }
    }

    public static class SetItemWidthCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected float itemWidth;

        @Deprecated
        public SetItemWidthCommand() {
        }

        public SetItemWidthCommand(String componentId, float itemWidth) {
            this.componentId = componentId;
            this.itemWidth = itemWidth;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("itemWidth=" + this.itemWidth);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="itemWidth")
        public float getItemWidth() {
            return this.itemWidth;
        }
    }

    public static class SetItemTemplateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiTemplate itemTemplate;

        @Deprecated
        public SetItemTemplateCommand() {
        }

        public SetItemTemplateCommand(String componentId, UiTemplate itemTemplate) {
            this.componentId = componentId;
            this.itemTemplate = itemTemplate;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.itemTemplate != null ? "itemTemplate={" + this.itemTemplate.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="itemTemplate")
        public UiTemplate getItemTemplate() {
            return this.itemTemplate;
        }
    }

    public static class RemoveDataCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<Integer> ids;

        @Deprecated
        public RemoveDataCommand() {
        }

        public RemoveDataCommand(String componentId, List<Integer> ids) {
            this.componentId = componentId;
            this.ids = ids;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("ids=" + this.ids);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="ids")
        public List<Integer> getIds() {
            return this.ids;
        }
    }

    public static class AddDataCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int startIndex;
        protected List<UiIdentifiableClientRecord> data;
        protected int totalNumberOfRecords;
        protected boolean clear;

        @Deprecated
        public AddDataCommand() {
        }

        public AddDataCommand(String componentId, int startIndex, List<UiIdentifiableClientRecord> data, int totalNumberOfRecords, boolean clear) {
            this.componentId = componentId;
            this.startIndex = startIndex;
            this.data = data;
            this.totalNumberOfRecords = totalNumberOfRecords;
            this.clear = clear;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("startIndex=" + this.startIndex) + ", " + ("totalNumberOfRecords=" + this.totalNumberOfRecords) + ", " + ("clear=" + this.clear) + ", " + (String)(this.data != null ? "data={" + this.data.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="startIndex")
        public int getStartIndex() {
            return this.startIndex;
        }

        @JsonGetter(value="data")
        public List<UiIdentifiableClientRecord> getData() {
            return this.data;
        }

        @JsonGetter(value="totalNumberOfRecords")
        public int getTotalNumberOfRecords() {
            return this.totalNumberOfRecords;
        }

        @JsonGetter(value="clear")
        public boolean getClear() {
            return this.clear;
        }
    }

    public static class ContextMenuRequestedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int requestId;
        protected int recordId;

        @Deprecated
        public ContextMenuRequestedEvent() {
        }

        public ContextMenuRequestedEvent(String componentId, int requestId, int recordId) {
            this.componentId = componentId;
            this.requestId = requestId;
            this.recordId = recordId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_INFINITE_ITEM_VIEW_CONTEXT_MENU_REQUESTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestId=" + this.requestId) + ", " + ("recordId=" + this.recordId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestId")
        public int getRequestId() {
            return this.requestId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }
    }

    public static class ItemClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int recordId;
        protected boolean isDoubleClick;

        @Deprecated
        public ItemClickedEvent() {
        }

        public ItemClickedEvent(String componentId, int recordId, boolean isDoubleClick) {
            this.componentId = componentId;
            this.recordId = recordId;
            this.isDoubleClick = isDoubleClick;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_INFINITE_ITEM_VIEW_ITEM_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId) + ", " + ("isDoubleClick=" + this.isDoubleClick);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }

        @JsonGetter(value="isDoubleClick")
        public boolean getIsDoubleClick() {
            return this.isDoubleClick;
        }
    }

    public static class DisplayedRangeChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int startIndex;
        protected int length;
        protected List<Integer> displayedRecordIds;
        protected UiInfiniteItemViewDataRequest dataRequest;

        @Deprecated
        public DisplayedRangeChangedEvent() {
        }

        public DisplayedRangeChangedEvent(String componentId, int startIndex, int length, List<Integer> displayedRecordIds, UiInfiniteItemViewDataRequest dataRequest) {
            this.componentId = componentId;
            this.startIndex = startIndex;
            this.length = length;
            this.displayedRecordIds = displayedRecordIds;
            this.dataRequest = dataRequest;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_INFINITE_ITEM_VIEW_DISPLAYED_RANGE_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("displayedRecordIds=" + this.displayedRecordIds) + ", " + ("startIndex=" + this.startIndex) + ", " + ("length=" + this.length) + ", " + (String)(this.dataRequest != null ? "dataRequest={" + this.dataRequest.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="startIndex")
        public int getStartIndex() {
            return this.startIndex;
        }

        @JsonGetter(value="length")
        public int getLength() {
            return this.length;
        }

        @JsonGetter(value="displayedRecordIds")
        public List<Integer> getDisplayedRecordIds() {
            return this.displayedRecordIds;
        }

        @JsonGetter(value="dataRequest")
        public UiInfiniteItemViewDataRequest getDataRequest() {
            return this.dataRequest;
        }
    }
}

