package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public abstract class AbstractUiTemplateElement implements UiObject {


	protected String dataKey;
	protected int row;
	protected int column;
	protected int rowSpan = 1;
	protected int colSpan = 1;
	protected UiHorizontalElementAlignment horizontalAlignment = UiHorizontalElementAlignment.LEFT;
	protected UiVerticalElementAlignment verticalAlignment = UiVerticalElementAlignment.CENTER;
	protected UiSpacing margin;
	protected UiColor backgroundColor;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public AbstractUiTemplateElement() {
		// default constructor for Jackson
	}

	public AbstractUiTemplateElement(String dataKey, int row, int column) {
		this.dataKey = dataKey;
		this.row = row;
		this.column = column;
	}


	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("dataKey=" + dataKey).append(", ")
				.append("row=" + row).append(", ")
				.append("column=" + column).append(", ")
				.append("rowSpan=" + rowSpan).append(", ")
				.append("colSpan=" + colSpan).append(", ")
				.append("horizontalAlignment=" + horizontalAlignment).append(", ")
				.append("verticalAlignment=" + verticalAlignment).append(", ")
				.append(margin != null ? "margin={" + margin.toString() + "}" : "").append(", ")
				.append(backgroundColor != null ? "backgroundColor={" + backgroundColor.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("dataKey")
	public String getDataKey() {
		return dataKey;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("row")
	public int getRow() {
		return row;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("column")
	public int getColumn() {
		return column;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("rowSpan")
	public int getRowSpan() {
		return rowSpan;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("colSpan")
	public int getColSpan() {
		return colSpan;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("horizontalAlignment")
	public UiHorizontalElementAlignment getHorizontalAlignment() {
		return horizontalAlignment;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("verticalAlignment")
	public UiVerticalElementAlignment getVerticalAlignment() {
		return verticalAlignment;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("margin")
	public UiSpacing getMargin() {
		return margin;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public UiColor getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("rowSpan")
	public AbstractUiTemplateElement setRowSpan(int rowSpan) {
		this.rowSpan = rowSpan;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("colSpan")
	public AbstractUiTemplateElement setColSpan(int colSpan) {
		this.colSpan = colSpan;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("horizontalAlignment")
	public AbstractUiTemplateElement setHorizontalAlignment(UiHorizontalElementAlignment horizontalAlignment) {
		this.horizontalAlignment = horizontalAlignment;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("verticalAlignment")
	public AbstractUiTemplateElement setVerticalAlignment(UiVerticalElementAlignment verticalAlignment) {
		this.verticalAlignment = verticalAlignment;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("margin")
	public AbstractUiTemplateElement setMargin(UiSpacing margin) {
		this.margin = margin;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public AbstractUiTemplateElement setBackgroundColor(UiColor backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}






}