package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiComboBox extends UiField implements UiTextInputHandlingField, UiObject {


	protected Map<String, UiTemplate> templates;
	protected List<UiComboBoxTreeRecord> staticData;
	protected List<String> staticDataMatchPropertyNames;
	protected UiTextMatchingMode textMatchingMode = UiTextMatchingMode.CONTAINS;
	protected boolean showDropDownButton = true;
	protected boolean showDropDownAfterResultsArrive = false;
	protected boolean highlightFirstResultEntry = true;
	protected boolean showHighlighting;
	protected boolean autoComplete = true;
	protected int textHighlightingEntryLimit = 100;
	protected boolean allowAnyText;
	protected boolean showClearButton;
	protected boolean animate;
	protected boolean showExpanders = true;

	public UiComboBox() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_COMBO_BOX;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("staticDataMatchPropertyNames=" + staticDataMatchPropertyNames).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("editingMode=" + editingMode).append(", ")
				.append("value=" + value).append(", ")
				.append(templates != null ? "templates={" + templates.toString() + "}" : "").append(", ")
				.append("textMatchingMode=" + textMatchingMode).append(", ")
				.append("showDropDownButton=" + showDropDownButton).append(", ")
				.append("showDropDownAfterResultsArrive=" + showDropDownAfterResultsArrive).append(", ")
				.append("highlightFirstResultEntry=" + highlightFirstResultEntry).append(", ")
				.append("showHighlighting=" + showHighlighting).append(", ")
				.append("autoComplete=" + autoComplete).append(", ")
				.append("textHighlightingEntryLimit=" + textHighlightingEntryLimit).append(", ")
				.append("allowAnyText=" + allowAnyText).append(", ")
				.append("showClearButton=" + showClearButton).append(", ")
				.append("animate=" + animate).append(", ")
				.append("showExpanders=" + showExpanders).append(", ")
				.append(fieldMessages != null ? "fieldMessages={" + fieldMessages.toString() + "}" : "").append(", ")
				.append(staticData != null ? "staticData={" + staticData.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("templates")
	public Map<String, UiTemplate> getTemplates() {
		return templates;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("staticData")
	public List<UiComboBoxTreeRecord> getStaticData() {
		return staticData;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("staticDataMatchPropertyNames")
	public List<String> getStaticDataMatchPropertyNames() {
		return staticDataMatchPropertyNames;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("textMatchingMode")
	public UiTextMatchingMode getTextMatchingMode() {
		return textMatchingMode;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showDropDownButton")
	public boolean getShowDropDownButton() {
		return showDropDownButton;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showDropDownAfterResultsArrive")
	public boolean getShowDropDownAfterResultsArrive() {
		return showDropDownAfterResultsArrive;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("highlightFirstResultEntry")
	public boolean getHighlightFirstResultEntry() {
		return highlightFirstResultEntry;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showHighlighting")
	public boolean getShowHighlighting() {
		return showHighlighting;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("autoComplete")
	public boolean getAutoComplete() {
		return autoComplete;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("textHighlightingEntryLimit")
	public int getTextHighlightingEntryLimit() {
		return textHighlightingEntryLimit;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("allowAnyText")
	public boolean getAllowAnyText() {
		return allowAnyText;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showClearButton")
	public boolean getShowClearButton() {
		return showClearButton;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("animate")
	public boolean getAnimate() {
		return animate;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showExpanders")
	public boolean getShowExpanders() {
		return showExpanders;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiComboBox setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiComboBox setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiComboBox setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("editingMode")
	public UiComboBox setEditingMode(UiFieldEditingMode editingMode) {
		this.editingMode = editingMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("value")
	public UiComboBox setValue(Object value) {
		this.value = value;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fieldMessages")
	public UiComboBox setFieldMessages(List<UiFieldMessage> fieldMessages) {
		this.fieldMessages = fieldMessages;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("templates")
	public UiComboBox setTemplates(Map<String, UiTemplate> templates) {
		this.templates = templates;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("staticData")
	public UiComboBox setStaticData(List<UiComboBoxTreeRecord> staticData) {
		this.staticData = staticData;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("staticDataMatchPropertyNames")
	public UiComboBox setStaticDataMatchPropertyNames(List<String> staticDataMatchPropertyNames) {
		this.staticDataMatchPropertyNames = staticDataMatchPropertyNames;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("textMatchingMode")
	public UiComboBox setTextMatchingMode(UiTextMatchingMode textMatchingMode) {
		this.textMatchingMode = textMatchingMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showDropDownButton")
	public UiComboBox setShowDropDownButton(boolean showDropDownButton) {
		this.showDropDownButton = showDropDownButton;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showDropDownAfterResultsArrive")
	public UiComboBox setShowDropDownAfterResultsArrive(boolean showDropDownAfterResultsArrive) {
		this.showDropDownAfterResultsArrive = showDropDownAfterResultsArrive;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("highlightFirstResultEntry")
	public UiComboBox setHighlightFirstResultEntry(boolean highlightFirstResultEntry) {
		this.highlightFirstResultEntry = highlightFirstResultEntry;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showHighlighting")
	public UiComboBox setShowHighlighting(boolean showHighlighting) {
		this.showHighlighting = showHighlighting;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("autoComplete")
	public UiComboBox setAutoComplete(boolean autoComplete) {
		this.autoComplete = autoComplete;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("textHighlightingEntryLimit")
	public UiComboBox setTextHighlightingEntryLimit(int textHighlightingEntryLimit) {
		this.textHighlightingEntryLimit = textHighlightingEntryLimit;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("allowAnyText")
	public UiComboBox setAllowAnyText(boolean allowAnyText) {
		this.allowAnyText = allowAnyText;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showClearButton")
	public UiComboBox setShowClearButton(boolean showClearButton) {
		this.showClearButton = showClearButton;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("animate")
	public UiComboBox setAnimate(boolean animate) {
		this.animate = animate;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showExpanders")
	public UiComboBox setShowExpanders(boolean showExpanders) {
		this.showExpanders = showExpanders;
		return this;
	}

	public static class LazyChildDataRequestedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int parentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public LazyChildDataRequestedEvent() {
			// default constructor for Jackson
		}

		public LazyChildDataRequestedEvent(String componentId, int parentId) {
			this.componentId = componentId;
			this.parentId = parentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_COMBO_BOX_LAZY_CHILD_DATA_REQUESTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("parentId=" + parentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("parentId")
		public int getParentId() {
			return parentId;
		}

	}

	public static class SetDropDownDataCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiComboBoxTreeRecord> data;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetDropDownDataCommand() {
			// default constructor for Jackson
		}

		public SetDropDownDataCommand(String componentId, List<UiComboBoxTreeRecord> data) {
			this.componentId = componentId;
			this.data = data;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(data != null ? "data={" + data.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("data")
		public List<UiComboBoxTreeRecord> getData() {
			return data;
		}

	}

	public static class SetChildNodesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int parentId;
		protected List<UiComboBoxTreeRecord> children;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetChildNodesCommand() {
			// default constructor for Jackson
		}

		public SetChildNodesCommand(String componentId, int parentId, List<UiComboBoxTreeRecord> children) {
			this.componentId = componentId;
			this.parentId = parentId;
			this.children = children;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("parentId=" + parentId).append(", ")
					.append(children != null ? "children={" + children.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("parentId")
		public int getParentId() {
			return parentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("children")
		public List<UiComboBoxTreeRecord> getChildren() {
			return children;
		}

	}

	public static class RegisterTemplateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String id;
		protected UiTemplate template;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RegisterTemplateCommand() {
			// default constructor for Jackson
		}

		public RegisterTemplateCommand(String componentId, String id, UiTemplate template) {
			this.componentId = componentId;
			this.id = id;
			this.template = template;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("id=" + id).append(", ")
					.append("componentId=" + componentId).append(", ")
					.append(template != null ? "template={" + template.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("id")
		public String getId() {
			return id;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("template")
		public UiTemplate getTemplate() {
			return template;
		}

	}

	public static class ReplaceFreeTextEntryCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String freeText;
		protected UiComboBoxTreeRecord newEntry;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ReplaceFreeTextEntryCommand() {
			// default constructor for Jackson
		}

		public ReplaceFreeTextEntryCommand(String componentId, String freeText, UiComboBoxTreeRecord newEntry) {
			this.componentId = componentId;
			this.freeText = freeText;
			this.newEntry = newEntry;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("freeText=" + freeText).append(", ")
					.append(newEntry != null ? "newEntry={" + newEntry.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("freeText")
		public String getFreeText() {
			return freeText;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("newEntry")
		public UiComboBoxTreeRecord getNewEntry() {
			return newEntry;
		}

	}




}