package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiGridLayout implements UiObject {


	protected List<UiGridColumn> columns;
	protected List<UiGridRow> rows;
	protected List<UiGridPlacement> componentPlacements;
	protected UiSpacing margin;
	protected UiSpacing padding;
	protected UiBorder border;
	protected UiShadow shadow;
	protected UiColor backgroundColor;
	protected int gridGap = 7;
	protected UiVerticalElementAlignment verticalAlignment = UiVerticalElementAlignment.STRETCH;
	protected UiHorizontalElementAlignment horizontalAlignment = UiHorizontalElementAlignment.STRETCH;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiGridLayout() {
		// default constructor for Jackson
	}

	public UiGridLayout(List<UiGridColumn> columns, List<UiGridRow> rows, List<UiGridPlacement> componentPlacements) {
		this.columns = columns;
		this.rows = rows;
		this.componentPlacements = componentPlacements;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_GRID_LAYOUT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append(componentPlacements != null ? "componentPlacements={" + componentPlacements.toString() + "}" : "").append(", ")
				.append("gridGap=" + gridGap).append(", ")
				.append("verticalAlignment=" + verticalAlignment).append(", ")
				.append("horizontalAlignment=" + horizontalAlignment).append(", ")
				.append(columns != null ? "columns={" + columns.toString() + "}" : "").append(", ")
				.append(rows != null ? "rows={" + rows.toString() + "}" : "").append(", ")
				.append(margin != null ? "margin={" + margin.toString() + "}" : "").append(", ")
				.append(padding != null ? "padding={" + padding.toString() + "}" : "").append(", ")
				.append(border != null ? "border={" + border.toString() + "}" : "").append(", ")
				.append(shadow != null ? "shadow={" + shadow.toString() + "}" : "").append(", ")
				.append(backgroundColor != null ? "backgroundColor={" + backgroundColor.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("columns")
	public List<UiGridColumn> getColumns() {
		return columns;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("rows")
	public List<UiGridRow> getRows() {
		return rows;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("componentPlacements")
	public List<UiGridPlacement> getComponentPlacements() {
		return componentPlacements;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("margin")
	public UiSpacing getMargin() {
		return margin;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("padding")
	public UiSpacing getPadding() {
		return padding;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("border")
	public UiBorder getBorder() {
		return border;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("shadow")
	public UiShadow getShadow() {
		return shadow;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public UiColor getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("gridGap")
	public int getGridGap() {
		return gridGap;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("verticalAlignment")
	public UiVerticalElementAlignment getVerticalAlignment() {
		return verticalAlignment;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("horizontalAlignment")
	public UiHorizontalElementAlignment getHorizontalAlignment() {
		return horizontalAlignment;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("margin")
	public UiGridLayout setMargin(UiSpacing margin) {
		this.margin = margin;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("padding")
	public UiGridLayout setPadding(UiSpacing padding) {
		this.padding = padding;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("border")
	public UiGridLayout setBorder(UiBorder border) {
		this.border = border;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("shadow")
	public UiGridLayout setShadow(UiShadow shadow) {
		this.shadow = shadow;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiGridLayout setBackgroundColor(UiColor backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("gridGap")
	public UiGridLayout setGridGap(int gridGap) {
		this.gridGap = gridGap;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("verticalAlignment")
	public UiGridLayout setVerticalAlignment(UiVerticalElementAlignment verticalAlignment) {
		this.verticalAlignment = verticalAlignment;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("horizontalAlignment")
	public UiGridLayout setHorizontalAlignment(UiHorizontalElementAlignment horizontalAlignment) {
		this.horizontalAlignment = horizontalAlignment;
		return this;
	}






}