package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiImageCropper extends UiComponent implements UiObject {


	protected String imageUrl;
	protected UiImageCropperSelectionMode selectionMode;
	protected float aspectRatio = 1;
	protected UiImageCropperSelection selection;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiImageCropper() {
		// default constructor for Jackson
	}

	public UiImageCropper(String imageUrl, UiImageCropperSelectionMode selectionMode, float aspectRatio) {
		super();
		this.imageUrl = imageUrl;
		this.selectionMode = selectionMode;
		this.aspectRatio = aspectRatio;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_IMAGE_CROPPER;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("imageUrl=" + imageUrl).append(", ")
				.append("selectionMode=" + selectionMode).append(", ")
				.append("aspectRatio=" + aspectRatio).append(", ")
				.append(selection != null ? "selection={" + selection.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("imageUrl")
	public String getImageUrl() {
		return imageUrl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("selectionMode")
	public UiImageCropperSelectionMode getSelectionMode() {
		return selectionMode;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("aspectRatio")
	public float getAspectRatio() {
		return aspectRatio;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("selection")
	public UiImageCropperSelection getSelection() {
		return selection;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiImageCropper setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiImageCropper setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiImageCropper setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("selection")
	public UiImageCropper setSelection(UiImageCropperSelection selection) {
		this.selection = selection;
		return this;
	}

	public static class SelectionChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiImageCropperSelection selection;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SelectionChangedEvent() {
			// default constructor for Jackson
		}

		public SelectionChangedEvent(String componentId, UiImageCropperSelection selection) {
			this.componentId = componentId;
			this.selection = selection;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_IMAGE_CROPPER_SELECTION_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(selection != null ? "selection={" + selection.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("selection")
		public UiImageCropperSelection getSelection() {
			return selection;
		}

	}

	public static class SetImageUrlCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String imageUrl;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetImageUrlCommand() {
			// default constructor for Jackson
		}

		public SetImageUrlCommand(String componentId, String imageUrl) {
			this.componentId = componentId;
			this.imageUrl = imageUrl;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("imageUrl=" + imageUrl)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("imageUrl")
		public String getImageUrl() {
			return imageUrl;
		}

	}

	public static class SetSelectionModeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiImageCropperSelectionMode selectionMode;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetSelectionModeCommand() {
			// default constructor for Jackson
		}

		public SetSelectionModeCommand(String componentId, UiImageCropperSelectionMode selectionMode) {
			this.componentId = componentId;
			this.selectionMode = selectionMode;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("selectionMode=" + selectionMode)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("selectionMode")
		public UiImageCropperSelectionMode getSelectionMode() {
			return selectionMode;
		}

	}

	public static class SetAspectRatioCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected float aspectRatio;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetAspectRatioCommand() {
			// default constructor for Jackson
		}

		public SetAspectRatioCommand(String componentId, float aspectRatio) {
			this.componentId = componentId;
			this.aspectRatio = aspectRatio;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("aspectRatio=" + aspectRatio)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("aspectRatio")
		public float getAspectRatio() {
			return aspectRatio;
		}

	}

	public static class SetSelectionCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiImageCropperSelection selection;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetSelectionCommand() {
			// default constructor for Jackson
		}

		public SetSelectionCommand(String componentId, UiImageCropperSelection selection) {
			this.componentId = componentId;
			this.selection = selection;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(selection != null ? "selection={" + selection.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("selection")
		public UiImageCropperSelection getSelection() {
			return selection;
		}

	}




}