/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import org.teamapps.dto.AbstractUiTemplateElement;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiBorder;
import org.teamapps.dto.UiColor;
import org.teamapps.dto.UiHorizontalElementAlignment;
import org.teamapps.dto.UiImageSizing;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiShadow;
import org.teamapps.dto.UiSpacing;
import org.teamapps.dto.UiVerticalElementAlignment;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiImageElement
extends AbstractUiTemplateElement
implements UiObject {
    protected int width;
    protected int height;
    protected UiBorder border;
    protected UiSpacing padding;
    protected UiShadow shadow;
    protected UiImageSizing imageSizing = UiImageSizing.COVER;

    @Deprecated
    public UiImageElement() {
    }

    public UiImageElement(String dataKey, int row, int column, int width, int height) {
        super(dataKey, row, column);
        this.width = width;
        this.height = height;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_IMAGE_ELEMENT;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("dataKey=" + this.dataKey) + ", " + ("row=" + this.row) + ", " + ("column=" + this.column) + ", " + ("rowSpan=" + this.rowSpan) + ", " + ("colSpan=" + this.colSpan) + ", " + ("horizontalAlignment=" + this.horizontalAlignment) + ", " + ("verticalAlignment=" + this.verticalAlignment) + ", " + ("width=" + this.width) + ", " + ("height=" + this.height) + ", " + ("imageSizing=" + this.imageSizing) + ", " + (String)(this.margin != null ? "margin={" + this.margin.toString() + "}" : "") + ", " + (String)(this.backgroundColor != null ? "backgroundColor={" + this.backgroundColor.toString() + "}" : "") + ", " + (String)(this.border != null ? "border={" + this.border.toString() + "}" : "") + ", " + (String)(this.padding != null ? "padding={" + this.padding.toString() + "}" : "") + ", " + (String)(this.shadow != null ? "shadow={" + this.shadow.toString() + "}" : "");
    }

    @JsonGetter(value="width")
    public int getWidth() {
        return this.width;
    }

    @JsonGetter(value="height")
    public int getHeight() {
        return this.height;
    }

    @JsonGetter(value="border")
    public UiBorder getBorder() {
        return this.border;
    }

    @JsonGetter(value="padding")
    public UiSpacing getPadding() {
        return this.padding;
    }

    @JsonGetter(value="shadow")
    public UiShadow getShadow() {
        return this.shadow;
    }

    @JsonGetter(value="imageSizing")
    public UiImageSizing getImageSizing() {
        return this.imageSizing;
    }

    @Override
    @JsonSetter(value="rowSpan")
    public UiImageElement setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
        return this;
    }

    @Override
    @JsonSetter(value="colSpan")
    public UiImageElement setColSpan(int colSpan) {
        this.colSpan = colSpan;
        return this;
    }

    @Override
    @JsonSetter(value="horizontalAlignment")
    public UiImageElement setHorizontalAlignment(UiHorizontalElementAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @Override
    @JsonSetter(value="verticalAlignment")
    public UiImageElement setVerticalAlignment(UiVerticalElementAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @Override
    @JsonSetter(value="margin")
    public UiImageElement setMargin(UiSpacing margin) {
        this.margin = margin;
        return this;
    }

    @Override
    @JsonSetter(value="backgroundColor")
    public UiImageElement setBackgroundColor(UiColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="border")
    public UiImageElement setBorder(UiBorder border) {
        this.border = border;
        return this;
    }

    @JsonSetter(value="padding")
    public UiImageElement setPadding(UiSpacing padding) {
        this.padding = padding;
        return this;
    }

    @JsonSetter(value="shadow")
    public UiImageElement setShadow(UiShadow shadow) {
        this.shadow = shadow;
        return this;
    }

    @JsonSetter(value="imageSizing")
    public UiImageElement setImageSizing(UiImageSizing imageSizing) {
        this.imageSizing = imageSizing;
        return this;
    }
}

