/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiVideoCodec;
import org.teamapps.dto.UiWebRtcPlayingSettings;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiWebRtcPlayer
extends UiComponent
implements UiObject {
    protected UiWebRtcPlayingSettings playingSettings;
    protected String backgroundImageUrl;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_WEB_RTC_PLAYER;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("backgroundImageUrl=" + this.backgroundImageUrl) + ", " + (String)(this.playingSettings != null ? "playingSettings={" + this.playingSettings.toString() + "}" : "");
    }

    @JsonGetter(value="playingSettings")
    public UiWebRtcPlayingSettings getPlayingSettings() {
        return this.playingSettings;
    }

    @JsonGetter(value="backgroundImageUrl")
    public String getBackgroundImageUrl() {
        return this.backgroundImageUrl;
    }

    @Override
    @JsonSetter(value="id")
    public UiWebRtcPlayer setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiWebRtcPlayer setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiWebRtcPlayer setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="playingSettings")
    public UiWebRtcPlayer setPlayingSettings(UiWebRtcPlayingSettings playingSettings) {
        this.playingSettings = playingSettings;
        return this;
    }

    @JsonSetter(value="backgroundImageUrl")
    public UiWebRtcPlayer setBackgroundImageUrl(String backgroundImageUrl) {
        this.backgroundImageUrl = backgroundImageUrl;
        return this;
    }

    public static class GetPlayableVideoCodecsCommand
    implements UiCommand<List<UiVideoCodec>> {
        public String toString() {
            return this.getClass().getSimpleName() + ": ";
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetBackgroundImageUrlCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String backgroundImageUrl;

        @Deprecated
        public SetBackgroundImageUrlCommand() {
        }

        public SetBackgroundImageUrlCommand(String componentId, String backgroundImageUrl) {
            this.componentId = componentId;
            this.backgroundImageUrl = backgroundImageUrl;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("backgroundImageUrl=" + this.backgroundImageUrl);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="backgroundImageUrl")
        public String getBackgroundImageUrl() {
            return this.backgroundImageUrl;
        }
    }

    public static class StopPlayingCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public StopPlayingCommand() {
        }

        public StopPlayingCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class PlayCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiWebRtcPlayingSettings settings;

        @Deprecated
        public PlayCommand() {
        }

        public PlayCommand(String componentId, UiWebRtcPlayingSettings settings) {
            this.componentId = componentId;
            this.settings = settings;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.settings != null ? "settings={" + this.settings.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="settings")
        public UiWebRtcPlayingSettings getSettings() {
            return this.settings;
        }
    }
}

