/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import org.teamapps.dto.UiClientRecord;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;
import org.teamapps.dto.UiTreeGraphNodeIcon;
import org.teamapps.dto.UiTreeGraphNodeImage;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiNetworkNode.class)
public class UiNetworkNode
implements UiObject {
    protected String id;
    protected int width;
    protected int height;
    protected String backgroundColor = "rgb(255, 255, 255)";
    protected String borderColor = "rgb(100, 100, 100)";
    protected float borderWidth = 1.0f;
    protected float borderRadius = 0.0f;
    protected float distanceFactor = 0.6f;
    protected UiTreeGraphNodeImage image;
    protected UiTreeGraphNodeIcon icon;
    protected UiTemplate template;
    protected UiClientRecord record;
    protected ExpandState expandState;

    @Deprecated
    public UiNetworkNode() {
    }

    public UiNetworkNode(String id, int width, int height) {
        this.id = id;
        this.width = width;
        this.height = height;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_NETWORK_NODE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("width=" + this.width) + ", " + ("height=" + this.height) + ", " + ("backgroundColor=" + this.backgroundColor) + ", " + ("borderColor=" + this.borderColor) + ", " + ("borderWidth=" + this.borderWidth) + ", " + ("borderRadius=" + this.borderRadius) + ", " + ("distanceFactor=" + this.distanceFactor) + ", " + (String)(this.template != null ? "template={" + this.template.toString() + "}" : "") + ", " + ("expandState=" + String.valueOf((Object)this.expandState)) + ", " + (String)(this.image != null ? "image={" + this.image.toString() + "}" : "") + ", " + (String)(this.icon != null ? "icon={" + this.icon.toString() + "}" : "") + ", " + (String)(this.record != null ? "record={" + this.record.toString() + "}" : "");
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="width")
    public int getWidth() {
        return this.width;
    }

    @JsonGetter(value="height")
    public int getHeight() {
        return this.height;
    }

    @JsonGetter(value="backgroundColor")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonGetter(value="borderColor")
    public String getBorderColor() {
        return this.borderColor;
    }

    @JsonGetter(value="borderWidth")
    public float getBorderWidth() {
        return this.borderWidth;
    }

    @JsonGetter(value="borderRadius")
    public float getBorderRadius() {
        return this.borderRadius;
    }

    @JsonGetter(value="distanceFactor")
    public float getDistanceFactor() {
        return this.distanceFactor;
    }

    @JsonGetter(value="image")
    public UiTreeGraphNodeImage getImage() {
        return this.image;
    }

    @JsonGetter(value="icon")
    public UiTreeGraphNodeIcon getIcon() {
        return this.icon;
    }

    @JsonGetter(value="template")
    public UiTemplate getTemplate() {
        return this.template;
    }

    @JsonGetter(value="record")
    public UiClientRecord getRecord() {
        return this.record;
    }

    @JsonGetter(value="expandState")
    public ExpandState getExpandState() {
        return this.expandState;
    }

    @JsonSetter(value="backgroundColor")
    public UiNetworkNode setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="borderColor")
    public UiNetworkNode setBorderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    @JsonSetter(value="borderWidth")
    public UiNetworkNode setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    @JsonSetter(value="borderRadius")
    public UiNetworkNode setBorderRadius(float borderRadius) {
        this.borderRadius = borderRadius;
        return this;
    }

    @JsonSetter(value="distanceFactor")
    public UiNetworkNode setDistanceFactor(float distanceFactor) {
        this.distanceFactor = distanceFactor;
        return this;
    }

    @JsonSetter(value="image")
    public UiNetworkNode setImage(UiTreeGraphNodeImage image) {
        this.image = image;
        return this;
    }

    @JsonSetter(value="icon")
    public UiNetworkNode setIcon(UiTreeGraphNodeIcon icon) {
        this.icon = icon;
        return this;
    }

    @JsonSetter(value="template")
    public UiNetworkNode setTemplate(UiTemplate template) {
        this.template = template;
        return this;
    }

    @JsonSetter(value="record")
    public UiNetworkNode setRecord(UiClientRecord record) {
        this.record = record;
        return this;
    }

    @JsonSetter(value="expandState")
    public UiNetworkNode setExpandState(ExpandState expandState) {
        this.expandState = expandState;
        return this;
    }

    public static enum ExpandState {
        NOT_EXPANDABLE,
        EXPANDED,
        COLLAPSED;


        @JsonValue
        public int jsonValue() {
            return this.ordinal();
        }
    }
}

