package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type", defaultImpl = UiFileField.class)
public class UiFileField extends UiField implements UiObject {


	protected UiTemplate itemTemplate;
	protected long maxBytesPerFile = 5000000;
	protected String uploadUrl = "/upload";
	protected String fileTooLargeMessage = "File too large!";
	protected String uploadErrorMessage = "Error while transmitting file...";
	protected UiFileFieldDisplayType displayType = UiFileFieldDisplayType.LIST;
	protected int maxFiles;
	protected List<String> acceptedFileTypes;
	protected UiTemplate uploadButtonTemplate;

	@JsonSerialize(using = ObjectSerializer.class)
	@JsonDeserialize(using = ObjectDeserializer.class)
	protected Object uploadButtonData;
	protected boolean showEntriesAsButtonsOnHover = false;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiFileField() {
		// default constructor for Jackson
	}

	public UiFileField(UiTemplate itemTemplate, UiTemplate uploadButtonTemplate, Object uploadButtonData) {
		super();
		this.itemTemplate = itemTemplate;
		this.uploadButtonTemplate = uploadButtonTemplate;
		this.uploadButtonData = uploadButtonData;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_FILE_FIELD;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("editingMode=" + editingMode).append(", ")
				.append("value=" + value).append(", ")
				.append(itemTemplate != null ? "itemTemplate={" + itemTemplate.toString() + "}" : "").append(", ")
				.append("maxBytesPerFile=" + maxBytesPerFile).append(", ")
				.append("uploadUrl=" + uploadUrl).append(", ")
				.append("fileTooLargeMessage=" + fileTooLargeMessage).append(", ")
				.append("uploadErrorMessage=" + uploadErrorMessage).append(", ")
				.append("displayType=" + displayType).append(", ")
				.append("maxFiles=" + maxFiles).append(", ")
				.append("acceptedFileTypes=" + acceptedFileTypes).append(", ")
				.append(uploadButtonTemplate != null ? "uploadButtonTemplate={" + uploadButtonTemplate.toString() + "}" : "").append(", ")
				.append("uploadButtonData=" + uploadButtonData).append(", ")
				.append("showEntriesAsButtonsOnHover=" + showEntriesAsButtonsOnHover).append(", ")
				.append(fieldMessages != null ? "fieldMessages={" + fieldMessages.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("itemTemplate")
	public UiTemplate getItemTemplate() {
		return itemTemplate;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxBytesPerFile")
	public long getMaxBytesPerFile() {
		return maxBytesPerFile;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("uploadUrl")
	public String getUploadUrl() {
		return uploadUrl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("fileTooLargeMessage")
	public String getFileTooLargeMessage() {
		return fileTooLargeMessage;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("uploadErrorMessage")
	public String getUploadErrorMessage() {
		return uploadErrorMessage;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("displayType")
	public UiFileFieldDisplayType getDisplayType() {
		return displayType;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxFiles")
	public int getMaxFiles() {
		return maxFiles;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("acceptedFileTypes")
	public List<String> getAcceptedFileTypes() {
		return acceptedFileTypes;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("uploadButtonTemplate")
	public UiTemplate getUploadButtonTemplate() {
		return uploadButtonTemplate;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("uploadButtonData")
	public Object getUploadButtonData() {
		return uploadButtonData;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showEntriesAsButtonsOnHover")
	public boolean getShowEntriesAsButtonsOnHover() {
		return showEntriesAsButtonsOnHover;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiFileField setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiFileField setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiFileField setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiFileField setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiFileField setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiFileField setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("editingMode")
	public UiFileField setEditingMode(UiFieldEditingMode editingMode) {
		this.editingMode = editingMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("value")
	public UiFileField setValue(Object value) {
		this.value = value;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fieldMessages")
	public UiFileField setFieldMessages(List<UiFieldMessage> fieldMessages) {
		this.fieldMessages = fieldMessages;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxBytesPerFile")
	public UiFileField setMaxBytesPerFile(long maxBytesPerFile) {
		this.maxBytesPerFile = maxBytesPerFile;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("uploadUrl")
	public UiFileField setUploadUrl(String uploadUrl) {
		this.uploadUrl = uploadUrl;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fileTooLargeMessage")
	public UiFileField setFileTooLargeMessage(String fileTooLargeMessage) {
		this.fileTooLargeMessage = fileTooLargeMessage;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("uploadErrorMessage")
	public UiFileField setUploadErrorMessage(String uploadErrorMessage) {
		this.uploadErrorMessage = uploadErrorMessage;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("displayType")
	public UiFileField setDisplayType(UiFileFieldDisplayType displayType) {
		this.displayType = displayType;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxFiles")
	public UiFileField setMaxFiles(int maxFiles) {
		this.maxFiles = maxFiles;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("acceptedFileTypes")
	public UiFileField setAcceptedFileTypes(List<String> acceptedFileTypes) {
		this.acceptedFileTypes = acceptedFileTypes;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showEntriesAsButtonsOnHover")
	public UiFileField setShowEntriesAsButtonsOnHover(boolean showEntriesAsButtonsOnHover) {
		this.showEntriesAsButtonsOnHover = showEntriesAsButtonsOnHover;
		return this;
	}

	public static class UploadTooLargeEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadTooLargeEvent() {
			// default constructor for Jackson
		}

		public UploadTooLargeEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_FILE_FIELD_UPLOAD_TOO_LARGE;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("fileItemUuid=" + fileItemUuid).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

	}

	public static class UploadStartedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;
		protected int incompleteUploadsCount;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadStartedEvent() {
			// default constructor for Jackson
		}

		public UploadStartedEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
			this.incompleteUploadsCount = incompleteUploadsCount;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_FILE_FIELD_UPLOAD_STARTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("fileItemUuid=" + fileItemUuid).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes).append(", ")
					.append("incompleteUploadsCount=" + incompleteUploadsCount)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("incompleteUploadsCount")
		public int getIncompleteUploadsCount() {
			return incompleteUploadsCount;
		}

	}

	public static class UploadCanceledEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;
		protected int incompleteUploadsCount;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadCanceledEvent() {
			// default constructor for Jackson
		}

		public UploadCanceledEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
			this.incompleteUploadsCount = incompleteUploadsCount;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_FILE_FIELD_UPLOAD_CANCELED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("fileItemUuid=" + fileItemUuid).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes).append(", ")
					.append("incompleteUploadsCount=" + incompleteUploadsCount)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("incompleteUploadsCount")
		public int getIncompleteUploadsCount() {
			return incompleteUploadsCount;
		}

	}

	public static class UploadFailedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;
		protected int incompleteUploadsCount;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadFailedEvent() {
			// default constructor for Jackson
		}

		public UploadFailedEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
			this.incompleteUploadsCount = incompleteUploadsCount;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_FILE_FIELD_UPLOAD_FAILED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("fileItemUuid=" + fileItemUuid).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes).append(", ")
					.append("incompleteUploadsCount=" + incompleteUploadsCount)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("incompleteUploadsCount")
		public int getIncompleteUploadsCount() {
			return incompleteUploadsCount;
		}

	}

	public static class UploadSuccessfulEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;
		protected String uploadedFileUuid;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;
		protected int incompleteUploadsCount;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadSuccessfulEvent() {
			// default constructor for Jackson
		}

		public UploadSuccessfulEvent(String componentId, String fileItemUuid, String uploadedFileUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
			this.uploadedFileUuid = uploadedFileUuid;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
			this.incompleteUploadsCount = incompleteUploadsCount;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_FILE_FIELD_UPLOAD_SUCCESSFUL;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("fileItemUuid=" + fileItemUuid).append(", ")
					.append("uploadedFileUuid=" + uploadedFileUuid).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes).append(", ")
					.append("incompleteUploadsCount=" + incompleteUploadsCount)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uploadedFileUuid")
		public String getUploadedFileUuid() {
			return uploadedFileUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("incompleteUploadsCount")
		public int getIncompleteUploadsCount() {
			return incompleteUploadsCount;
		}

	}

	public static class FileItemClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int clientId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public FileItemClickedEvent() {
			// default constructor for Jackson
		}

		public FileItemClickedEvent(String componentId, int clientId) {
			this.componentId = componentId;
			this.clientId = clientId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_FILE_FIELD_FILE_ITEM_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("clientId=" + clientId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("clientId")
		public int getClientId() {
			return clientId;
		}

	}

	public static class FileItemRemoveButtonClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int clientId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public FileItemRemoveButtonClickedEvent() {
			// default constructor for Jackson
		}

		public FileItemRemoveButtonClickedEvent(String componentId, int clientId) {
			this.componentId = componentId;
			this.clientId = clientId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_FILE_FIELD_FILE_ITEM_REMOVE_BUTTON_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("clientId=" + clientId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("clientId")
		public int getClientId() {
			return clientId;
		}

	}


	public static class ReplaceFileItemCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;
		protected UiIdentifiableClientRecord data;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ReplaceFileItemCommand() {
			// default constructor for Jackson
		}

		public ReplaceFileItemCommand(String componentId, String fileItemUuid, UiIdentifiableClientRecord data) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
			this.data = data;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileItemUuid=" + fileItemUuid).append(", ")
					.append(data != null ? "data={" + data.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("data")
		public UiIdentifiableClientRecord getData() {
			return data;
		}

	}

	public static class SetItemTemplateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiTemplate itemTemplate;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetItemTemplateCommand() {
			// default constructor for Jackson
		}

		public SetItemTemplateCommand(String componentId, UiTemplate itemTemplate) {
			this.componentId = componentId;
			this.itemTemplate = itemTemplate;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(itemTemplate != null ? "itemTemplate={" + itemTemplate.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("itemTemplate")
		public UiTemplate getItemTemplate() {
			return itemTemplate;
		}

	}

	public static class SetMaxBytesPerFileCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected long maxBytesPerFile;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMaxBytesPerFileCommand() {
			// default constructor for Jackson
		}

		public SetMaxBytesPerFileCommand(String componentId, long maxBytesPerFile) {
			this.componentId = componentId;
			this.maxBytesPerFile = maxBytesPerFile;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("maxBytesPerFile=" + maxBytesPerFile)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("maxBytesPerFile")
		public long getMaxBytesPerFile() {
			return maxBytesPerFile;
		}

	}

	public static class SetUploadUrlCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String uploadUrl;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetUploadUrlCommand() {
			// default constructor for Jackson
		}

		public SetUploadUrlCommand(String componentId, String uploadUrl) {
			this.componentId = componentId;
			this.uploadUrl = uploadUrl;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("uploadUrl=" + uploadUrl)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uploadUrl")
		public String getUploadUrl() {
			return uploadUrl;
		}

	}

	public static class SetDisplayTypeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiFileFieldDisplayType displayType;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetDisplayTypeCommand() {
			// default constructor for Jackson
		}

		public SetDisplayTypeCommand(String componentId, UiFileFieldDisplayType displayType) {
			this.componentId = componentId;
			this.displayType = displayType;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("displayType=" + displayType)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("displayType")
		public UiFileFieldDisplayType getDisplayType() {
			return displayType;
		}

	}

	public static class SetMaxFilesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int maxFiles;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMaxFilesCommand() {
			// default constructor for Jackson
		}

		public SetMaxFilesCommand(String componentId, int maxFiles) {
			this.componentId = componentId;
			this.maxFiles = maxFiles;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("maxFiles=" + maxFiles)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("maxFiles")
		public int getMaxFiles() {
			return maxFiles;
		}

	}

	public static class SetAcceptedFileTypesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<String> acceptedFileTypes;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetAcceptedFileTypesCommand() {
			// default constructor for Jackson
		}

		public SetAcceptedFileTypesCommand(String componentId, List<String> acceptedFileTypes) {
			this.componentId = componentId;
			this.acceptedFileTypes = acceptedFileTypes;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("acceptedFileTypes=" + acceptedFileTypes)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("acceptedFileTypes")
		public List<String> getAcceptedFileTypes() {
			return acceptedFileTypes;
		}

	}

	public static class SetUploadButtonTemplateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiTemplate uploadButtonTemplate;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetUploadButtonTemplateCommand() {
			// default constructor for Jackson
		}

		public SetUploadButtonTemplateCommand(String componentId, UiTemplate uploadButtonTemplate) {
			this.componentId = componentId;
			this.uploadButtonTemplate = uploadButtonTemplate;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(uploadButtonTemplate != null ? "uploadButtonTemplate={" + uploadButtonTemplate.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uploadButtonTemplate")
		public UiTemplate getUploadButtonTemplate() {
			return uploadButtonTemplate;
		}

	}

	public static class SetUploadButtonDataCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		@JsonSerialize(using = ObjectSerializer.class)
		@JsonDeserialize(using = ObjectDeserializer.class)
		protected Object uploadButtonData;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetUploadButtonDataCommand() {
			// default constructor for Jackson
		}

		public SetUploadButtonDataCommand(String componentId, Object uploadButtonData) {
			this.componentId = componentId;
			this.uploadButtonData = uploadButtonData;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("uploadButtonData=" + uploadButtonData)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uploadButtonData")
		public Object getUploadButtonData() {
			return uploadButtonData;
		}

	}

	public static class SetShowEntriesAsButtonsOnHoverCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean showEntriesAsButtonsOnHover;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetShowEntriesAsButtonsOnHoverCommand() {
			// default constructor for Jackson
		}

		public SetShowEntriesAsButtonsOnHoverCommand(String componentId, boolean showEntriesAsButtonsOnHover) {
			this.componentId = componentId;
			this.showEntriesAsButtonsOnHover = showEntriesAsButtonsOnHover;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("showEntriesAsButtonsOnHover=" + showEntriesAsButtonsOnHover)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("showEntriesAsButtonsOnHover")
		public boolean getShowEntriesAsButtonsOnHover() {
			return showEntriesAsButtonsOnHover;
		}

	}

	public static class CancelAllUploadsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CancelAllUploadsCommand() {
			// default constructor for Jackson
		}

		public CancelAllUploadsCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class CancelUploadCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CancelUploadCommand() {
			// default constructor for Jackson
		}

		public CancelUploadCommand(String componentId, String fileItemUuid) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileItemUuid=" + fileItemUuid)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

	}

}