package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type", defaultImpl = UiPageView.class)
public class UiPageView extends UiComponent implements UiObject {


	protected List<UiPageViewBlock> blocks;

	public UiPageView() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_PAGE_VIEW;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append(blocks != null ? "blocks={" + blocks.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("blocks")
	public List<UiPageViewBlock> getBlocks() {
		return blocks;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiPageView setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiPageView setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiPageView setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiPageView setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiPageView setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiPageView setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("blocks")
	public UiPageView setBlocks(List<UiPageViewBlock> blocks) {
		this.blocks = blocks;
		return this;
	}



	public static class AddBlockCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiPageViewBlock block;
		protected boolean before;
		protected String otherBlockId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddBlockCommand() {
			// default constructor for Jackson
		}

		public AddBlockCommand(String componentId, UiPageViewBlock block, boolean before, String otherBlockId) {
			this.componentId = componentId;
			this.block = block;
			this.before = before;
			this.otherBlockId = otherBlockId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("otherBlockId=" + otherBlockId).append(", ")
					.append("before=" + before).append(", ")
					.append(block != null ? "block={" + block.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("block")
		public UiPageViewBlock getBlock() {
			return block;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("before")
		public boolean getBefore() {
			return before;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("otherBlockId")
		public String getOtherBlockId() {
			return otherBlockId;
		}

	}

	public static class RemoveBlockCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String blockId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveBlockCommand() {
			// default constructor for Jackson
		}

		public RemoveBlockCommand(String componentId, String blockId) {
			this.componentId = componentId;
			this.blockId = blockId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("blockId=" + blockId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("blockId")
		public String getBlockId() {
			return blockId;
		}

	}

}