/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiPosterImageSize;
import org.teamapps.dto.UiShakaManifest;
import org.teamapps.dto.UiShakaPlayerControlPanelElementType;
import org.teamapps.dto.UiTrackLabelFormat;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiShakaPlayer.class)
public class UiShakaPlayer
extends UiComponent
implements UiObject {
    protected String hlsUrl;
    protected String dashUrl;
    protected String posterImageUrl;
    protected UiPosterImageSize posterImageSize = UiPosterImageSize.CONTAIN;
    protected int timeUpdateEventThrottleMillis;
    protected String backgroundColor;
    protected boolean autoplay;
    protected UiTrackLabelFormat trackLabelFormat;
    protected boolean videoDisabled;
    protected long timeMillis;
    protected String preferredAudioLanguage;
    protected boolean bigPlayButtonEnabled;
    protected int controlFadeDelaySeconds;
    protected List<UiShakaPlayerControlPanelElementType> controlPanelElements;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_SHAKA_PLAYER;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + String.valueOf(this.classNamesBySelector)) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + String.valueOf(this.stylesBySelector)) + ", " + ("attributesBySelector=" + String.valueOf(this.attributesBySelector)) + ", " + ("hlsUrl=" + this.hlsUrl) + ", " + ("dashUrl=" + this.dashUrl) + ", " + ("posterImageUrl=" + this.posterImageUrl) + ", " + ("posterImageSize=" + String.valueOf((Object)this.posterImageSize)) + ", " + ("timeUpdateEventThrottleMillis=" + this.timeUpdateEventThrottleMillis) + ", " + ("backgroundColor=" + this.backgroundColor) + ", " + ("autoplay=" + this.autoplay) + ", " + ("trackLabelFormat=" + String.valueOf((Object)this.trackLabelFormat)) + ", " + ("videoDisabled=" + this.videoDisabled) + ", " + ("timeMillis=" + this.timeMillis) + ", " + ("preferredAudioLanguage=" + this.preferredAudioLanguage) + ", " + ("bigPlayButtonEnabled=" + this.bigPlayButtonEnabled) + ", " + ("controlFadeDelaySeconds=" + this.controlFadeDelaySeconds) + ", " + ("controlPanelElements=" + String.valueOf(this.controlPanelElements));
    }

    @JsonGetter(value="hlsUrl")
    public String getHlsUrl() {
        return this.hlsUrl;
    }

    @JsonGetter(value="dashUrl")
    public String getDashUrl() {
        return this.dashUrl;
    }

    @JsonGetter(value="posterImageUrl")
    public String getPosterImageUrl() {
        return this.posterImageUrl;
    }

    @JsonGetter(value="posterImageSize")
    public UiPosterImageSize getPosterImageSize() {
        return this.posterImageSize;
    }

    @JsonGetter(value="timeUpdateEventThrottleMillis")
    public int getTimeUpdateEventThrottleMillis() {
        return this.timeUpdateEventThrottleMillis;
    }

    @JsonGetter(value="backgroundColor")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonGetter(value="autoplay")
    public boolean getAutoplay() {
        return this.autoplay;
    }

    @JsonGetter(value="trackLabelFormat")
    public UiTrackLabelFormat getTrackLabelFormat() {
        return this.trackLabelFormat;
    }

    @JsonGetter(value="videoDisabled")
    public boolean getVideoDisabled() {
        return this.videoDisabled;
    }

    @JsonGetter(value="timeMillis")
    public long getTimeMillis() {
        return this.timeMillis;
    }

    @JsonGetter(value="preferredAudioLanguage")
    public String getPreferredAudioLanguage() {
        return this.preferredAudioLanguage;
    }

    @JsonGetter(value="bigPlayButtonEnabled")
    public boolean getBigPlayButtonEnabled() {
        return this.bigPlayButtonEnabled;
    }

    @JsonGetter(value="controlFadeDelaySeconds")
    public int getControlFadeDelaySeconds() {
        return this.controlFadeDelaySeconds;
    }

    @JsonGetter(value="controlPanelElements")
    public List<UiShakaPlayerControlPanelElementType> getControlPanelElements() {
        return this.controlPanelElements;
    }

    @Override
    @JsonSetter(value="id")
    public UiShakaPlayer setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiShakaPlayer setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiShakaPlayer setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiShakaPlayer setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiShakaPlayer setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiShakaPlayer setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="hlsUrl")
    public UiShakaPlayer setHlsUrl(String hlsUrl) {
        this.hlsUrl = hlsUrl;
        return this;
    }

    @JsonSetter(value="dashUrl")
    public UiShakaPlayer setDashUrl(String dashUrl) {
        this.dashUrl = dashUrl;
        return this;
    }

    @JsonSetter(value="posterImageUrl")
    public UiShakaPlayer setPosterImageUrl(String posterImageUrl) {
        this.posterImageUrl = posterImageUrl;
        return this;
    }

    @JsonSetter(value="posterImageSize")
    public UiShakaPlayer setPosterImageSize(UiPosterImageSize posterImageSize) {
        this.posterImageSize = posterImageSize;
        return this;
    }

    @JsonSetter(value="timeUpdateEventThrottleMillis")
    public UiShakaPlayer setTimeUpdateEventThrottleMillis(int timeUpdateEventThrottleMillis) {
        this.timeUpdateEventThrottleMillis = timeUpdateEventThrottleMillis;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public UiShakaPlayer setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="autoplay")
    public UiShakaPlayer setAutoplay(boolean autoplay) {
        this.autoplay = autoplay;
        return this;
    }

    @JsonSetter(value="trackLabelFormat")
    public UiShakaPlayer setTrackLabelFormat(UiTrackLabelFormat trackLabelFormat) {
        this.trackLabelFormat = trackLabelFormat;
        return this;
    }

    @JsonSetter(value="videoDisabled")
    public UiShakaPlayer setVideoDisabled(boolean videoDisabled) {
        this.videoDisabled = videoDisabled;
        return this;
    }

    @JsonSetter(value="timeMillis")
    public UiShakaPlayer setTimeMillis(long timeMillis) {
        this.timeMillis = timeMillis;
        return this;
    }

    @JsonSetter(value="preferredAudioLanguage")
    public UiShakaPlayer setPreferredAudioLanguage(String preferredAudioLanguage) {
        this.preferredAudioLanguage = preferredAudioLanguage;
        return this;
    }

    @JsonSetter(value="bigPlayButtonEnabled")
    public UiShakaPlayer setBigPlayButtonEnabled(boolean bigPlayButtonEnabled) {
        this.bigPlayButtonEnabled = bigPlayButtonEnabled;
        return this;
    }

    @JsonSetter(value="controlFadeDelaySeconds")
    public UiShakaPlayer setControlFadeDelaySeconds(int controlFadeDelaySeconds) {
        this.controlFadeDelaySeconds = controlFadeDelaySeconds;
        return this;
    }

    @JsonSetter(value="controlPanelElements")
    public UiShakaPlayer setControlPanelElements(List<UiShakaPlayerControlPanelElementType> controlPanelElements) {
        this.controlPanelElements = controlPanelElements;
        return this;
    }

    public static class SetDistinctManifestAudioTracksFixEnabledCommand
    implements UiCommand<Void> {
        protected boolean enabled;

        @Deprecated
        public SetDistinctManifestAudioTracksFixEnabledCommand() {
        }

        public SetDistinctManifestAudioTracksFixEnabledCommand(boolean enabled) {
            this.enabled = enabled;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("enabled=" + this.enabled);
        }

        @JsonGetter(value="enabled")
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SelectAudioLanguageCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String language;
        protected String role;

        @Deprecated
        public SelectAudioLanguageCommand() {
        }

        public SelectAudioLanguageCommand(String componentId, String language, String role) {
            this.componentId = componentId;
            this.language = language;
            this.role = role;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("language=" + this.language) + ", " + ("role=" + this.role);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="language")
        public String getLanguage() {
            return this.language;
        }

        @JsonGetter(value="role")
        public String getRole() {
            return this.role;
        }
    }

    public static class JumpToCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected long timeMillis;

        @Deprecated
        public JumpToCommand() {
        }

        public JumpToCommand(String componentId, long timeMillis) {
            this.componentId = componentId;
            this.timeMillis = timeMillis;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("timeMillis=" + this.timeMillis);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="timeMillis")
        public long getTimeMillis() {
            return this.timeMillis;
        }
    }

    public static class PauseCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public PauseCommand() {
        }

        public PauseCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class PlayCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public PlayCommand() {
        }

        public PlayCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class SetUrlsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String hlsUrl;
        protected String dashUrl;

        @Deprecated
        public SetUrlsCommand() {
        }

        public SetUrlsCommand(String componentId, String hlsUrl, String dashUrl) {
            this.componentId = componentId;
            this.hlsUrl = hlsUrl;
            this.dashUrl = dashUrl;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("hlsUrl=" + this.hlsUrl) + ", " + ("dashUrl=" + this.dashUrl);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="hlsUrl")
        public String getHlsUrl() {
            return this.hlsUrl;
        }

        @JsonGetter(value="dashUrl")
        public String getDashUrl() {
            return this.dashUrl;
        }
    }

    public static class SkipClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected boolean forward;
        protected long playbackTimeMillis;

        @Deprecated
        public SkipClickedEvent() {
        }

        public SkipClickedEvent(String componentId, boolean forward, long playbackTimeMillis) {
            this.componentId = componentId;
            this.forward = forward;
            this.playbackTimeMillis = playbackTimeMillis;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_SHAKA_PLAYER_SKIP_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("forward=" + this.forward) + ", " + ("playbackTimeMillis=" + this.playbackTimeMillis);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="forward")
        public boolean getForward() {
            return this.forward;
        }

        @JsonGetter(value="playbackTimeMillis")
        public long getPlaybackTimeMillis() {
            return this.playbackTimeMillis;
        }
    }

    public static class EndedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public EndedEvent() {
        }

        public EndedEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_SHAKA_PLAYER_ENDED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class TimeUpdateEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected long timeMillis;

        @Deprecated
        public TimeUpdateEvent() {
        }

        public TimeUpdateEvent(String componentId, long timeMillis) {
            this.componentId = componentId;
            this.timeMillis = timeMillis;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_SHAKA_PLAYER_TIME_UPDATE;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("timeMillis=" + this.timeMillis);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="timeMillis")
        public long getTimeMillis() {
            return this.timeMillis;
        }
    }

    public static class ManifestLoadedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiShakaManifest manifest;

        @Deprecated
        public ManifestLoadedEvent() {
        }

        public ManifestLoadedEvent(String componentId, UiShakaManifest manifest) {
            this.componentId = componentId;
            this.manifest = manifest;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_SHAKA_PLAYER_MANIFEST_LOADED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.manifest != null ? "manifest={" + this.manifest.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="manifest")
        public UiShakaManifest getManifest() {
            return this.manifest;
        }
    }

    public static class ErrorLoadingEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public ErrorLoadingEvent() {
        }

        public ErrorLoadingEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_SHAKA_PLAYER_ERROR_LOADING;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }
}

