/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiSpecialKey;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public interface UiTextInputHandlingField
extends UiObject {

    public static class SpecialKeyPressedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiSpecialKey key;

        @Deprecated
        public SpecialKeyPressedEvent() {
        }

        public SpecialKeyPressedEvent(String componentId, UiSpecialKey key) {
            this.componentId = componentId;
            this.key = key;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TEXT_INPUT_HANDLING_FIELD_SPECIAL_KEY_PRESSED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("key=" + String.valueOf((Object)this.key));
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="key")
        public UiSpecialKey getKey() {
            return this.key;
        }
    }

    public static class TextInputEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String enteredString;

        @Deprecated
        public TextInputEvent() {
        }

        public TextInputEvent(String componentId, String enteredString) {
            this.componentId = componentId;
            this.enteredString = enteredString;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TEXT_INPUT_HANDLING_FIELD_TEXT_INPUT;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("enteredString=" + this.enteredString);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="enteredString")
        public String getEnteredString() {
            return this.enteredString;
        }
    }
}

