/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiHorizontalElementAlignment;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiSpacing;
import org.teamapps.dto.UiVerticalElementAlignment;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class AbstractUiTemplateElement
implements UiObject {
    protected String property;
    protected int row;
    protected int column;
    protected int rowSpan = 1;
    protected int colSpan = 1;
    protected UiHorizontalElementAlignment horizontalAlignment = UiHorizontalElementAlignment.LEFT;
    protected UiVerticalElementAlignment verticalAlignment = UiVerticalElementAlignment.CENTER;
    protected UiSpacing margin;
    protected String backgroundColor;

    @Deprecated
    public AbstractUiTemplateElement() {
    }

    public AbstractUiTemplateElement(String property, int row, int column) {
        this.property = property;
        this.row = row;
        this.column = column;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("property=" + this.property) + ", " + ("row=" + this.row) + ", " + ("column=" + this.column) + ", " + ("rowSpan=" + this.rowSpan) + ", " + ("colSpan=" + this.colSpan) + ", " + ("horizontalAlignment=" + String.valueOf((Object)this.horizontalAlignment)) + ", " + ("verticalAlignment=" + String.valueOf((Object)this.verticalAlignment)) + ", " + ("backgroundColor=" + this.backgroundColor) + ", " + (String)(this.margin != null ? "margin={" + this.margin.toString() + "}" : "");
    }

    @JsonGetter(value="property")
    public String getProperty() {
        return this.property;
    }

    @JsonGetter(value="row")
    public int getRow() {
        return this.row;
    }

    @JsonGetter(value="column")
    public int getColumn() {
        return this.column;
    }

    @JsonGetter(value="rowSpan")
    public int getRowSpan() {
        return this.rowSpan;
    }

    @JsonGetter(value="colSpan")
    public int getColSpan() {
        return this.colSpan;
    }

    @JsonGetter(value="horizontalAlignment")
    public UiHorizontalElementAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @JsonGetter(value="verticalAlignment")
    public UiVerticalElementAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @JsonGetter(value="margin")
    public UiSpacing getMargin() {
        return this.margin;
    }

    @JsonGetter(value="backgroundColor")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonSetter(value="rowSpan")
    public AbstractUiTemplateElement setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
        return this;
    }

    @JsonSetter(value="colSpan")
    public AbstractUiTemplateElement setColSpan(int colSpan) {
        this.colSpan = colSpan;
        return this;
    }

    @JsonSetter(value="horizontalAlignment")
    public AbstractUiTemplateElement setHorizontalAlignment(UiHorizontalElementAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @JsonSetter(value="verticalAlignment")
    public AbstractUiTemplateElement setVerticalAlignment(UiVerticalElementAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @JsonSetter(value="margin")
    public AbstractUiTemplateElement setMargin(UiSpacing margin) {
        this.margin = margin;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public AbstractUiTemplateElement setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }
}

