package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type", defaultImpl = UiNotification.class)
public class UiNotification extends UiComponent implements UiObject {


	protected String backgroundColor;
	protected UiSpacing padding;
	protected boolean dismissible = true;
	protected int displayTimeInMillis = 3000;
	protected boolean progressBarVisible = false;
	protected UiClientObjectReference content;
	protected int contentHeight = 0;

	public UiNotification() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_NOTIFICATION;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("backgroundColor=" + backgroundColor).append(", ")
				.append("dismissible=" + dismissible).append(", ")
				.append("displayTimeInMillis=" + displayTimeInMillis).append(", ")
				.append("progressBarVisible=" + progressBarVisible).append(", ")
				.append("contentHeight=" + contentHeight).append(", ")
				.append(padding != null ? "padding={" + padding.toString() + "}" : "").append(", ")
				.append(content != null ? "content={" + content.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public String getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("padding")
	public UiSpacing getPadding() {
		return padding;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("dismissible")
	public boolean getDismissible() {
		return dismissible;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("displayTimeInMillis")
	public int getDisplayTimeInMillis() {
		return displayTimeInMillis;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("progressBarVisible")
	public boolean getProgressBarVisible() {
		return progressBarVisible;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("content")
	public UiClientObjectReference getContent() {
		return content;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("contentHeight")
	public int getContentHeight() {
		return contentHeight;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiNotification setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiNotification setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiNotification setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiNotification setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiNotification setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiNotification setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiNotification setBackgroundColor(String backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("padding")
	public UiNotification setPadding(UiSpacing padding) {
		this.padding = padding;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("dismissible")
	public UiNotification setDismissible(boolean dismissible) {
		this.dismissible = dismissible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("displayTimeInMillis")
	public UiNotification setDisplayTimeInMillis(int displayTimeInMillis) {
		this.displayTimeInMillis = displayTimeInMillis;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("progressBarVisible")
	public UiNotification setProgressBarVisible(boolean progressBarVisible) {
		this.progressBarVisible = progressBarVisible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("content")
	public UiNotification setContent(UiClientObjectReference content) {
		this.content = content;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("contentHeight")
	public UiNotification setContentHeight(int contentHeight) {
		this.contentHeight = contentHeight;
		return this;
	}

	public static class OpenedEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public OpenedEvent() {
			// default constructor for Jackson
		}

		public OpenedEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_NOTIFICATION_OPENED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class ClosedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected boolean byUser;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ClosedEvent() {
			// default constructor for Jackson
		}

		public ClosedEvent(String componentId, boolean byUser) {
			this.componentId = componentId;
			this.byUser = byUser;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_NOTIFICATION_CLOSED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("byUser=" + byUser)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("byUser")
		public boolean getByUser() {
			return byUser;
		}

	}


	public static class CloseCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CloseCommand() {
			// default constructor for Jackson
		}

		public CloseCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class UpdateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiNotification config;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateCommand() {
			// default constructor for Jackson
		}

		public UpdateCommand(String componentId, UiNotification config) {
			this.componentId = componentId;
			this.config = config;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(config != null ? "config={" + config.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("config")
		public UiNotification getConfig() {
			return config;
		}

	}

}