/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiComponentReference;
import org.teamapps.dto.UiCssAlignItems;
import org.teamapps.dto.UiCssFlexDirection;
import org.teamapps.dto.UiCssJustifyContent;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiFlexContainer
extends UiComponent
implements UiObject {
    protected List<UiComponentReference> components;
    protected UiCssFlexDirection flexDirection = UiCssFlexDirection.ROW;
    protected UiCssAlignItems alignItems = UiCssAlignItems.STRETCH;
    protected UiCssJustifyContent justifyContent = UiCssJustifyContent.FLEX_START;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_FLEX_CONTAINER;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("flexDirection=" + this.flexDirection) + ", " + ("alignItems=" + this.alignItems) + ", " + ("justifyContent=" + this.justifyContent) + ", " + (String)(this.components != null ? "components={" + this.components.toString() + "}" : "");
    }

    @JsonGetter(value="components")
    public List<UiComponentReference> getComponents() {
        return this.components;
    }

    @JsonGetter(value="flexDirection")
    public UiCssFlexDirection getFlexDirection() {
        return this.flexDirection;
    }

    @JsonGetter(value="alignItems")
    public UiCssAlignItems getAlignItems() {
        return this.alignItems;
    }

    @JsonGetter(value="justifyContent")
    public UiCssJustifyContent getJustifyContent() {
        return this.justifyContent;
    }

    @Override
    @JsonSetter(value="id")
    public UiFlexContainer setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiFlexContainer setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiFlexContainer setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="components")
    public UiFlexContainer setComponents(List<UiComponentReference> components) {
        this.components = components;
        return this;
    }

    @JsonSetter(value="flexDirection")
    public UiFlexContainer setFlexDirection(UiCssFlexDirection flexDirection) {
        this.flexDirection = flexDirection;
        return this;
    }

    @JsonSetter(value="alignItems")
    public UiFlexContainer setAlignItems(UiCssAlignItems alignItems) {
        this.alignItems = alignItems;
        return this;
    }

    @JsonSetter(value="justifyContent")
    public UiFlexContainer setJustifyContent(UiCssJustifyContent justifyContent) {
        this.justifyContent = justifyContent;
        return this;
    }

    public static class RemoveComponentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiComponentReference component;

        @Deprecated
        public RemoveComponentCommand() {
        }

        public RemoveComponentCommand(String componentId, UiComponentReference component) {
            this.componentId = componentId;
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="component")
        public UiComponentReference getComponent() {
            return this.component;
        }
    }

    public static class AddComponentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiComponentReference component;

        @Deprecated
        public AddComponentCommand() {
        }

        public AddComponentCommand(String componentId, UiComponentReference component) {
            this.componentId = componentId;
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="component")
        public UiComponentReference getComponent() {
            return this.component;
        }
    }
}

