/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiCollapsible.class)
public class UiCollapsible
extends UiComponent
implements UiObject {
    protected String icon;
    protected String caption;
    protected UiClientObjectReference content;
    protected boolean collapsed;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_COLLAPSIBLE;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + String.valueOf(this.classNamesBySelector)) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + String.valueOf(this.stylesBySelector)) + ", " + ("attributesBySelector=" + String.valueOf(this.attributesBySelector)) + ", " + ("icon=" + this.icon) + ", " + ("caption=" + this.caption) + ", " + ("collapsed=" + this.collapsed) + ", " + (String)(this.content != null ? "content={" + this.content.toString() + "}" : "");
    }

    @JsonGetter(value="icon")
    public String getIcon() {
        return this.icon;
    }

    @JsonGetter(value="caption")
    public String getCaption() {
        return this.caption;
    }

    @JsonGetter(value="content")
    public UiClientObjectReference getContent() {
        return this.content;
    }

    @JsonGetter(value="collapsed")
    public boolean getCollapsed() {
        return this.collapsed;
    }

    @Override
    @JsonSetter(value="id")
    public UiCollapsible setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiCollapsible setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiCollapsible setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiCollapsible setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiCollapsible setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiCollapsible setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="icon")
    public UiCollapsible setIcon(String icon) {
        this.icon = icon;
        return this;
    }

    @JsonSetter(value="caption")
    public UiCollapsible setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    @JsonSetter(value="content")
    public UiCollapsible setContent(UiClientObjectReference content) {
        this.content = content;
        return this;
    }

    @JsonSetter(value="collapsed")
    public UiCollapsible setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
        return this;
    }

    public static class SetCollapsedCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean collapsed;

        @Deprecated
        public SetCollapsedCommand() {
        }

        public SetCollapsedCommand(String componentId, boolean collapsed) {
            this.componentId = componentId;
            this.collapsed = collapsed;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("collapsed=" + this.collapsed);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="collapsed")
        public boolean getCollapsed() {
            return this.collapsed;
        }
    }

    public static class SetIconAndCaptionCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String icon;
        protected String caption;

        @Deprecated
        public SetIconAndCaptionCommand() {
        }

        public SetIconAndCaptionCommand(String componentId, String icon, String caption) {
            this.componentId = componentId;
            this.icon = icon;
            this.caption = caption;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("icon=" + this.icon) + ", " + ("caption=" + this.caption);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="icon")
        public String getIcon() {
            return this.icon;
        }

        @JsonGetter(value="caption")
        public String getCaption() {
            return this.caption;
        }
    }

    public static class SetContentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiClientObjectReference content;

        @Deprecated
        public SetContentCommand() {
        }

        public SetContentCommand(String componentId, UiClientObjectReference content) {
            this.componentId = componentId;
            this.content = content;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.content != null ? "content={" + this.content.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="content")
        public UiClientObjectReference getContent() {
            return this.content;
        }
    }

    public static class CollapseStateChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected boolean collapsed;

        @Deprecated
        public CollapseStateChangedEvent() {
        }

        public CollapseStateChangedEvent(String componentId, boolean collapsed) {
            this.componentId = componentId;
            this.collapsed = collapsed;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_COLLAPSIBLE_COLLAPSE_STATE_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("collapsed=" + this.collapsed);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="collapsed")
        public boolean getCollapsed() {
            return this.collapsed;
        }
    }
}

