package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type", defaultImpl = UiCollapsible.class)
public class UiCollapsible extends UiComponent implements UiObject {


	protected String icon;
	protected String caption;
	protected UiClientObjectReference content;
	protected boolean collapsed;

	public UiCollapsible() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_COLLAPSIBLE;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("icon=" + icon).append(", ")
				.append("caption=" + caption).append(", ")
				.append("collapsed=" + collapsed).append(", ")
				.append(content != null ? "content={" + content.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("icon")
	public String getIcon() {
		return icon;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("caption")
	public String getCaption() {
		return caption;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("content")
	public UiClientObjectReference getContent() {
		return content;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("collapsed")
	public boolean getCollapsed() {
		return collapsed;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiCollapsible setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiCollapsible setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiCollapsible setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiCollapsible setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiCollapsible setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiCollapsible setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("icon")
	public UiCollapsible setIcon(String icon) {
		this.icon = icon;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("caption")
	public UiCollapsible setCaption(String caption) {
		this.caption = caption;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("content")
	public UiCollapsible setContent(UiClientObjectReference content) {
		this.content = content;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("collapsed")
	public UiCollapsible setCollapsed(boolean collapsed) {
		this.collapsed = collapsed;
		return this;
	}

	public static class CollapseStateChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected boolean collapsed;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CollapseStateChangedEvent() {
			// default constructor for Jackson
		}

		public CollapseStateChangedEvent(String componentId, boolean collapsed) {
			this.componentId = componentId;
			this.collapsed = collapsed;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_COLLAPSIBLE_COLLAPSE_STATE_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("collapsed=" + collapsed)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("collapsed")
		public boolean getCollapsed() {
			return collapsed;
		}

	}


	public static class SetContentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiClientObjectReference content;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetContentCommand() {
			// default constructor for Jackson
		}

		public SetContentCommand(String componentId, UiClientObjectReference content) {
			this.componentId = componentId;
			this.content = content;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(content != null ? "content={" + content.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("content")
		public UiClientObjectReference getContent() {
			return content;
		}

	}

	public static class SetIconAndCaptionCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String icon;
		protected String caption;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetIconAndCaptionCommand() {
			// default constructor for Jackson
		}

		public SetIconAndCaptionCommand(String componentId, String icon, String caption) {
			this.componentId = componentId;
			this.icon = icon;
			this.caption = caption;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("icon=" + icon).append(", ")
					.append("caption=" + caption)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("icon")
		public String getIcon() {
			return icon;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("caption")
		public String getCaption() {
			return caption;
		}

	}

	public static class SetCollapsedCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean collapsed;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetCollapsedCommand() {
			// default constructor for Jackson
		}

		public SetCollapsedCommand(String componentId, boolean collapsed) {
			this.componentId = componentId;
			this.collapsed = collapsed;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("collapsed=" + collapsed)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("collapsed")
		public boolean getCollapsed() {
			return collapsed;
		}

	}

}