/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiObject;

public class ObjectDeserializer
extends JsonDeserializer<Object> {
    private final StdTypeResolverBuilder typeResolverBuilder = new ObjectMapper.DefaultTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL).inclusion(JsonTypeInfo.As.PROPERTY).init(JsonTypeInfo.Id.CLASS, (TypeIdResolver)new TeamAppsJacksonTypeIdResolver()).typeProperty("_type");
    private TypeIdResolver typeIdResolver;

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (p.isExpectedStartArrayToken()) {
            JsonToken t;
            ArrayList<Object> list = new ArrayList<Object>();
            p.setCurrentValue(list);
            while ((t = p.nextToken()) != JsonToken.END_ARRAY) {
                Object value = t == JsonToken.VALUE_NULL ? null : this.deserialize(p, ctxt);
                list.add(value);
            }
            return list;
        }
        if (p.isExpectedStartObjectToken()) {
            JsonToken t = p.nextToken();
            if (t == JsonToken.FIELD_NAME) {
                String name = p.getCurrentName();
                if (name.equals("_type")) {
                    JavaType javaType;
                    Class rawClass;
                    p.nextToken();
                    if (this.typeIdResolver == null) {
                        this.typeIdResolver = this.typeResolverBuilder.buildTypeDeserializer(ctxt.getConfig(), ctxt.constructType(Object.class), null).getTypeIdResolver();
                    }
                    if (UiObject.class.isAssignableFrom(rawClass = (javaType = this.typeIdResolver.typeFromId((DatabindContext)ctxt, p.getText())).getRawClass())) {
                        TokenBuffer tb = new TokenBuffer(p, ctxt);
                        tb.writeStartObject();
                        tb.writeFieldName("_type");
                        tb.copyCurrentStructure(p);
                        p = JsonParserSequence.createFlattened((boolean)false, (JsonParser)tb.asParser(p), (JsonParser)p);
                        return p.readValueAs(rawClass);
                    }
                    if (Enum.class.isAssignableFrom(rawClass)) {
                        return this.deserializeObjectStyleEnum(rawClass, p);
                    }
                    TokenBuffer tb = new TokenBuffer(p, ctxt);
                    tb.writeStartObject();
                    p = JsonParserSequence.createFlattened((boolean)false, (JsonParser)tb.asParser(p), (JsonParser)p);
                    return p.readValueAs(rawClass);
                }
                HashMap<String, Object> result = new HashMap<String, Object>();
                String key = p.getCurrentName();
                while (key != null) {
                    t = p.nextToken();
                    Object value = t == JsonToken.VALUE_NULL ? null : this.deserialize(p, ctxt);
                    result.put(key, value);
                    key = p.nextFieldName();
                }
                return result;
            }
            return new HashMap();
        }
        return p.readValueAs(Object.class);
    }

    private Enum deserializeObjectStyleEnum(Class<? extends Enum> enumClass, JsonParser p) throws IOException {
        Enum result = null;
        String key = p.nextFieldName();
        while (key != null) {
            JsonToken t = p.nextToken();
            if (key.equals("_name")) {
                String text = p.getText();
                result = Arrays.stream(enumClass.getEnumConstants()).filter(c -> c.name().equals(text)).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find enum value \"" + text + "\" in enum class " + String.valueOf(enumClass)));
            }
            key = p.nextFieldName();
        }
        if (result == null) {
            throw new IllegalArgumentException("Name (_name) of object style enum value not specified!");
        }
        return result;
    }
}

