package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiImageField extends UiField implements UiObject {


	protected int width;
	protected int height;
	protected UiBorder border;
	protected UiShadow shadow;
	protected UiImageSizing imageSizing = UiImageSizing.CONTAIN;

	public UiImageField() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_IMAGE_FIELD;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("editingMode=" + editingMode).append(", ")
				.append("value=" + value).append(", ")
				.append("width=" + width).append(", ")
				.append("height=" + height).append(", ")
				.append("imageSizing=" + imageSizing).append(", ")
				.append(fieldMessages != null ? "fieldMessages={" + fieldMessages.toString() + "}" : "").append(", ")
				.append(border != null ? "border={" + border.toString() + "}" : "").append(", ")
				.append(shadow != null ? "shadow={" + shadow.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("width")
	public int getWidth() {
		return width;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("height")
	public int getHeight() {
		return height;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("border")
	public UiBorder getBorder() {
		return border;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("shadow")
	public UiShadow getShadow() {
		return shadow;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("imageSizing")
	public UiImageSizing getImageSizing() {
		return imageSizing;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiImageField setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiImageField setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiImageField setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("editingMode")
	public UiImageField setEditingMode(UiFieldEditingMode editingMode) {
		this.editingMode = editingMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("value")
	public UiImageField setValue(Object value) {
		this.value = value;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fieldMessages")
	public UiImageField setFieldMessages(List<UiFieldMessage> fieldMessages) {
		this.fieldMessages = fieldMessages;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("width")
	public UiImageField setWidth(int width) {
		this.width = width;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("height")
	public UiImageField setHeight(int height) {
		this.height = height;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("border")
	public UiImageField setBorder(UiBorder border) {
		this.border = border;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("shadow")
	public UiImageField setShadow(UiShadow shadow) {
		this.shadow = shadow;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("imageSizing")
	public UiImageField setImageSizing(UiImageSizing imageSizing) {
		this.imageSizing = imageSizing;
		return this;
	}


	public static class SetSizeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int width;
		protected int height;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetSizeCommand() {
			// default constructor for Jackson
		}

		public SetSizeCommand(String componentId, int width, int height) {
			this.componentId = componentId;
			this.width = width;
			this.height = height;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("width=" + width).append(", ")
					.append("height=" + height)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("width")
		public int getWidth() {
			return width;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("height")
		public int getHeight() {
			return height;
		}

	}

	public static class SetBorderCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiBorder border;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBorderCommand() {
			// default constructor for Jackson
		}

		public SetBorderCommand(String componentId, UiBorder border) {
			this.componentId = componentId;
			this.border = border;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(border != null ? "border={" + border.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("border")
		public UiBorder getBorder() {
			return border;
		}

	}

	public static class SetShadowCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiShadow shadow;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetShadowCommand() {
			// default constructor for Jackson
		}

		public SetShadowCommand(String componentId, UiShadow shadow) {
			this.componentId = componentId;
			this.shadow = shadow;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(shadow != null ? "shadow={" + shadow.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("shadow")
		public UiShadow getShadow() {
			return shadow;
		}

	}

	public static class SetImageSizingCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiImageSizing imageSizing;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetImageSizingCommand() {
			// default constructor for Jackson
		}

		public SetImageSizingCommand(String componentId, UiImageSizing imageSizing) {
			this.componentId = componentId;
			this.imageSizing = imageSizing;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("imageSizing=" + imageSizing)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("imageSizing")
		public UiImageSizing getImageSizing() {
			return imageSizing;
		}

	}




}